/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.type.Name;

public class NameImplTest {
    @Test
    public void testSerialize() throws Exception {
        NameImpl name = new NameImpl("hello", "world");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(name);
        byte[] bytes = buffer.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(input);
        Name copy = (Name)in.readObject();
        Assert.assertNotSame((Object)name, (Object)copy);
        Assert.assertEquals((Object)name, (Object)copy);
    }

    @Test
    public void testCompare() {
        NameImpl scoped1 = new NameImpl("hello", "world");
        NameImpl scoped2 = new NameImpl("hello", "fred");
        NameImpl fred = new NameImpl("world");
        Assert.assertTrue((0 == scoped1.compareTo(scoped1) ? 1 : 0) != 0);
        Assert.assertTrue((0 == scoped2.compareTo(scoped2) ? 1 : 0) != 0);
        Assert.assertTrue((0 == fred.compareTo(fred) ? 1 : 0) != 0);
        Assert.assertTrue((scoped1.compareTo(scoped2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((scoped2.compareTo(scoped1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((scoped2.compareTo(scoped1) < 0 ? 1 : 0) != 0);
    }
}

