/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import junit.framework.TestCase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.collection.ClippingFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.factory.Hints;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ClippingFeatureCollectionTest
extends TestCase {
    DefaultFeatureCollection delegate;

    protected void setUp() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("foo");
        tb.add("geom", Point.class);
        tb.add("name", String.class);
        SimpleFeatureType featureType = tb.buildFeatureType();
        this.delegate = new DefaultFeatureCollection(null, featureType);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < 10; ++i) {
            b.add((Object)factory.createPoint(new Coordinate((double)i, (double)i)));
            b.add((Object)String.valueOf(i));
            SimpleFeature feature = b.buildFeature("fid." + i);
            if (i < 2) {
                feature.getUserData().put(Hints.GEOMETRY_CLIP, factory.createPoint(new Coordinate((double)(i + 1), (double)(i + 1))));
            }
            this.delegate.add(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClipping() {
        ClippingFeatureCollection clipping = new ClippingFeatureCollection((SimpleFeatureCollection)this.delegate);
        try (SimpleFeatureIterator it = clipping.features();){
            int i = 0;
            while (it.hasNext()) {
                it.next();
                ++i;
            }
            ClippingFeatureCollectionTest.assertEquals((int)8, (int)i);
        }
    }

    @Test
    public void testSize() {
        ClippingFeatureCollection clipping = new ClippingFeatureCollection((SimpleFeatureCollection)this.delegate);
        ClippingFeatureCollectionTest.assertEquals((int)8, (int)clipping.size());
    }
}

