/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.collection.TreeSetFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MedianVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.QuantileListVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.feature.visitor.SumAreaVisitor;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;

public class VisitorCalculationTest
extends DataTestCase {
    SimpleFeatureCollection empty;
    SimpleFeatureCollection fc;
    SimpleFeatureCollection invfc;
    SimpleFeatureType ft;
    SimpleFeatureCollection fc2;
    SimpleFeatureType ft2;
    SimpleFeatureCollection fc3;
    SimpleFeatureType ft3;
    SimpleFeatureCollection fc4;
    SimpleFeatureType ft4;
    SimpleFeatureCollection fc5;
    SimpleFeatureType ft5;
    SimpleFeatureCollection fc6;
    SimpleFeatureType ft6;

    public VisitorCalculationTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.empty = new DefaultFeatureCollection();
        this.fc = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        this.invfc = new TreeSetFeatureCollection((FeatureCollection)this.fc).sort(SortBy.REVERSE_ORDER);
        this.fc2 = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.ft = this.roadType;
        this.ft2 = this.riverType;
        SimpleFeatureType boringType = DataUtilities.createType((String)"fc3.boring", (String)"id:0");
        SimpleFeature[] boringFeatures = new SimpleFeature[100];
        for (int i = 1; i <= 100; ++i) {
            boringFeatures[i - 1] = SimpleFeatureBuilder.build((SimpleFeatureType)boringType, (Object[])new Object[]{i}, null);
        }
        this.ft3 = boringType;
        this.fc3 = DataUtilities.collection((SimpleFeature[])boringFeatures);
        this.ft4 = this.lakeType;
        this.fc4 = DataUtilities.collection((SimpleFeature[])this.lakeFeatures);
        this.ft5 = this.buildingType;
        this.fc5 = DataUtilities.collection((SimpleFeature[])this.buildingFeatures);
        this.ft6 = this.invalidGeomType;
        this.fc6 = DataUtilities.collection((SimpleFeature[])this.invalidGeomFeatures);
    }

    public void testMin() throws IllegalFilterException, IOException {
        MinVisitor minVisitor = new MinVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)minVisitor, null);
        MinVisitor minVisitor2 = new MinVisitor(0, this.ft2);
        this.fc2.accepts((FeatureVisitor)minVisitor2, null);
        Object result = minVisitor.getResult().getValue();
        int value = (Integer)result;
        VisitorCalculationTest.assertEquals((int)1, (int)value);
        int value2 = minVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)1, (int)value2);
        CalcResult minResult1 = minVisitor.getResult();
        CalcResult minResult2 = minVisitor2.getResult();
        CalcResult minResult3 = minResult1.merge(minResult2);
        VisitorCalculationTest.assertEquals((int)1, (int)minResult3.toInt());
        MinVisitor.MinResult minResult4 = new MinVisitor.MinResult((Comparable)Integer.valueOf(10));
        CalcResult minResult5 = minResult4.merge(minResult1);
        VisitorCalculationTest.assertEquals((int)1, (int)minResult5.toInt());
        VisitorCalculationTest.assertEquals((int)10, (int)minResult4.toInt());
        MinVisitor.MinResult minResult6 = new MinVisitor.MinResult((Comparable)Integer.valueOf(-5));
        MinVisitor.MinResult minResult7 = (MinVisitor.MinResult)minResult1.merge((CalcResult)minResult6);
        VisitorCalculationTest.assertEquals((int)-5, (int)minResult7.toInt());
        VisitorCalculationTest.assertEquals((int)-5, (int)minResult6.toInt());
        minVisitor.setValue((Object)-50);
        minResult1 = minVisitor.getResult();
        minResult7 = minResult7.merge(minResult1);
        VisitorCalculationTest.assertEquals((int)-50, (int)minResult7.toInt());
        minVisitor.setValue((Object)-100.0);
        minResult1 = minVisitor.getResult();
        minResult7 = minResult7.merge(minResult1);
        VisitorCalculationTest.assertEquals((double)-100.0, (double)minResult7.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((int)-100, (int)minResult7.toInt());
        minVisitor.reset();
        this.empty.accepts((FeatureVisitor)minVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)minVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)minResult2, (Object)minVisitor.getResult().merge(minResult2));
        VisitorCalculationTest.assertSame((Object)minResult2, (Object)minResult2.merge(minVisitor.getResult()));
    }

    public void testMax() throws IllegalFilterException, IOException {
        MaxVisitor maxVisitor = new MaxVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)maxVisitor, null);
        MaxVisitor maxVisitor2 = new MaxVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)maxVisitor2, null);
        int value1 = maxVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)3, (int)value1);
        double value2 = maxVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((double)4.5, (double)value2, (double)0.0);
        MaxVisitor.MaxResult maxResult1 = (MaxVisitor.MaxResult)maxVisitor.getResult();
        MaxVisitor.MaxResult maxResult2 = (MaxVisitor.MaxResult)maxVisitor2.getResult();
        MaxVisitor.MaxResult maxResult3 = (MaxVisitor.MaxResult)maxResult1.merge((CalcResult)maxResult2);
        VisitorCalculationTest.assertEquals((double)4.5, (double)maxResult3.toDouble(), (double)0.0);
        MaxVisitor.MaxResult maxResult4 = new MaxVisitor.MaxResult((Comparable)Double.valueOf(2.0));
        MaxVisitor.MaxResult maxResult5 = (MaxVisitor.MaxResult)maxResult4.merge((CalcResult)maxResult1);
        VisitorCalculationTest.assertEquals((double)3.0, (double)maxResult5.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)2.0, (double)maxResult4.toDouble(), (double)0.0);
        MaxVisitor.MaxResult maxResult6 = new MaxVisitor.MaxResult((Comparable)Integer.valueOf(-5));
        MaxVisitor.MaxResult maxResult7 = (MaxVisitor.MaxResult)maxResult1.merge((CalcResult)maxResult6);
        VisitorCalculationTest.assertEquals((double)3.0, (double)maxResult7.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)-5.0, (double)maxResult6.toDouble(), (double)0.0);
        maxVisitor.setValue((Object)544.0);
        maxResult1 = maxVisitor.getResult();
        maxResult7 = maxResult7.merge((CalcResult)maxResult1);
        VisitorCalculationTest.assertEquals((double)544.0, (double)maxResult7.toDouble(), (double)0.0);
        maxVisitor.setValue((Object)6453L);
        maxResult1 = maxVisitor.getResult();
        maxResult7 = maxResult7.merge((CalcResult)maxResult1);
        VisitorCalculationTest.assertEquals((double)6453.0, (double)maxResult7.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((int)6453, (int)maxResult7.toInt());
        maxVisitor.reset();
        this.empty.accepts((FeatureVisitor)maxVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)maxVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)maxResult2, (Object)maxVisitor.getResult().merge((CalcResult)maxResult2));
        VisitorCalculationTest.assertSame((Object)maxResult2, (Object)maxResult2.merge(maxVisitor.getResult()));
    }

    public void testMedian() throws IllegalFilterException, IOException {
        MedianVisitor medianVisitor1 = new MedianVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)medianVisitor1, null);
        MedianVisitor medianVisitor2 = new MedianVisitor(0, this.ft2);
        this.fc2.accepts((FeatureVisitor)medianVisitor2, null);
        CalcResult medianResult1 = medianVisitor1.getResult();
        CalcResult medianResult2 = medianVisitor2.getResult();
        VisitorCalculationTest.assertEquals((int)2, (int)medianResult1.toInt());
        VisitorCalculationTest.assertEquals((double)1.5, (double)medianResult2.toDouble(), (double)0.0);
        CalcResult medianResult3 = medianResult1.merge(medianResult2);
        VisitorCalculationTest.assertEquals((double)2.0, (double)medianResult3.toDouble(), (double)0.0);
        ArrayList<Double> vals = new ArrayList<Double>();
        vals.add(2.5);
        vals.add(3.5);
        vals.add(4.5);
        MedianVisitor.MedianResult medianResult4 = new MedianVisitor.MedianResult(vals);
        CalcResult medianResult5 = medianResult4.merge(medianResult1);
        VisitorCalculationTest.assertEquals((double)2.75, (double)medianResult5.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)3.5, (double)medianResult4.toDouble(), (double)0.0);
        medianVisitor1.setValue((Comparable)Double.valueOf(544.0));
        medianResult1 = medianVisitor1.getResult();
        try {
            medianResult3 = medianResult5.merge(medianResult1);
            VisitorCalculationTest.fail();
        }
        catch (Exception e) {
            VisitorCalculationTest.assertEquals((String)"Optimized median results cannot be merged.", (String)e.getMessage());
        }
        medianVisitor1.reset();
        this.empty.accepts((FeatureVisitor)medianVisitor1, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)medianVisitor1.getResult());
        VisitorCalculationTest.assertSame((Object)medianResult2, (Object)medianVisitor1.getResult().merge(medianResult2));
        VisitorCalculationTest.assertSame((Object)medianResult2, (Object)medianResult2.merge(medianVisitor1.getResult()));
    }

    public void testSum() throws IllegalFilterException, IOException {
        SumVisitor sumVisitor = new SumVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)sumVisitor, null);
        SumVisitor sumVisitor2 = new SumVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)sumVisitor2, null);
        int value1 = sumVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)6, (int)value1);
        double value2 = sumVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((double)7.5, (double)value2, (double)0.0);
        CalcResult sumResult1 = sumVisitor.getResult();
        CalcResult sumResult2 = sumVisitor2.getResult();
        CalcResult sumResult3 = sumResult1.merge(sumResult2);
        VisitorCalculationTest.assertEquals((double)13.5, (double)sumResult3.toDouble(), (double)0.0);
        sumVisitor2.setValue((Object)-42);
        CalcResult sumResult4 = sumVisitor2.getResult();
        CalcResult sumResult5 = sumResult3.merge(sumResult4);
        VisitorCalculationTest.assertEquals((double)-28.5, (double)sumResult5.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)13.5, (double)sumResult3.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)-42.0, (double)sumResult4.toDouble(), (double)0.0);
        sumVisitor.reset();
        this.empty.accepts((FeatureVisitor)sumVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)sumVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)sumResult2, (Object)sumVisitor.getResult().merge(sumResult2));
        VisitorCalculationTest.assertSame((Object)sumResult2, (Object)sumResult2.merge(sumVisitor.getResult()));
    }

    public void testArea() throws IllegalFilterException, IOException {
        SumAreaVisitor areaVisitor = new SumAreaVisitor(1, this.ft4);
        this.fc4.accepts((FeatureVisitor)areaVisitor, null);
        SumAreaVisitor areaVisitor2 = new SumAreaVisitor(1, this.ft5);
        this.fc5.accepts((FeatureVisitor)areaVisitor2, null);
        double value1 = areaVisitor.getResult().toDouble();
        VisitorCalculationTest.assertEquals((Object)10.0, (Object)value1);
        double value2 = areaVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((Object)12.0, (Object)value2);
        CalcResult areaResult1 = areaVisitor.getResult();
        CalcResult areaResult2 = areaVisitor2.getResult();
        CalcResult areaResult3 = areaResult1.merge(areaResult2);
        VisitorCalculationTest.assertEquals((double)22.0, (double)areaResult3.toDouble(), (double)0.0);
    }

    public void testAreaInvalidPolygon() throws IllegalFilterException, IOException {
        SumAreaVisitor areaVisitor = new SumAreaVisitor(1, this.ft6);
        this.fc6.accepts((FeatureVisitor)areaVisitor, null);
        double value1 = areaVisitor.getResult().toDouble();
        VisitorCalculationTest.assertEquals((Object)0.0, (Object)value1);
    }

    public void testCount() throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        this.fc.accepts((FeatureVisitor)countVisitor, null);
        CountVisitor countVisitor2 = new CountVisitor();
        this.fc2.accepts((FeatureVisitor)countVisitor2, null);
        int value1 = countVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)3, (int)value1);
        int value2 = countVisitor2.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)2, (int)value2);
        CalcResult countResult1 = countVisitor.getResult();
        CalcResult countResult2 = countVisitor2.getResult();
        CalcResult countResult3 = countResult1.merge(countResult2);
        VisitorCalculationTest.assertEquals((int)5, (int)countResult3.toInt());
        countVisitor.setValue(20);
        CalcResult countResult4 = countVisitor.getResult();
        VisitorCalculationTest.assertEquals((int)20, (int)countResult4.toInt());
        CalcResult countResult5 = countResult4.merge(countResult3);
        VisitorCalculationTest.assertEquals((int)5, (int)countResult3.toInt());
        VisitorCalculationTest.assertEquals((int)20, (int)countResult4.toInt());
        VisitorCalculationTest.assertEquals((int)25, (int)countResult5.toInt());
        countVisitor.reset();
        this.empty.accepts((FeatureVisitor)countVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)countVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)countResult2, (Object)countVisitor.getResult().merge(countResult2));
        VisitorCalculationTest.assertSame((Object)countResult2, (Object)countResult2.merge(countVisitor.getResult()));
    }

    public void testAverage() throws IllegalFilterException, IOException {
        AverageVisitor averageVisitor = new AverageVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)averageVisitor, null);
        AverageVisitor averageVisitor2 = new AverageVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)averageVisitor2, null);
        int value1 = averageVisitor.getResult().toInt();
        VisitorCalculationTest.assertEquals((int)2, (int)value1);
        double value2 = averageVisitor2.getResult().toDouble();
        VisitorCalculationTest.assertEquals((double)3.75, (double)value2, (double)0.0);
        CalcResult averageResult1 = averageVisitor.getResult();
        CalcResult averageResult2 = averageVisitor2.getResult();
        CalcResult averageResult3 = averageResult1.merge(averageResult2);
        VisitorCalculationTest.assertEquals((double)2.7, (double)averageResult3.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)3.75, (double)averageResult2.toDouble(), (double)0.0);
        averageVisitor2.setValue(5, (Object)100);
        averageResult2 = averageVisitor2.getResult();
        VisitorCalculationTest.assertEquals((int)20, (int)averageResult2.toInt());
        averageResult3 = averageResult1.merge(averageResult2);
        VisitorCalculationTest.assertEquals((double)13.25, (double)averageResult3.toDouble(), (double)0.0);
        averageVisitor2.setValue((Object)15.4);
        averageResult2 = averageVisitor2.getResult();
        VisitorCalculationTest.assertEquals((double)15.4, (double)averageResult2.toDouble(), (double)0.0);
        try {
            averageResult3 = averageResult1.merge(averageResult2);
            VisitorCalculationTest.fail();
        }
        catch (Exception e) {
            VisitorCalculationTest.assertEquals((String)"Optimized average results cannot be merged.", (String)e.getMessage());
        }
        averageVisitor.setValue(5, (Object)10);
        averageResult1 = averageVisitor.getResult();
        averageVisitor2.setValue(5, (Object)33.3);
        averageResult2 = averageVisitor2.getResult();
        averageResult3 = averageResult1.merge(averageResult2);
        VisitorCalculationTest.assertEquals((double)4.33, (double)averageResult3.toDouble(), (double)0.0);
        averageVisitor.reset();
        this.empty.accepts((FeatureVisitor)averageVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)averageVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)averageResult2, (Object)averageVisitor.getResult().merge(averageResult2));
        VisitorCalculationTest.assertSame((Object)averageResult2, (Object)averageResult2.merge(averageVisitor.getResult()));
    }

    public void testUniquePreserveOrder() throws IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(0, this.ft);
        uniqueVisitor.setPreserveOrder(true);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        Set value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((Object)1, value1.iterator().next());
        uniqueVisitor.reset();
        this.invfc.accepts((FeatureVisitor)uniqueVisitor, null);
        value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((Object)3, value1.iterator().next());
    }

    public void testUniquePagination() throws IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(0, this.ft);
        uniqueVisitor.setPreserveOrder(true);
        uniqueVisitor.setStartIndex(0);
        uniqueVisitor.setMaxFeatures(1);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        Set value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((int)1, (int)value1.size());
        VisitorCalculationTest.assertEquals((Object)1, value1.iterator().next());
        uniqueVisitor.reset();
        uniqueVisitor.setStartIndex(1);
        uniqueVisitor.setMaxFeatures(2);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((int)2, (int)value1.size());
        VisitorCalculationTest.assertEquals((Object)2, value1.iterator().next());
        uniqueVisitor.reset();
        uniqueVisitor.setStartIndex(2);
        uniqueVisitor.setMaxFeatures(2);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((int)1, (int)value1.size());
        VisitorCalculationTest.assertEquals((Object)3, value1.iterator().next());
        uniqueVisitor.reset();
        uniqueVisitor.setStartIndex(3);
        uniqueVisitor.setMaxFeatures(2);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertNull((Object)value1);
    }

    public void testUnique() throws IllegalFilterException, IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(0, this.ft);
        this.fc.accepts((FeatureVisitor)uniqueVisitor, null);
        UniqueVisitor uniqueVisitor2 = new UniqueVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)uniqueVisitor2, null);
        Set value1 = uniqueVisitor.getResult().toSet();
        VisitorCalculationTest.assertEquals((int)3, (int)value1.size());
        Object[] value2 = uniqueVisitor2.getResult().toArray();
        VisitorCalculationTest.assertEquals((int)2, (int)value2.length);
        CalcResult uniqueResult1 = uniqueVisitor.getResult();
        CalcResult uniqueResult2 = uniqueVisitor2.getResult();
        CalcResult uniqueResult3 = uniqueResult1.merge(uniqueResult2);
        VisitorCalculationTest.assertEquals((int)5, (int)uniqueResult3.toSet().size());
        VisitorCalculationTest.assertEquals((int)3, (int)uniqueResult1.toSet().size());
        HashSet<Integer> anotherSet = new HashSet<Integer>();
        anotherSet.add(2);
        anotherSet.add(4);
        UniqueVisitor.UniqueResult uniqueResult4 = new UniqueVisitor.UniqueResult(anotherSet);
        CalcResult uniqueResult5 = uniqueResult1.merge((CalcResult)uniqueResult4);
        VisitorCalculationTest.assertEquals((int)4, (int)uniqueResult5.toSet().size());
        uniqueVisitor.setValue(anotherSet);
        uniqueResult1 = uniqueVisitor.getResult();
        VisitorCalculationTest.assertEquals(anotherSet, (Object)uniqueResult1.toSet());
        uniqueResult3 = uniqueResult2.merge(uniqueResult1);
        Set set = uniqueResult3.toSet();
        VisitorCalculationTest.assertTrue((set.size() == 4 ? 1 : 0) != 0);
        VisitorCalculationTest.assertTrue((boolean)set.contains(3.0));
        VisitorCalculationTest.assertTrue((boolean)set.contains(4.5));
        VisitorCalculationTest.assertTrue((boolean)set.contains(2));
        VisitorCalculationTest.assertTrue((boolean)set.contains(4));
        VisitorCalculationTest.assertFalse((boolean)set.contains(6));
        uniqueVisitor.reset();
        this.empty.accepts((FeatureVisitor)uniqueVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)uniqueVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)uniqueResult2, (Object)uniqueVisitor.getResult().merge(uniqueResult2));
        VisitorCalculationTest.assertSame((Object)uniqueResult2, (Object)uniqueResult2.merge(uniqueVisitor.getResult()));
    }

    public void testBounds() throws IOException {
        BoundsVisitor boundsVisitor1 = new BoundsVisitor();
        this.fc.accepts((FeatureVisitor)boundsVisitor1, null);
        BoundsVisitor boundsVisitor2 = new BoundsVisitor();
        this.fc2.accepts((FeatureVisitor)boundsVisitor2, null);
        Envelope env1 = new Envelope(1.0, 5.0, 0.0, 4.0);
        CalcResult boundsResult1 = boundsVisitor1.getResult();
        VisitorCalculationTest.assertEquals((Object)env1, (Object)boundsResult1.toEnvelope());
        Envelope env2 = new Envelope(4.0, 13.0, 3.0, 10.0);
        CalcResult boundsResult2 = boundsVisitor2.getResult();
        VisitorCalculationTest.assertEquals((Object)env2, (Object)boundsResult2.toEnvelope());
        CalcResult boundsResult3 = boundsResult2.merge(boundsResult1);
        Envelope env3 = new Envelope(1.0, 13.0, 0.0, 10.0);
        VisitorCalculationTest.assertEquals((Object)env3, (Object)boundsResult3.toEnvelope());
        boundsVisitor1.reset(null);
        this.empty.accepts((FeatureVisitor)boundsVisitor1, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)boundsVisitor1.getResult());
        VisitorCalculationTest.assertSame((Object)boundsResult2, (Object)boundsVisitor1.getResult().merge(boundsResult2));
        VisitorCalculationTest.assertSame((Object)boundsResult2, (Object)boundsResult2.merge(boundsVisitor1.getResult()));
    }

    public void testQuantileList() throws Exception {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyName expr = factory.property(this.ft.getDescriptor(0).getLocalName());
        QuantileListVisitor visitor = new QuantileListVisitor((Expression)expr, 2);
        this.fc.accepts((FeatureVisitor)visitor, null);
        CalcResult result = visitor.getResult();
        List[] qResult = (List[])result.getValue();
        VisitorCalculationTest.assertEquals((int)2, (int)qResult.length);
        VisitorCalculationTest.assertEquals((int)2, (int)qResult[0].size());
        VisitorCalculationTest.assertEquals((int)1, (int)qResult[1].size());
        QuantileListVisitor emptyVisitor = new QuantileListVisitor((Expression)expr, 2);
        this.empty.accepts((FeatureVisitor)emptyVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)emptyVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)result, (Object)emptyVisitor.getResult().merge(result));
        VisitorCalculationTest.assertSame((Object)result, (Object)result.merge(emptyVisitor.getResult()));
    }

    public void testStandardDeviation() throws Exception {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyName expr = factory.property(this.ft3.getDescriptor(0).getLocalName());
        AverageVisitor visit1 = new AverageVisitor((Expression)expr);
        this.fc3.accepts((FeatureVisitor)visit1, null);
        CalcResult result = visit1.getResult();
        StandardDeviationVisitor visit2 = new StandardDeviationVisitor((Expression)expr);
        this.fc3.accepts((FeatureVisitor)visit2, null);
        VisitorCalculationTest.assertEquals((double)28.86, (double)visit2.getResult().toDouble(), (double)0.01);
        StandardDeviationVisitor visit3 = new StandardDeviationVisitor((Expression)expr);
        this.fc3.accepts((FeatureVisitor)visit3, null);
        VisitorCalculationTest.assertEquals((double)28.86, (double)visit3.getResult().toDouble(), (double)0.01);
        StandardDeviationVisitor emptyVisitor = new StandardDeviationVisitor((Expression)expr);
        this.empty.accepts((FeatureVisitor)emptyVisitor, null);
        VisitorCalculationTest.assertEquals((Object)CalcResult.NULL_RESULT, (Object)emptyVisitor.getResult());
        VisitorCalculationTest.assertSame((Object)result, (Object)emptyVisitor.getResult().merge(result));
        VisitorCalculationTest.assertSame((Object)result, (Object)result.merge(emptyVisitor.getResult()));
    }

    public void testCountSumMerge() throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        this.fc2.accepts((FeatureVisitor)countVisitor, null);
        SumVisitor sumVisitor = new SumVisitor(3, this.ft2);
        this.fc2.accepts((FeatureVisitor)sumVisitor, null);
        CalcResult countResult = countVisitor.getResult();
        CalcResult sumResult = sumVisitor.getResult();
        CalcResult averageResult1 = countResult.merge(sumResult);
        CalcResult averageResult2 = sumResult.merge(countResult);
        VisitorCalculationTest.assertEquals((double)3.75, (double)averageResult1.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((double)3.75, (double)averageResult2.toDouble(), (double)0.0);
        VisitorCalculationTest.assertEquals((int)2, (int)countResult.toInt());
        VisitorCalculationTest.assertEquals((double)7.5, (double)sumResult.toDouble(), (double)0.0);
    }

    public void testBadMerge() throws IllegalFilterException, IOException {
        CountVisitor countVisitor = new CountVisitor();
        countVisitor.setValue(8);
        CalcResult countResult = countVisitor.getResult();
        MaxVisitor maxVisitor = new MaxVisitor((Expression)null);
        maxVisitor.setValue((Object)99.0);
        CalcResult maxResult = maxVisitor.getResult();
        try {
            CalcResult boomResult = maxResult.merge(countResult);
            VisitorCalculationTest.fail();
        }
        catch (Exception e) {
            VisitorCalculationTest.assertEquals((String)"Parameter is not a compatible type", (String)e.getMessage());
        }
    }

    public void testNearest() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"nearestTest", (String)"name:String,size:int,flow:double,event:java.util.Date,data:java.io.File");
        ListFeatureCollection fc = new ListFeatureCollection(type);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd", Locale.ENGLISH);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        fc.add(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"abc", 10, 10.5, df.parse("2014-12-10"), new File("/tmp/test.txt")}, null));
        fc.add(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"ade", 5, 3.5, df.parse("2012-11-10"), new File("/tmp/abc.txt")}, null));
        fc.add(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"zaa", 2, 50.4, df.parse("2010-11-10"), new File("/tmp/zaa.txt")}, null));
        this.testNearest((SimpleFeatureCollection)fc, "size", 5, 5);
        this.testNearest((SimpleFeatureCollection)fc, "size", 1, 2);
        this.testNearest((SimpleFeatureCollection)fc, "size", 3, 2);
        this.testNearest((SimpleFeatureCollection)fc, "size", 15, 10);
        this.testNearest((SimpleFeatureCollection)fc, "flow", 3.5, 3.5);
        this.testNearest((SimpleFeatureCollection)fc, "flow", 1.0, 3.5);
        this.testNearest((SimpleFeatureCollection)fc, "flow", 10.0, 10.5);
        this.testNearest((SimpleFeatureCollection)fc, "flow", 100.0, 50.4);
        this.testNearest((SimpleFeatureCollection)fc, "event", df.parse("2014-12-10"), df.parse("2014-12-10"));
        this.testNearest((SimpleFeatureCollection)fc, "event", df.parse("2009-11-10"), df.parse("2010-11-10"));
        this.testNearest((SimpleFeatureCollection)fc, "event", df.parse("2010-11-11"), df.parse("2010-11-10"));
        this.testNearest((SimpleFeatureCollection)fc, "event", df.parse("2015-12-10"), df.parse("2014-12-10"));
        this.testNearest((SimpleFeatureCollection)fc, "name", "ade", "ade");
        this.testNearest((SimpleFeatureCollection)fc, "name", "aaa", "abc");
        this.testNearest((SimpleFeatureCollection)fc, "name", "mfc", "ade", "zaa");
        this.testNearest((SimpleFeatureCollection)fc, "name", "zzz", "zaa");
        this.testNearest((SimpleFeatureCollection)fc, "data", new File("/tmp/test.txt"), new File("/tmp/test.txt"));
        this.testNearest((SimpleFeatureCollection)fc, "data", new File("/tmp/aaa.txt"), new File("/tmp/abc.txt"));
        this.testNearest((SimpleFeatureCollection)fc, "data", new File("/tmp/mfc.txt"), new File("/tmp/abc.txt"), new File("/tmp/test.txt"));
        this.testNearest((SimpleFeatureCollection)fc, "data", new File("/tmp/zzz.txt"), new File("/tmp/zaa.txt"));
    }

    private void testNearest(SimpleFeatureCollection fc, String attributeName, Object target, Object ... validResults) throws IOException {
        PropertyName expr = this.ff.property(attributeName);
        NearestVisitor visitor = new NearestVisitor((Expression)expr, target);
        fc.accepts((FeatureVisitor)visitor, null);
        Object nearestMatch = visitor.getNearestMatch();
        if (validResults.length == 0) {
            VisitorCalculationTest.assertNull((Object)nearestMatch);
        } else {
            boolean found = false;
            for (Object object : validResults) {
                found |= object != null ? object.equals(nearestMatch) : nearestMatch == null;
            }
            VisitorCalculationTest.assertTrue((String)("Could match nearest " + nearestMatch + " among valid values " + Arrays.asList(validResults)), (boolean)found);
        }
    }
}

