/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Arrays;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AreaFunction;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;

public class AreaFunctionTest
extends TestCase {
    protected static final Logger LOGGER = Logging.getLogger(AreaFunctionTest.class);
    private static SimpleFeature testFeature = null;
    private static SimpleFeatureType testSchema = null;
    boolean setup = false;
    TestSuite suite = null;
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public AreaFunctionTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AreaFunctionTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(AreaFunctionTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException, IllegalAttributeException {
        if (this.setup) {
            return;
        }
        this.prepareFeatures();
        this.setup = true;
    }

    protected void prepareFeatures() throws SchemaException, IllegalAttributeException {
        LOGGER.finer("creating flat feature...");
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setCRS(null);
        ftb.add("testGeometry", Polygon.class);
        LOGGER.finer("created geometry attribute");
        ftb.add("testBoolean", Boolean.class);
        LOGGER.finer("created boolean attribute");
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 0.0), new Coordinate(10.0, 10.0), new Coordinate(0.0, 10.0), new Coordinate(0.0, 0.0)};
        Object[] attributes = new Object[10];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LinearRing ring = gf.createLinearRing(coords);
        attributes[0] = gf.createPolygon(ring, null);
        attributes[1] = true;
        attributes[2] = Character.valueOf('t');
        attributes[3] = Byte.valueOf("10");
        attributes[4] = Short.valueOf("101");
        attributes[5] = 1002;
        attributes[6] = 10003L;
        attributes[7] = Float.valueOf(10000.4f);
        attributes[8] = 100000.5;
        attributes[9] = "test string data";
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
        LOGGER.finer("...flat feature created");
    }

    public void testAreaFunction() throws IllegalFilterException {
        PropertyName a = filterFactory.property("testGeometry");
        AreaFunction area = new AreaFunction();
        area.setParameters(Arrays.asList(a));
        AreaFunctionTest.assertEquals((double)100.0, (double)((Double)area.evaluate((Object)testFeature)), (double)0.0);
    }
}

