/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Disjoint;

public class FilterEqualsTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger(FilterEqualsTest.class);
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private Expression testExp1;
    private Expression testExp2;
    private Expression testExp3;
    private Expression testExp4;
    private Filter tFilter1;
    private Filter tFilter2;
    private static SimpleFeature testFeature = null;
    private static SimpleFeatureType testSchema = null;
    boolean set = false;

    public FilterEqualsTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        Logging.GEOTOOLS.forceMonolineConsoleOutput();
        TestRunner.run((Test)FilterEqualsTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterEqualsTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException, IllegalAttributeException {
        if (this.set) {
            return;
        }
        this.set = true;
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setCRS(null);
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testZeroDouble", Double.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[11];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        attributes[0] = gf.createLineString(coords);
        attributes[1] = true;
        attributes[2] = Character.valueOf('t');
        attributes[3] = Byte.valueOf("10");
        attributes[4] = Short.valueOf("101");
        attributes[5] = 1002;
        attributes[6] = 10003L;
        attributes[7] = Float.valueOf(10000.4f);
        attributes[8] = 100000.5;
        attributes[9] = "test string data";
        attributes[10] = "0.0";
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
    }

    public void testLiteralExpressionImplEquals() {
        try {
            LiteralExpressionImpl testString1 = new LiteralExpressionImpl("test literal");
            LiteralExpressionImpl testString2 = new LiteralExpressionImpl("test literal");
            FilterEqualsTest.assertTrue((boolean)testString1.equals(testString2));
            LiteralExpressionImpl testOtherString = new LiteralExpressionImpl("not test literal");
            FilterEqualsTest.assertFalse((boolean)testString1.equals(testOtherString));
            LiteralExpressionImpl testNumber34 = new LiteralExpressionImpl((Object)34);
            FilterEqualsTest.assertFalse((boolean)testString1.equals(testNumber34));
            LiteralExpressionImpl testOtherNumber34 = new LiteralExpressionImpl((Object)34);
            FilterEqualsTest.assertTrue((boolean)testNumber34.equals(testOtherNumber34));
        }
        catch (IllegalFilterException e) {
            LOGGER.warning("bad filter " + e.getMessage());
        }
    }

    public void testFidFilter() {
        FidFilterImpl ff = new FidFilterImpl(Collections.singleton(new FeatureIdImpl("1")));
        FidFilterImpl ff2 = new FidFilterImpl(Collections.singleton(new FeatureIdImpl("1")));
        FilterEqualsTest.assertNotNull((Object)ff2);
        FilterEqualsTest.assertEquals((Object)ff, (Object)ff2);
        FilterEqualsTest.assertTrue((!ff.equals(null) ? 1 : 0) != 0);
        FilterEqualsTest.assertTrue((!ff.equals((Object)"a string not even a filter") ? 1 : 0) != 0);
        ff2.addFid("2");
        FilterEqualsTest.assertTrue((!ff.equals((Object)ff2) ? 1 : 0) != 0);
        ff.addFid("2");
        FilterEqualsTest.assertEquals((Object)ff, (Object)ff2);
    }

    public void testExpressionMath() {
        try {
            this.testExp1 = new LiteralExpressionImpl((Object)5.0);
            this.testExp2 = new LiteralExpressionImpl((Object)5.0);
            AddImpl testMath1 = new AddImpl(null, null);
            testMath1.setExpression1(this.testExp1);
            testMath1.setExpression2(this.testExp2);
            AddImpl testMath2 = new AddImpl(null, null);
            testMath2.setExpression1(this.testExp2);
            testMath2.setExpression2(this.testExp1);
            FilterEqualsTest.assertTrue((boolean)testMath1.equals(testMath2));
            this.testExp3 = new LiteralExpressionImpl((Object)4);
            this.testExp4 = new LiteralExpressionImpl((Object)4);
            testMath2.setExpression1(this.testExp3);
            FilterEqualsTest.assertTrue((!testMath1.equals(testMath2) ? 1 : 0) != 0);
            testMath1.setExpression1(this.testExp4);
            FilterEqualsTest.assertTrue((boolean)testMath1.equals(testMath2));
            testMath1 = new SubtractImpl(null, null);
            testMath1.setExpression1(this.testExp4);
            testMath1.setExpression1(this.testExp2);
            FilterEqualsTest.assertTrue((!testMath1.equals(testMath2) ? 1 : 0) != 0);
            FilterEqualsTest.assertTrue((!testMath1.equals("Random Object that happens to be a string") ? 1 : 0) != 0);
        }
        catch (IllegalFilterException e) {
            LOGGER.warning("bad filter: " + e.getMessage());
        }
    }

    public void testExpressionAttribute() throws IllegalFilterException, SchemaException {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testString", String.class);
        ftb.setName("test2");
        SimpleFeatureType testSchema2 = ftb.buildFeatureType();
        this.testExp1 = new AttributeExpressionImpl(testSchema, "testBoolean");
        this.testExp2 = new AttributeExpressionImpl(testSchema, "testBoolean");
        FilterEqualsTest.assertTrue((boolean)this.testExp1.equals(this.testExp2));
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testString");
        FilterEqualsTest.assertTrue((!this.testExp1.equals(this.testExp3) ? 1 : 0) != 0);
        this.testExp4 = new AttributeExpressionImpl(testSchema2, "testBoolean");
        FilterEqualsTest.assertTrue((!this.testExp1.equals(this.testExp4) ? 1 : 0) != 0);
        this.testExp1 = new AttributeExpressionImpl(testSchema2, "testBoolean");
        FilterEqualsTest.assertTrue((boolean)this.testExp1.equals(this.testExp4));
    }

    public void testCompareFilter() throws IllegalFilterException {
        this.testExp1 = new LiteralExpressionImpl((Object)45);
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsEqualTo cFilter1 = this.ff.equals(this.testExp1, this.testExp3);
        PropertyIsEqualTo cFilter2 = this.ff.equals(this.testExp1, this.testExp3);
        FilterEqualsTest.assertTrue((boolean)cFilter1.equals(cFilter2));
        cFilter2 = this.ff.equals(this.testExp2, this.testExp4);
        FilterEqualsTest.assertTrue((boolean)cFilter1.equals(cFilter2));
        cFilter2 = this.ff.equals((Expression)this.ff.literal((Object)45.0), this.testExp3);
        FilterEqualsTest.assertTrue((boolean)cFilter1.equals(cFilter2));
        this.tFilter1 = this.ff.between(this.testExp1, this.testExp2, this.testExp3);
        FilterEqualsTest.assertTrue((!cFilter1.equals(this.tFilter1) ? 1 : 0) != 0);
    }

    public void testBetweenFilter() throws IllegalFilterException {
        IsBetweenImpl bFilter1 = new IsBetweenImpl(null, null, null);
        IsBetweenImpl bFilter2 = new IsBetweenImpl(null, null, null);
        LiteralExpressionImpl testLit1 = new LiteralExpressionImpl((Object)55);
        LiteralExpressionImpl testLit2 = new LiteralExpressionImpl((Object)55);
        this.testExp1 = new LiteralExpressionImpl((Object)45);
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        bFilter1.setExpression1(this.testExp1);
        bFilter2.setExpression1(this.testExp2);
        bFilter1.setExpression(this.testExp3);
        bFilter2.setExpression(this.testExp4);
        bFilter1.setExpression2((Expression)testLit1);
        bFilter2.setExpression2((Expression)testLit2);
        FilterEqualsTest.assertTrue((boolean)bFilter2.equals((Object)bFilter1));
        this.tFilter1 = this.ff.equals(Expression.NIL, Expression.NIL);
        FilterEqualsTest.assertTrue((!bFilter2.equals((Object)this.tFilter1) ? 1 : 0) != 0);
        bFilter2.setExpression2((Expression)new LiteralExpressionImpl((Object)65));
        FilterEqualsTest.assertTrue((!bFilter2.equals((Object)bFilter1) ? 1 : 0) != 0);
    }

    public void testLikeFilter() throws IllegalFilterException {
        LikeFilterImpl lFilter1 = new LikeFilterImpl();
        LikeFilterImpl lFilter2 = new LikeFilterImpl();
        String pattern = "te_st!";
        String wcMulti = "!";
        String wcSingle = "_";
        String escape = "#";
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        lFilter1.setExpression(this.testExp3);
        lFilter2.setExpression(this.testExp4);
        lFilter1.setLiteral(pattern);
        lFilter1.setWildCard(wcMulti);
        lFilter1.setSingleChar(wcSingle);
        lFilter1.setEscape(escape);
        lFilter2.setLiteral(pattern);
        lFilter2.setWildCard(wcMulti);
        lFilter2.setSingleChar(wcSingle);
        lFilter2.setEscape(escape);
        FilterEqualsTest.assertTrue((boolean)lFilter1.equals((Object)lFilter2));
        lFilter2.setLiteral("te__t!");
        lFilter2.setWildCard(wcMulti);
        lFilter2.setSingleChar(wcSingle);
        lFilter2.setEscape(escape);
        FilterEqualsTest.assertTrue((!lFilter1.equals((Object)lFilter2) ? 1 : 0) != 0);
        lFilter2.setLiteral(pattern);
        lFilter2.setWildCard(wcMulti);
        lFilter2.setSingleChar(wcSingle);
        lFilter2.setEscape(escape);
        lFilter2.setExpression(this.testExp2);
        FilterEqualsTest.assertTrue((!lFilter1.equals((Object)lFilter2) ? 1 : 0) != 0);
    }

    public void testLogicFilter() throws IllegalFilterException {
        this.testExp1 = new LiteralExpressionImpl((Object)45);
        this.testExp2 = new LiteralExpressionImpl((Object)45);
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsEqualTo cFilter1 = this.ff.equals(this.testExp1, this.testExp2);
        PropertyIsEqualTo cFilter2 = this.ff.equals(this.testExp2, this.testExp4);
        And logFilter1 = this.ff.and((Filter)cFilter1, (Filter)cFilter2);
        And logFilter2 = this.ff.and((Filter)cFilter1, (Filter)cFilter2);
        FilterEqualsTest.assertTrue((boolean)logFilter1.equals(logFilter2));
        logFilter1 = this.ff.not((Filter)cFilter2);
        FilterEqualsTest.assertTrue((!logFilter1.equals(logFilter2) ? 1 : 0) != 0);
        cFilter1 = this.ff.equals(this.testExp1, this.testExp3);
        logFilter2 = this.ff.not((Filter)cFilter1);
        FilterEqualsTest.assertTrue((boolean)logFilter1.equals(logFilter2));
        FilterEqualsTest.assertTrue((!logFilter1.equals(this.ff.between(this.testExp1, this.testExp2, this.testExp3)) ? 1 : 0) != 0);
        Or logFilter3 = this.ff.or((Filter)logFilter1, (Filter)logFilter2);
        Or logFilter4 = this.ff.or((Filter)logFilter1, (Filter)logFilter2);
        FilterEqualsTest.assertTrue((boolean)logFilter3.equals(logFilter4));
        Or logFilter5 = this.ff.or((Filter)cFilter1, (Filter)logFilter3);
        Or logFilter6 = this.ff.or((Filter)logFilter4, (Filter)cFilter1);
        FilterEqualsTest.assertTrue((boolean)logFilter5.equals(logFilter6));
        FilterEqualsTest.assertTrue((boolean)logFilter4.equals(logFilter3));
    }

    public void testNullFilter() throws IllegalFilterException {
        this.testExp1 = new AttributeExpressionImpl(testSchema, "testDouble");
        this.testExp2 = new AttributeExpressionImpl(testSchema, "testDouble");
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testBoolean");
        NullFilterImpl nullFilter1 = new NullFilterImpl(Expression.NIL);
        NullFilterImpl nullFilter2 = new NullFilterImpl(Expression.NIL);
        nullFilter1.setExpression(this.testExp1);
        nullFilter2.setExpression(this.testExp2);
        FilterEqualsTest.assertTrue((boolean)nullFilter1.equals((Object)nullFilter2));
        nullFilter1.setExpression(this.testExp3);
        FilterEqualsTest.assertTrue((!nullFilter1.equals((Object)nullFilter2) ? 1 : 0) != 0);
        FilterEqualsTest.assertTrue((!nullFilter1.equals((Object)new IsBetweenImpl(null, null, null)) ? 1 : 0) != 0);
    }

    public void testGeometryFilter() throws IllegalFilterException {
        Disjoint geomFilter1 = this.ff.disjoint(this.testExp1, this.testExp4);
        Disjoint geomFilter2 = this.ff.disjoint(this.testExp2, this.testExp4);
        FilterEqualsTest.assertTrue((boolean)geomFilter1.equals(geomFilter2));
        geomFilter2 = this.ff.disjoint(this.testExp2, (Expression)new LiteralExpressionImpl((Object)45.0));
        FilterEqualsTest.assertTrue((!geomFilter1.equals(geomFilter2) ? 1 : 0) != 0);
        this.tFilter1 = this.ff.between((Expression)this.ff.literal(1), (Expression)this.ff.literal(-1), (Expression)this.ff.literal(3));
        FilterEqualsTest.assertTrue((!geomFilter1.equals(this.tFilter1) ? 1 : 0) != 0);
    }
}

