/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.Filters;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class FunctionExpressionImplTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger(FunctionExpressionImplTest.class);
    FunctionExpressionImpl function;
    TestExpressionVisitor testVisitor;

    public void setUp() throws Exception {
        super.setUp();
        this.function = new FunctionExpressionImpl(FunctionExpressionImpl.functionName((String)"testFunction", (String)"test:String", (String[])new String[]{"argument:String"})){};
        this.testVisitor = new TestExpressionVisitor();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.function = null;
        this.testVisitor = null;
    }

    public void testAcceptExpressionVisitor() {
        Object extraData = new Object();
        this.function.accept((ExpressionVisitor)this.testVisitor, extraData);
        Object[] expected = new Object[]{Boolean.TRUE, extraData};
        Object[] actual = this.testVisitor.functionVisited;
        FunctionExpressionImplTest.assertEquals((Object)expected[0], (Object)actual[0]);
        FunctionExpressionImplTest.assertEquals((Object)expected[1], (Object)actual[1]);
    }

    public void testGetType() {
        FunctionExpressionImplTest.assertEquals((short)114, (short)Filters.getExpressionType((Expression)this.function));
    }

    public void testGetName() {
        FunctionExpressionImpl anonymous = new FunctionExpressionImpl(FunctionExpressionImpl.functionName((String)"testFunction", (String)"text:String", (String[])new String[0])){};
        FunctionExpressionImplTest.assertEquals((String)"testFunction", (String)anonymous.getName());
    }

    public void testGetParameters() {
        List<LiteralExpressionImpl> expected;
        this.function.params = expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        FunctionExpressionImplTest.assertEquals(expected, (Object)this.function.getParameters());
    }

    public void testSetParameters() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        FunctionExpressionImplTest.assertEquals(expected, (Object)this.function.params);
    }

    public void testGetArgs() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        List actual = this.function.getParameters();
        FunctionExpressionImplTest.assertEquals(expected, (Object)actual);
    }

    public void testSetArgs() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        FunctionExpressionImplTest.assertEquals(expected, (Object)this.function.params);
    }

    public void testGetArgCount() {
        List<LiteralExpressionImpl> expected = Collections.singletonList(new LiteralExpressionImpl(10.0));
        this.function.setParameters(expected);
        FunctionExpressionImplTest.assertEquals((int)1, (int)this.function.getFunctionName().getArgumentCount());
    }

    public void testGetImplementationHints() {
        FunctionExpressionImplTest.assertNotNull((Object)this.function.getImplementationHints());
        FunctionExpressionImplTest.assertTrue((boolean)this.function.getImplementationHints().isEmpty());
    }

    public void testImplementations() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List functionClasses = this.loadFunctionClasses();
        LinkedList errors = new LinkedList();
        for (Class functionClass : functionClasses) {
            Function function = (Function)functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.testFunction(function, errors);
        }
        if (errors.size() > 0) {
            String errorsMessage = this.buildErrosMessage(errors);
            LOGGER.info(errorsMessage);
            FunctionExpressionImplTest.fail((String)errorsMessage);
        }
    }

    private String buildErrosMessage(List errors) {
        StringBuffer sb = new StringBuffer("Some function expression implementations violates contract:\n");
        int errorCount = 1;
        for (String error : errors) {
            sb.append(errorCount++ + " - ");
            sb.append(error);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void testFunction(Function function, List errors) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List parameters;
        String functionClass = function.getClass().getName();
        if (null == function.getName()) {
            errors.add(functionClass + ": getName() == null");
        }
        this.testVisitor = new TestExpressionVisitor();
        String extraData = "[extraData correctly returned]";
        function.accept((ExpressionVisitor)this.testVisitor, (Object)extraData);
        Object[] functionVisited = this.testVisitor.functionVisited;
        if (Boolean.TRUE != functionVisited[0] || extraData != functionVisited[1]) {
            errors.add(functionClass + ": accept didn't called visitor.visit(Function, extraData):  visited: " + functionVisited[0] + ", extraData: " + functionVisited[1]);
        }
        try {
            String string = function.toString();
        }
        catch (Exception e) {
            this.addExceptionError(errors, functionClass, "toString", e);
        }
        if (function instanceof FunctionExpression) {
            this.testDeprecatedMethods((FunctionExpression)function, errors);
        }
        if ((parameters = function.getParameters()) == null) {
            errors.add(functionClass + ".getParameters() returns null");
        }
    }

    private void addExceptionError(List errors, String functionClass, String method, Exception e) {
        errors.add(functionClass + "." + method + "() throwed an exception: " + e.getMessage());
    }

    private void testDeprecatedMethods(FunctionExpression function, List<String> errors) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String functionClass = function.getClass().getName();
        int argCount = function.getFunctionName().getArgumentCount();
        if (argCount < 0) {
            argCount = 5;
        }
        ArrayList<AttributeExpressionImpl> expected = new ArrayList<AttributeExpressionImpl>();
        for (int i = 0; i < argCount; ++i) {
            AttributeExpressionImpl ex = new AttributeExpressionImpl("attName");
            expected.add(ex);
        }
        try {
            function.setParameters(expected);
        }
        catch (Exception e) {
            this.addExceptionError(errors, functionClass, "setArgs", e);
        }
        ArrayList returnedParams = function.getParameters();
        if (returnedParams == null) {
            errors.add(functionClass + ".getParameters() returned null when parameters were set through setArgs(Expression[])");
        } else if (!expected.equals(returnedParams)) {
            errors.add(functionClass + ".getParameters() returned a wrong result when parameters were set through setArgs(Expression[])");
        }
        function = (FunctionExpression)function.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        function.setParameters(expected);
        List returnedArgs = function.getParameters();
        if (returnedArgs == null) {
            errors.add(functionClass + ".getParameters() returns null then arguments set through setParameters()");
        } else {
            returnedParams = new ArrayList(expected);
            if (!expected.equals(returnedParams)) {
                errors.add(functionClass + ".getParameters() incompatible with getParameters()");
            }
        }
        if (114 != Filters.getExpressionType((Expression)function)) {
            errors.add(functionClass + ".getType != " + 114);
        }
    }

    private List loadFunctionClasses() throws IOException, ClassNotFoundException {
        String className;
        String spiDefinitionResource = "/META-INF/services/org.opengis.filter.expression.Function";
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/services/org.opengis.filter.expression.Function");
        if (in == null) {
            throw new FileNotFoundException("/META-INF/services/org.opengis.filter.expression.Function");
        }
        LinkedList functionClasses = new LinkedList();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((className = reader.readLine()) != null) {
            Class<?> functionClazz = Class.forName(className);
            functionClasses.add(functionClazz);
        }
        return functionClasses;
    }

    private static class TestExpressionVisitor
    implements ExpressionVisitor {
        public Object[] functionVisited = new Object[]{Boolean.FALSE, null};

        private TestExpressionVisitor() {
        }

        public Object visit(Function expression, Object extraData) {
            this.functionVisited[0] = Boolean.TRUE;
            this.functionVisited[1] = extraData;
            return null;
        }

        public Object visit(Add expression, Object extraData) {
            return null;
        }

        public Object visit(Divide expression, Object extraData) {
            return null;
        }

        public Object visit(Literal expression, Object extraData) {
            return null;
        }

        public Object visit(Multiply expression, Object extraData) {
            return null;
        }

        public Object visit(PropertyName expression, Object extraData) {
            return null;
        }

        public Object visit(Subtract expression, Object extraData) {
            return null;
        }

        public Object visit(NilExpression arg0, Object arg1) {
            return null;
        }
    }
}

