/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.CategorizeFunction;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.Collection_AverageFunction;
import org.geotools.filter.function.Collection_BoundsFunction;
import org.geotools.filter.function.Collection_CountFunction;
import org.geotools.filter.function.Collection_MaxFunction;
import org.geotools.filter.function.Collection_MedianFunction;
import org.geotools.filter.function.Collection_MinFunction;
import org.geotools.filter.function.Collection_NearestFunction;
import org.geotools.filter.function.Collection_SumFunction;
import org.geotools.filter.function.Collection_UniqueFunction;
import org.geotools.filter.function.DefaultFunctionFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;

public class FunctionToStringTest {
    static FilterFactory ff;
    private DefaultFunctionFactory functionFactory;
    private static List<String> collectionFunctionList;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ff = CommonFactoryFinder.getFilterFactory(null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ff = null;
    }

    @Test
    public void testFunctionToStringMethod() {
        this.functionFactory = new DefaultFunctionFactory();
        List functionNameList = this.functionFactory.getFunctionNames();
        boolean fail = false;
        for (FunctionName functionName : functionNameList) {
            try {
                Expression expression = this.createExpression(functionName);
                if (expression != null) {
                    String result = expression.toString();
                    if (!result.contains("@")) continue;
                }
                fail = true;
            }
            catch (Exception e) {
                fail = true;
            }
        }
        Assert.assertFalse((boolean)fail);
    }

    private Expression createExpression(FunctionName functionName) {
        if (functionName == null) {
            return null;
        }
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        Literal fallback = null;
        FunctionToStringTest.createNewFunctionParameters(functionName, parameters);
        Function function = this.functionFactory.function(functionName.getFunctionName(), parameters, fallback);
        return function;
    }

    private static void createNewFunctionParameters(FunctionName functionName, List<Expression> parameters) {
        String name = functionName.getName();
        if (collectionFunctionList.contains(name)) {
            parameters.add((Expression)ff.property("geom"));
        } else if (name.compareToIgnoreCase(CategorizeFunction.NAME.getName()) == 0) {
            for (int index = 0; index < functionName.getArguments().size() - 1; ++index) {
                parameters.add(index, (Expression)ff.literal((Object)""));
            }
            parameters.remove(parameters.size() - 1);
            parameters.add((Expression)ff.literal((Object)"preceding"));
        } else {
            List functionParamList = functionName.getArguments();
            for (int paramIndex = 0; paramIndex < functionParamList.size(); ++paramIndex) {
                Parameter param = (Parameter)functionParamList.get(paramIndex);
                Class type = param.getType();
                if (type == Object.class) {
                    parameters.add((Expression)ff.literal((Object)""));
                    continue;
                }
                if (type == String.class) {
                    parameters.add((Expression)ff.literal((Object)""));
                    continue;
                }
                if (type == Number.class || type == Double.class) {
                    parameters.add((Expression)ff.literal(0.0));
                    continue;
                }
                if (type == Float.class) {
                    parameters.add((Expression)ff.literal(0.0f));
                    continue;
                }
                if (type == Integer.class || type == Long.class) {
                    parameters.add((Expression)ff.literal(0));
                    continue;
                }
                if (type == Boolean.class) {
                    parameters.add((Expression)ff.literal(false));
                    continue;
                }
                if (type == Unit.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Color.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Geometry.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == org.opengis.geometry.Geometry.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == LineString.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Classifier.class) {
                    parameters.add(null);
                    continue;
                }
                if (type == Class.class) {
                    parameters.add(null);
                    continue;
                }
                if (type.getName().compareToIgnoreCase("org.geotools.filter.function.color.AbstractHSLFunction$Method") == 0) {
                    parameters.add(null);
                    continue;
                }
                if (type.getName().compareToIgnoreCase("org.geotools.styling.visitor.RescalingMode") == 0) {
                    parameters.add((Expression)ff.literal(0));
                    continue;
                }
                Object newObj = null;
                try {
                    newObj = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    Logger.getGlobal().log(Level.INFO, "", e);
                }
                parameters.add((Expression)ff.literal(newObj));
            }
        }
    }

    static {
        collectionFunctionList = Arrays.asList(Collection_AverageFunction.NAME.getName(), Collection_BoundsFunction.NAME.getName(), Collection_CountFunction.NAME.getName(), Collection_MaxFunction.NAME.getName(), Collection_MedianFunction.NAME.getName(), Collection_MinFunction.NAME.getName(), Collection_NearestFunction.NAME.getName(), Collection_SumFunction.NAME.getName(), Collection_UniqueFunction.NAME.getName());
    }
}

