/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Literal;

public class LiteralTest
extends TestCase {
    FilterFactory ff;

    protected void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    public void testValidConstruction() throws Exception {
        LiteralExpressionImpl a = new LiteralExpressionImpl((Object)10.0);
        LiteralExpressionImpl b = new LiteralExpressionImpl("Label");
        LiteralExpressionImpl c = new LiteralExpressionImpl((Object)10);
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        LiteralExpressionImpl d = new LiteralExpressionImpl((Object)gf.createGeometryCollection(null));
    }

    public void testInvalidConstruction1() throws Exception {
        try {
            LiteralExpressionImpl a = new LiteralExpressionImpl((Object)10.0);
            LiteralExpressionImpl literalExpressionImpl = new LiteralExpressionImpl((Object)a);
        }
        catch (IllegalFilterException ife) {
            return;
        }
    }

    public void testConversion() throws Exception {
        LiteralTest.assertEquals((Object)"abc", (Object)this.ff.literal((Object)"abc").evaluate(null));
        LiteralTest.assertEquals((Object)12, (Object)this.ff.literal((Object)"12").evaluate(null, Integer.class));
        LiteralTest.assertEquals((Object)12.0, (Object)this.ff.literal((Object)"12.0").evaluate(null, Double.class));
        LiteralTest.assertEquals((Object)12.5, (Object)this.ff.literal((Object)"12.5").evaluate(null, Double.class));
        LiteralTest.assertEquals((Object)Long.MAX_VALUE, (Object)this.ff.literal((Object)"9223372036854775807").evaluate(null, Long.class));
        BigInteger doubleMaxLong = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
        LiteralTest.assertEquals((Object)doubleMaxLong, (Object)this.ff.literal((Object)doubleMaxLong.toString()).evaluate(null, BigInteger.class));
    }

    public void testDateEquality() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(2012, 6, 15);
        Date d1 = cal.getTime();
        cal.set(2012, 8, 15);
        Date d2 = cal.getTime();
        Date d3 = cal.getTime();
        Literal l1 = this.ff.literal((Object)d1);
        Literal l2 = this.ff.literal((Object)d2);
        LiteralTest.assertFalse((boolean)l1.equals(l2));
        Literal l3 = this.ff.literal((Object)d3);
        LiteralTest.assertTrue((boolean)l2.equals(l3));
    }
}

