/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import junit.framework.TestCase;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MathTest
extends TestCase {
    SimpleFeatureType schema = null;

    public MathTest(String testName) {
        super(testName);
    }

    public SimpleFeature[] sampleFeatures() throws Exception {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("value", Integer.class);
        ftb.add("geometry", Geometry.class);
        ftb.add("name", String.class);
        ftb.setName("testSchema");
        this.schema = ftb.buildFeatureType();
        SimpleFeature[] f = new SimpleFeature[3];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        f[0] = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{12, gf.createGeometryCollection(null), "first"}, null);
        f[1] = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{3, gf.createGeometryCollection(null), "second"}, null);
        f[2] = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{15, gf.createGeometryCollection(null), "third"}, null);
        return f;
    }

    public void testTypeMissmatch() throws Exception {
        SimpleFeature[] f = this.sampleFeatures();
        AttributeExpressionImpl e1 = new AttributeExpressionImpl(this.schema, "value");
        AttributeExpressionImpl e2 = new AttributeExpressionImpl(this.schema, "name");
        boolean pass = false;
        Object value = null;
        value = e1.evaluate((Object)f[0]);
        if (value instanceof Integer) {
            pass = true;
        }
        MathTest.assertTrue((String)"String expresion returned an Integer", (boolean)pass);
        pass = false;
        value = e2.evaluate((Object)f[0]);
        if (value instanceof String) {
            pass = true;
        }
        MathTest.assertTrue((String)"Integer expresion returned a String", (boolean)pass);
    }

    public void testSetupAndExtraction() throws Exception {
        SimpleFeature[] f = this.sampleFeatures();
        AttributeExpressionImpl e1 = new AttributeExpressionImpl(this.schema, "value");
        AttributeExpressionImpl e2 = new AttributeExpressionImpl(this.schema, "name");
        MathTest.assertEquals((double)12.0, (double)((Integer)e1.evaluate((Object)f[0])).doubleValue(), (double)0.0);
        MathTest.assertEquals((double)3.0, (double)((Integer)e1.evaluate((Object)f[1])).doubleValue(), (double)0.0);
        MathTest.assertEquals((double)15.0, (double)((Integer)e1.evaluate((Object)f[2])).doubleValue(), (double)0.0);
        MathTest.assertEquals((String)"first", (String)((String)e2.evaluate((Object)f[0])));
        MathTest.assertEquals((String)"second", (String)((String)e2.evaluate((Object)f[1])));
    }
}

