/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.geotools.data.DataTestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.function.FilterFunction_property;
import org.junit.After;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FilterFunctionPropertyTest
extends DataTestCase {
    private static final int LOOPS = 5000;
    static FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    public FilterFunctionPropertyTest() {
        super(FilterFunctionPropertyTest.class.getName());
    }

    @After
    public void teardown() {
        EnvFunction.clearLocalValues();
    }

    @Test
    public void testLocateFunction() {
        Function f = new FunctionFinder(null).findFunction("property");
        FilterFunctionPropertyTest.assertNotNull((Object)f);
        FilterFunctionPropertyTest.assertTrue((boolean)(f instanceof FilterFunction_property));
    }

    @Test
    public void testEvaluateProperty() {
        Function f = FF.function("property", new Expression[]{FF.literal((Object)"name")});
        String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        FilterFunctionPropertyTest.assertEquals((String)"r1", (String)result);
    }

    @Test
    public void testEvaluateAndConvert() {
        Function f = FF.function("property", new Expression[]{FF.literal((Object)"geom")});
        String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        FilterFunctionPropertyTest.assertEquals((String)"LINESTRING (1 1, 2 2, 4 2, 5 1)", (String)result);
    }

    @Test
    public void testEvaluateAlternate() {
        Function f = FF.function("property", new Expression[]{FF.function("env", new Expression[]{FF.literal((Object)"pname")})});
        EnvFunction.setLocalValue((String)"pname", (Object)"name");
        String result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        FilterFunctionPropertyTest.assertEquals((String)"r1", (String)result);
        EnvFunction.setLocalValue((String)"pname", (Object)"geom");
        result = (String)f.evaluate((Object)this.roadFeatures[0], String.class);
        FilterFunctionPropertyTest.assertEquals((String)"LINESTRING (1 1, 2 2, 4 2, 5 1)", (String)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvaluateMultithreaded() throws Exception {
        final Function f = FF.function("property", new Expression[]{FF.function("env", new Expression[]{FF.literal((Object)"pname")})});
        Callable<Void> nameEvaluator = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    EnvFunction.setLocalValue((String)"pname", (Object)"name");
                    for (int i = 0; i < 1000; ++i) {
                        String result = (String)f.evaluate((Object)FilterFunctionPropertyTest.this.roadFeatures[0], String.class);
                        TestCase.assertEquals((String)"r1", (String)result);
                    }
                }
                finally {
                    EnvFunction.clearLocalValues();
                }
                return null;
            }
        };
        Callable<Void> geomEvaluator = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    EnvFunction.setLocalValue((String)"pname", (Object)"geom");
                    for (int i = 0; i < 5000; ++i) {
                        String result = (String)f.evaluate((Object)FilterFunctionPropertyTest.this.roadFeatures[0], String.class);
                        TestCase.assertEquals((String)"LINESTRING (1 1, 2 2, 4 2, 5 1)", (String)result);
                    }
                }
                finally {
                    EnvFunction.clearLocalValues();
                }
                return null;
            }
        };
        ExecutorService es = Executors.newCachedThreadPool();
        try {
            Future<Void> fname = es.submit(nameEvaluator);
            Future<Void> fgeom = es.submit(geomEvaluator);
            fname.get();
            fgeom.get();
        }
        finally {
            es.shutdown();
        }
    }
}

