/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.FilterFunction_listMultiply;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class FilterFunction_listMultiplyTest {
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected SimpleFeatureType dataType;
    protected SimpleFeature[] testFeatures;
    protected SimpleFeatureCollection featureCollection;
    private String[] dashArrays = null;
    private String[] expectedDashArrays = null;

    @Before
    public void setUp() throws Exception {
        this.dataType = DataUtilities.createType((String)"listMultiply.test1", (String)"id:0,geom:Point,dynamic_dasharray:String");
        this.dashArrays = new String[]{"5 10", "15 30"};
        this.expectedDashArrays = new String[]{"10.0 20.0", "30.0 60.0"};
        this.testFeatures = new SimpleFeature[this.dashArrays.length];
        GeometryFactory fac = new GeometryFactory();
        for (int i = 0; i < this.dashArrays.length; ++i) {
            this.testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)this.dataType, (Object[])new Object[]{i + 1, fac.createPoint(new Coordinate((double)i, (double)i)), this.dashArrays[i]}, (String)("obj:" + i));
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testFunctionMetaInfo() {
        FunctionName functionName = this.ff.functionName("listMultiply", 2);
        Assert.assertNotNull((Object)functionName);
    }

    @Test
    public void testEvaluate() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2), this.ff.literal((Object)"1 2 3")});
        Object evaluate = func.evaluate(null);
        Assert.assertTrue((boolean)(evaluate instanceof String));
        Assert.assertEquals((Object)"2.0 4.0 6.0", (Object)evaluate.toString());
    }

    @Test
    public void testEvaluate2() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2.5), this.ff.literal((Object)"1 2 3")});
        Object evaluate = func.evaluate(null);
        Assert.assertTrue((boolean)(evaluate instanceof String));
        Assert.assertEquals((Object)"2.5 5.0 7.5", (Object)evaluate.toString());
    }

    @Test
    public void testEvaluateNull() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2.5), this.ff.literal((Object)null)});
        Object evaluate = func.evaluate(null);
        Assert.assertNull((Object)evaluate);
    }

    @Test
    public void testEvaluate4() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(1), this.ff.literal((Object)"1 2 3")});
        Object evaluate = func.evaluate(null);
        Assert.assertTrue((boolean)(evaluate instanceof String));
        Assert.assertEquals((Object)"1.0 2.0 3.0", (Object)evaluate.toString());
    }

    @Test
    public void testEvaluate5() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2), this.ff.property("dynamic_dasharray")});
        for (int i = 0; i < this.testFeatures.length; ++i) {
            Object evaluate = func.evaluate((Object)this.testFeatures[i]);
            Assert.assertTrue((boolean)(evaluate instanceof String));
            Assert.assertEquals((Object)this.expectedDashArrays[i], (Object)evaluate.toString());
        }
    }

    @Test
    public void testEvaluateNullDasharray() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2.5), null});
        Object evaluate = func.evaluate(null);
        Assert.assertNull((Object)evaluate);
    }

    @Test
    public void testEvaluateEmptyDasharray() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2.5), this.ff.literal((Object)"")});
        Object evaluate = func.evaluate(null);
        Assert.assertNull((Object)evaluate);
    }

    @Test
    public void testEvaluateMultipleSpaces() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2), this.ff.literal((Object)" 1 2   3 ")});
        Object evaluate = func.evaluate(null);
        Assert.assertTrue((boolean)(evaluate instanceof String));
        Assert.assertEquals((Object)"2.0 4.0 6.0", (Object)evaluate.toString());
    }

    @Test
    public void testEvaluateSingleValue() {
        FilterFunction_listMultiply func = (FilterFunction_listMultiply)this.ff.function("listMultiply", new Expression[]{this.ff.literal(2), this.ff.literal((Object)" 1")});
        Object evaluate = func.evaluate(null);
        Assert.assertTrue((boolean)(evaluate instanceof String));
        Assert.assertEquals((Object)"2.0", (Object)evaluate.toString());
    }
}

