/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.JenksNaturalBreaksFunction;
import org.geotools.filter.function.RangedClassifier;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class JenksFunctionTest
extends FunctionTestSupport {
    public JenksFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(JenksFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function equInt = this.ff.function("Jenks", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        JenksFunctionTest.assertNotNull((Object)equInt);
    }

    public void testGetName() {
        Function qInt = this.ff.function("Jenks", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        JenksFunctionTest.assertEquals((String)"Jenks", (String)qInt.getName());
    }

    public void testSetParameters() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName expr = this.ff.property("foo");
        JenksNaturalBreaksFunction func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        JenksFunctionTest.assertEquals((int)3, (int)func.getClasses());
        classes = this.ff.literal(12);
        func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        JenksFunctionTest.assertEquals((int)12, (int)func.getClasses());
        classes = this.ff.literal(5);
        func = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{expr, classes});
        JenksFunctionTest.assertEquals((int)5, (int)func.getClasses());
    }

    public void testEvaluateRealData() throws Exception {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("jenks71");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.jenksCollection);
        JenksFunctionTest.assertNotNull((Object)value);
        JenksFunctionTest.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        JenksFunctionTest.assertEquals((int)5, (int)ranged.getSize());
        JenksFunctionTest.assertEquals((String)"15.57..41.2", (String)ranged.getTitle(0));
        JenksFunctionTest.assertEquals((String)"41.2..60.66", (String)ranged.getTitle(1));
        JenksFunctionTest.assertEquals((String)"60.66..77.29", (String)ranged.getTitle(2));
        JenksFunctionTest.assertEquals((String)"77.29..100.1", (String)ranged.getTitle(3));
        JenksFunctionTest.assertEquals((String)"100.1..155.3", (String)ranged.getTitle(4));
    }

    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.featureCollection);
        JenksFunctionTest.assertNotNull((Object)value);
        JenksFunctionTest.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        JenksFunctionTest.assertEquals((int)2, (int)ranged.getSize());
        JenksFunctionTest.assertEquals((String)"4..29", (String)ranged.getTitle(0));
        JenksFunctionTest.assertEquals((String)"29..90", (String)ranged.getTitle(1));
    }

    public void testSingleBin() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.test1" + (i + 1)));
        }
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])myfeatures);
        SimpleFeatureCollection myFeatureCollection = source.getFeatures();
        Function function = this.ff.function("Jenks", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        JenksFunctionTest.assertNotNull((Object)classifier);
        JenksFunctionTest.assertEquals(classifier.getClass(), RangedClassifier.class);
        RangedClassifier range = (RangedClassifier)classifier;
        JenksFunctionTest.assertEquals((int)5, (int)range.getSize());
        for (int i = 0; i < 5; ++i) {
            JenksFunctionTest.assertTrue(((double)(i + 1) == ((Number)range.getMin(i)).doubleValue() ? 1 : 0) != 0);
            if (i != 4) {
                JenksFunctionTest.assertEquals((String)"wrong value for max", (int)(i + 2), (int)((Number)range.getMax(i)).intValue());
                JenksFunctionTest.assertEquals((String)"bad title", (String)(i + 1 + ".." + (i + 2)), (String)range.getTitle(i));
                continue;
            }
            JenksFunctionTest.assertEquals((String)"wrong value for max", (int)(i + 1), (int)((Number)range.getMax(i)).intValue());
            JenksFunctionTest.assertEquals((String)"bad title", (String)(i + 1 + ".." + (i + 1)), (String)range.getTitle(i));
        }
    }

    public void test2() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5, 6};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.t" + (i + 1)));
        }
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])myfeatures);
        SimpleFeatureCollection myFeatureCollection = source.getFeatures();
        Function function = this.ff.function("Jenks", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        RangedClassifier range = (RangedClassifier)classifier;
    }

    public void xtestNullNaNHandling() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"classification.nullnan", (String)"id:0,foo:int,bar:double");
        Integer[] iVal = new Integer[]{0, 0, 0, 13, 13, 13, null, null, null};
        Double[] dVal = new Double[]{0.0, 50.01, null, 0.0, 50.01, null, 0.0, 50.01, null};
        SimpleFeature[] testFeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{i + 1, iVal[i], dVal[i]}, (String)("nantest.t" + (i + 1)));
        }
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])testFeatures);
        SimpleFeatureCollection thisFC = source.getFeatures();
        Divide divide = this.ff.divide((Expression)this.ff.property("foo"), (Expression)this.ff.property("bar"));
        JenksNaturalBreaksFunction qf = (JenksNaturalBreaksFunction)this.ff.function("Jenks", new Expression[]{divide, this.ff.literal(3)});
        RangedClassifier range = (RangedClassifier)qf.evaluate((Object)thisFC);
        JenksFunctionTest.assertEquals((int)3, (int)range.getSize());
        JenksFunctionTest.assertEquals((String)"0..0", (String)range.getTitle(0));
        JenksFunctionTest.assertEquals((String)"0..0", (String)range.getTitle(1));
    }

    public void testConstantValuesNumeric() {
        Function function = this.ff.function("jenks", new Expression[]{this.ff.property("v"), this.ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        JenksFunctionTest.assertNotNull((Object)classifier);
        JenksFunctionTest.assertEquals((int)1, (int)classifier.getSize());
        JenksFunctionTest.assertEquals((double)123.123, (double)((Double)classifier.getMin(0)), (double)0.0);
        JenksFunctionTest.assertEquals((double)123.123, (double)((Double)classifier.getMax(0)), (double)0.0);
    }

    public void testEvaluateNumericalWithPercentages() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Jenks", new Expression[]{exp, classes, this.ff.literal(true)});
        Object value = func.evaluate((Object)this.featureCollection);
        JenksFunctionTest.assertNotNull((Object)value);
        JenksFunctionTest.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        double[] percentages = ranged.getPercentages();
        JenksFunctionTest.assertEquals((int)percentages.length, (int)3);
        JenksFunctionTest.assertEquals((Object)percentages[0], (Object)37.5);
        JenksFunctionTest.assertEquals((Object)percentages[1], (Object)25.0);
        JenksFunctionTest.assertEquals((Object)percentages[2], (Object)37.5);
    }
}

