/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.SEFunctionTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class StringTemplateFunctionTest
extends SEFunctionTestBase {
    private Literal fallback;

    @Before
    public void setup() {
        this.parameters = new ArrayList();
        this.fallback = this.ff2.literal((Object)"NOT_FOUND");
    }

    @Test
    public void testConcatenate() {
        this.parameters.add(this.ff2.literal((Object)"123"));
        this.parameters.add(this.ff2.literal((Object)".*"));
        this.parameters.add(this.ff2.literal((Object)"start${0}end"));
        Function fn = this.finder.findFunction("stringTemplate", this.parameters, this.fallback);
        Object result = fn.evaluate(null);
        Assert.assertEquals((Object)"start123end", (Object)result);
    }

    @Test
    public void testCapturingGroups() {
        this.parameters.add(this.ff2.literal((Object)"abc123_678"));
        this.parameters.add(this.ff2.literal((Object)".*(\\d{3})_(\\d{3})"));
        this.parameters.add(this.ff2.literal((Object)"first${1}_second${2}_full${0}"));
        Function fn = this.finder.findFunction("stringTemplate", this.parameters, this.fallback);
        Object result = fn.evaluate(null);
        Assert.assertEquals((Object)"first123_second678_fullabc123_678", (Object)result);
    }

    @Test
    public void testFallback() {
        this.parameters.add(this.ff2.literal((Object)"abc12_67"));
        this.parameters.add(this.ff2.literal((Object)".*(\\d{3})_(\\d{3})"));
        this.parameters.add(this.ff2.literal((Object)"first${1}_second${2}_full${0}"));
        this.parameters.add(this.ff2.literal((Object)"noMatch"));
        Function fn = this.finder.findFunction("stringTemplate", this.parameters, this.fallback);
        Object result = fn.evaluate(null);
        Assert.assertEquals((Object)"noMatch", (Object)result);
    }

    @Test
    public void testDynamic() throws SchemaException {
        this.parameters.add(this.ff2.property("input"));
        this.parameters.add(this.ff2.property("pattern"));
        this.parameters.add(this.ff2.property("template"));
        Function fn = this.finder.findFunction("stringTemplate", this.parameters, this.fallback);
        SimpleFeatureType type = DataUtilities.createType((String)"test", (String)"input:string,pattern:string,template:string");
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"abc123_567", ".*(\\d{3})_(\\d{3})", "${1}|${2}"}, null);
        Assert.assertEquals((Object)"123|567", (Object)fn.evaluate((Object)f1));
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"abc12_67", "(.*)_(\\d{3})", "${1}_${2}"}, null);
        Assert.assertEquals(null, (Object)fn.evaluate((Object)f2));
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"abc12_67", "(.*)_(.*)", "${1}|${2}"}, null);
        Assert.assertEquals((Object)"abc12|67", (Object)fn.evaluate((Object)f3));
    }
}

