/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.function.math.FilterFunction_IEEEremainder;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_acos;
import org.geotools.filter.function.math.FilterFunction_asin;
import org.geotools.filter.function.math.FilterFunction_atan;
import org.geotools.filter.function.math.FilterFunction_atan2;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_cos;
import org.geotools.filter.function.math.FilterFunction_exp;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.filter.function.math.FilterFunction_log;
import org.geotools.filter.function.math.FilterFunction_max;
import org.geotools.filter.function.math.FilterFunction_max_2;
import org.geotools.filter.function.math.FilterFunction_max_3;
import org.geotools.filter.function.math.FilterFunction_max_4;
import org.geotools.filter.function.math.FilterFunction_min;
import org.geotools.filter.function.math.FilterFunction_min_2;
import org.geotools.filter.function.math.FilterFunction_min_3;
import org.geotools.filter.function.math.FilterFunction_min_4;
import org.geotools.filter.function.math.FilterFunction_pow;
import org.geotools.filter.function.math.FilterFunction_random;
import org.geotools.filter.function.math.FilterFunction_rint;
import org.geotools.filter.function.math.FilterFunction_round;
import org.geotools.filter.function.math.FilterFunction_round_2;
import org.geotools.filter.function.math.FilterFunction_sin;
import org.geotools.filter.function.math.FilterFunction_sqrt;
import org.geotools.filter.function.math.FilterFunction_tan;
import org.geotools.filter.function.math.FilterFunction_toDegrees;
import org.geotools.filter.function.math.FilterFunction_toRadians;
import org.geotools.util.factory.FactoryRegistryException;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FilterFunction_Test
extends TestCase {
    private Literal literal_1 = null;
    private Literal literal_m1;
    private Literal literal_2;
    private Literal literal_m2;
    private Literal literal_pi;
    private Literal literal_05pi;
    private Literal literal_null;
    private FilterFactory ff;

    protected void setUp() throws Exception {
        super.setUp();
        this.ff = (FilterFactoryImpl)CommonFactoryFinder.getFilterFactory2(null);
        this.literal_1 = this.ff.literal((Object)"1");
        this.literal_m1 = this.ff.literal((Object)"-1");
        this.literal_2 = this.ff.literal((Object)"2");
        this.literal_m2 = this.ff.literal((Object)"-2");
        this.literal_pi = this.ff.literal((Object)String.valueOf(Math.PI));
        this.literal_05pi = this.ff.literal((Object)String.valueOf(1.5707963267948966));
        this.literal_null = this.ff.literal(null);
        FilterFunction_Test.assertEquals((String)"Literal Expression 0.0", (Object)1.0, (Object)this.literal_1.evaluate(null, Double.class));
        FilterFunction_Test.assertEquals((String)"Literal Expression pi", (Object)Math.PI, (Object)this.literal_pi.evaluate(null, Double.class));
        FilterFunction_Test.assertEquals((String)"Literal Expression 05pi", (Object)1.5707963267948966, (Object)this.literal_05pi.evaluate(null, Double.class));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testsin() {
        try {
            FilterFunction_sin sin = (FilterFunction_sin)this.ff.function("sin", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"sin", (String)sin.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)sin.getFunctionName().getArgumentCount());
            Function sinFunction = this.ff.function("sin", new Expression[]{this.literal_1});
            double good0 = Math.sin(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"sin of (1.0):", (boolean)Double.isNaN((Double)sinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sin of (1.0):", (double)Math.sin(1.0), (double)((Double)sinFunction.evaluate(null)), (double)1.0E-5);
            }
            sinFunction = this.ff.function("sin", new Expression[]{this.literal_m1});
            double good1 = Math.sin(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"sin of (-1.0):", (boolean)Double.isNaN((Double)sinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sin of (-1.0):", (double)Math.sin(-1.0), (double)((Double)sinFunction.evaluate(null)), (double)1.0E-5);
            }
            sinFunction = this.ff.function("sin", new Expression[]{this.literal_2});
            double good2 = Math.sin(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"sin of (2.0):", (boolean)Double.isNaN((Double)sinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sin of (2.0):", (double)Math.sin(2.0), (double)((Double)sinFunction.evaluate(null)), (double)1.0E-5);
            }
            sinFunction = this.ff.function("sin", new Expression[]{this.literal_m2});
            double good3 = Math.sin(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"sin of (-2.0):", (boolean)Double.isNaN((Double)sinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sin of (-2.0):", (double)Math.sin(-2.0), (double)((Double)sinFunction.evaluate(null)), (double)1.0E-5);
            }
            sinFunction = this.ff.function("sin", new Expression[]{this.literal_pi});
            double good4 = Math.sin(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"sin of (3.141592653589793):", (boolean)Double.isNaN((Double)sinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sin of (3.141592653589793):", (double)Math.sin(Math.PI), (double)((Double)sinFunction.evaluate(null)), (double)1.0E-5);
            }
            sinFunction = this.ff.function("sin", new Expression[]{this.literal_05pi});
            double good5 = Math.sin(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"sin of (1.5707963267948966):", (boolean)Double.isNaN((Double)sinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sin of (1.5707963267948966):", (double)Math.sin(1.5707963267948966), (double)((Double)sinFunction.evaluate(null)), (double)1.0E-5);
            }
            sinFunction = this.ff.function("sin", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)sinFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testcos() {
        try {
            FilterFunction_cos cos = (FilterFunction_cos)this.ff.function("cos", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"cos", (String)cos.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)cos.getFunctionName().getArgumentCount());
            Function cosFunction = this.ff.function("cos", new Expression[]{this.literal_1});
            double good0 = Math.cos(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"cos of (1.0):", (boolean)Double.isNaN((Double)cosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"cos of (1.0):", (double)Math.cos(1.0), (double)((Double)cosFunction.evaluate(null)), (double)1.0E-5);
            }
            cosFunction = this.ff.function("cos", new Expression[]{this.literal_m1});
            double good1 = Math.cos(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"cos of (-1.0):", (boolean)Double.isNaN((Double)cosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"cos of (-1.0):", (double)Math.cos(-1.0), (double)((Double)cosFunction.evaluate(null)), (double)1.0E-5);
            }
            cosFunction = this.ff.function("cos", new Expression[]{this.literal_2});
            double good2 = Math.cos(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"cos of (2.0):", (boolean)Double.isNaN((Double)cosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"cos of (2.0):", (double)Math.cos(2.0), (double)((Double)cosFunction.evaluate(null)), (double)1.0E-5);
            }
            cosFunction = this.ff.function("cos", new Expression[]{this.literal_m2});
            double good3 = Math.cos(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"cos of (-2.0):", (boolean)Double.isNaN((Double)cosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"cos of (-2.0):", (double)Math.cos(-2.0), (double)((Double)cosFunction.evaluate(null)), (double)1.0E-5);
            }
            cosFunction = this.ff.function("cos", new Expression[]{this.literal_pi});
            double good4 = Math.cos(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"cos of (3.141592653589793):", (boolean)Double.isNaN((Double)cosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"cos of (3.141592653589793):", (double)Math.cos(Math.PI), (double)((Double)cosFunction.evaluate(null)), (double)1.0E-5);
            }
            cosFunction = this.ff.function("cos", new Expression[]{this.literal_05pi});
            double good5 = Math.cos(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"cos of (1.5707963267948966):", (boolean)Double.isNaN((Double)cosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"cos of (1.5707963267948966):", (double)Math.cos(1.5707963267948966), (double)((Double)cosFunction.evaluate(null)), (double)1.0E-5);
            }
            cosFunction = this.ff.function("cos", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)cosFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testtan() {
        try {
            FilterFunction_tan tan = (FilterFunction_tan)this.ff.function("tan", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"tan", (String)tan.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)tan.getFunctionName().getArgumentCount());
            Function tanFunction = this.ff.function("tan", new Expression[]{this.literal_1});
            double good0 = Math.tan(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"tan of (1.0):", (boolean)Double.isNaN((Double)tanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"tan of (1.0):", (double)Math.tan(1.0), (double)((Double)tanFunction.evaluate(null)), (double)1.0E-5);
            }
            tanFunction = this.ff.function("tan", new Expression[]{this.literal_m1});
            double good1 = Math.tan(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"tan of (-1.0):", (boolean)Double.isNaN((Double)tanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"tan of (-1.0):", (double)Math.tan(-1.0), (double)((Double)tanFunction.evaluate(null)), (double)1.0E-5);
            }
            tanFunction = this.ff.function("tan", new Expression[]{this.literal_2});
            double good2 = Math.tan(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"tan of (2.0):", (boolean)Double.isNaN((Double)tanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"tan of (2.0):", (double)Math.tan(2.0), (double)((Double)tanFunction.evaluate(null)), (double)1.0E-5);
            }
            tanFunction = this.ff.function("tan", new Expression[]{this.literal_m2});
            double good3 = Math.tan(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"tan of (-2.0):", (boolean)Double.isNaN((Double)tanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"tan of (-2.0):", (double)Math.tan(-2.0), (double)((Double)tanFunction.evaluate(null)), (double)1.0E-5);
            }
            tanFunction = this.ff.function("tan", new Expression[]{this.literal_pi});
            double good4 = Math.tan(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"tan of (3.141592653589793):", (boolean)Double.isNaN((Double)tanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"tan of (3.141592653589793):", (double)Math.tan(Math.PI), (double)((Double)tanFunction.evaluate(null)), (double)1.0E-5);
            }
            tanFunction = this.ff.function("tan", new Expression[]{this.literal_05pi});
            double good5 = Math.tan(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"tan of (1.5707963267948966):", (boolean)Double.isNaN((Double)tanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"tan of (1.5707963267948966):", (double)Math.tan(1.5707963267948966), (double)((Double)tanFunction.evaluate(null)), (double)1.0E-5);
            }
            tanFunction = this.ff.function("tan", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)tanFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testatan2() {
        try {
            FilterFunction_atan2 atan2 = (FilterFunction_atan2)this.ff.function("atan2", new Expression[]{Expression.NIL, Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"atan2", (String)atan2.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)atan2.getFunctionName().getArgumentCount());
            Function atan2Function = this.ff.function("atan2", new Expression[]{this.literal_1, this.literal_m1});
            double good0 = Math.atan2(1.0, -1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"atan2 of (1.0,-1.0):", (boolean)Double.isNaN((Double)atan2Function.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan2 of (1.0,-1.0):", (double)Math.atan2(1.0, -1.0), (double)((Double)atan2Function.evaluate(null)), (double)1.0E-5);
            }
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_m1, this.literal_2});
            double good1 = Math.atan2(-1.0, 2.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"atan2 of (-1.0,2.0):", (boolean)Double.isNaN((Double)atan2Function.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan2 of (-1.0,2.0):", (double)Math.atan2(-1.0, 2.0), (double)((Double)atan2Function.evaluate(null)), (double)1.0E-5);
            }
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_2, this.literal_m2});
            double good2 = Math.atan2(2.0, -2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"atan2 of (2.0,-2.0):", (boolean)Double.isNaN((Double)atan2Function.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan2 of (2.0,-2.0):", (double)Math.atan2(2.0, -2.0), (double)((Double)atan2Function.evaluate(null)), (double)1.0E-5);
            }
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_m2, this.literal_pi});
            double good3 = Math.atan2(-2.0, Math.PI);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"atan2 of (-2.0,3.141592653589793):", (boolean)Double.isNaN((Double)atan2Function.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan2 of (-2.0,3.141592653589793):", (double)Math.atan2(-2.0, Math.PI), (double)((Double)atan2Function.evaluate(null)), (double)1.0E-5);
            }
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_pi, this.literal_05pi});
            double good4 = Math.atan2(Math.PI, 1.5707963267948966);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"atan2 of (3.141592653589793,1.5707963267948966):", (boolean)Double.isNaN((Double)atan2Function.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan2 of (3.141592653589793,1.5707963267948966):", (double)Math.atan2(Math.PI, 1.5707963267948966), (double)((Double)atan2Function.evaluate(null)), (double)1.0E-5);
            }
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_05pi, this.literal_1});
            double good5 = Math.atan2(1.5707963267948966, 1.0);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"atan2 of (1.5707963267948966,1.0):", (boolean)Double.isNaN((Double)atan2Function.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan2 of (1.5707963267948966,1.0):", (double)Math.atan2(1.5707963267948966, 1.0), (double)((Double)atan2Function.evaluate(null)), (double)1.0E-5);
            }
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Double)atan2Function.evaluate(null)));
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)atan2Function.evaluate(null)));
            atan2Function = this.ff.function("atan2", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)atan2Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testsqrt() {
        try {
            FilterFunction_sqrt sqrt = (FilterFunction_sqrt)this.ff.function("sqrt", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"sqrt", (String)sqrt.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)sqrt.getFunctionName().getArgumentCount());
            Function sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_1});
            double good0 = Math.sqrt(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"sqrt of (1.0):", (boolean)Double.isNaN((Double)sqrtFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sqrt of (1.0):", (double)Math.sqrt(1.0), (double)((Double)sqrtFunction.evaluate(null)), (double)1.0E-5);
            }
            sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_m1});
            double good1 = Math.sqrt(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"sqrt of (-1.0):", (boolean)Double.isNaN((Double)sqrtFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sqrt of (-1.0):", (double)Math.sqrt(-1.0), (double)((Double)sqrtFunction.evaluate(null)), (double)1.0E-5);
            }
            sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_2});
            double good2 = Math.sqrt(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"sqrt of (2.0):", (boolean)Double.isNaN((Double)sqrtFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sqrt of (2.0):", (double)Math.sqrt(2.0), (double)((Double)sqrtFunction.evaluate(null)), (double)1.0E-5);
            }
            sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_m2});
            double good3 = Math.sqrt(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"sqrt of (-2.0):", (boolean)Double.isNaN((Double)sqrtFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sqrt of (-2.0):", (double)Math.sqrt(-2.0), (double)((Double)sqrtFunction.evaluate(null)), (double)1.0E-5);
            }
            sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_pi});
            double good4 = Math.sqrt(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"sqrt of (3.141592653589793):", (boolean)Double.isNaN((Double)sqrtFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sqrt of (3.141592653589793):", (double)Math.sqrt(Math.PI), (double)((Double)sqrtFunction.evaluate(null)), (double)1.0E-5);
            }
            sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_05pi});
            double good5 = Math.sqrt(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"sqrt of (1.5707963267948966):", (boolean)Double.isNaN((Double)sqrtFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"sqrt of (1.5707963267948966):", (double)Math.sqrt(1.5707963267948966), (double)((Double)sqrtFunction.evaluate(null)), (double)1.0E-5);
            }
            sqrtFunction = this.ff.function("sqrt", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)sqrtFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testpow() {
        try {
            FilterFunction_pow pow = (FilterFunction_pow)this.ff.function("pow", new Expression[]{Expression.NIL, Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"pow", (String)pow.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)pow.getFunctionName().getArgumentCount());
            Function powFunction = this.ff.function("pow", new Expression[]{this.literal_1, this.literal_m1});
            double good0 = Math.pow(1.0, -1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"pow of (1.0,-1.0):", (boolean)Double.isNaN((Double)powFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"pow of (1.0,-1.0):", (double)Math.pow(1.0, -1.0), (double)((Double)powFunction.evaluate(null)), (double)1.0E-5);
            }
            powFunction = this.ff.function("pow", new Expression[]{this.literal_m1, this.literal_2});
            double good1 = Math.pow(-1.0, 2.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"pow of (-1.0,2.0):", (boolean)Double.isNaN((Double)powFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"pow of (-1.0,2.0):", (double)Math.pow(-1.0, 2.0), (double)((Double)powFunction.evaluate(null)), (double)1.0E-5);
            }
            powFunction = this.ff.function("pow", new Expression[]{this.literal_2, this.literal_m2});
            double good2 = Math.pow(2.0, -2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"pow of (2.0,-2.0):", (boolean)Double.isNaN((Double)powFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"pow of (2.0,-2.0):", (double)Math.pow(2.0, -2.0), (double)((Double)powFunction.evaluate(null)), (double)1.0E-5);
            }
            powFunction = this.ff.function("pow", new Expression[]{this.literal_m2, this.literal_pi});
            double good3 = Math.pow(-2.0, Math.PI);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"pow of (-2.0,3.141592653589793):", (boolean)Double.isNaN((Double)powFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"pow of (-2.0,3.141592653589793):", (double)Math.pow(-2.0, Math.PI), (double)((Double)powFunction.evaluate(null)), (double)1.0E-5);
            }
            powFunction = this.ff.function("pow", new Expression[]{this.literal_pi, this.literal_05pi});
            double good4 = Math.pow(Math.PI, 1.5707963267948966);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"pow of (3.141592653589793,1.5707963267948966):", (boolean)Double.isNaN((Double)powFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"pow of (3.141592653589793,1.5707963267948966):", (double)Math.pow(Math.PI, 1.5707963267948966), (double)((Double)powFunction.evaluate(null)), (double)1.0E-5);
            }
            powFunction = this.ff.function("pow", new Expression[]{this.literal_05pi, this.literal_1});
            double good5 = Math.pow(1.5707963267948966, 1.0);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"pow of (1.5707963267948966,1.0):", (boolean)Double.isNaN((Double)powFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"pow of (1.5707963267948966,1.0):", (double)Math.pow(1.5707963267948966, 1.0), (double)((Double)powFunction.evaluate(null)), (double)1.0E-5);
            }
            powFunction = this.ff.function("pow", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Double)powFunction.evaluate(null)));
            powFunction = this.ff.function("pow", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)powFunction.evaluate(null)));
            powFunction = this.ff.function("pow", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)powFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmin_4() {
        try {
            FilterFunction_min_4 min_4 = (FilterFunction_min_4)this.ff.function("min_4", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"min_4", (String)min_4.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)min_4.getFunctionName().getArgumentCount());
            Function min_4Function = this.ff.function("min_4", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"min of (1.0,-1.0):", (double)((long)Math.min(1.0, -1.0)), (double)((Integer)min_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"min of (-1.0,2.0):", (double)((long)Math.min(-1.0, 2.0)), (double)((Integer)min_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"min of (2.0,-2.0):", (double)((long)Math.min(2.0, -2.0)), (double)((Integer)min_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"min of (-2.0,3.141592653589793):", (double)((long)Math.min(-2.0, Math.PI)), (double)((Integer)min_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"min of (3.141592653589793,1.5707963267948966):", (double)((long)Math.min(Math.PI, 1.5707963267948966)), (double)((Integer)min_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"min of (1.5707963267948966,1.0):", (double)((long)Math.min(1.5707963267948966, 1.0)), (double)((Integer)min_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Long)min_4Function.evaluate(null)));
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)min_4Function.evaluate(null)));
            min_4Function = this.ff.function("min_4", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)min_4Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmin_2() {
        try {
            FilterFunction_min_2 min_2 = (FilterFunction_min_2)this.ff.function("min_2", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"min_2", (String)min_2.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)min_2.getFunctionName().getArgumentCount());
            Function min_2Function = this.ff.function("min_2", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"min of (1.0,-1.0):", (double)((long)Math.min(1.0, -1.0)), (double)((Long)min_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"min of (-1.0,2.0):", (double)((long)Math.min(-1.0, 2.0)), (double)((Long)min_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"min of (2.0,-2.0):", (double)((long)Math.min(2.0, -2.0)), (double)((Long)min_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"min of (-2.0,3.141592653589793):", (double)((long)Math.min(-2.0, Math.PI)), (double)((Long)min_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"min of (3.141592653589793,1.5707963267948966):", (double)((long)Math.min(Math.PI, 1.5707963267948966)), (double)((Long)min_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"min of (1.5707963267948966,1.0):", (double)((long)Math.min(1.5707963267948966, 1.0)), (double)((Long)min_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Long)min_2Function.evaluate(null)));
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)min_2Function.evaluate(null)));
            min_2Function = this.ff.function("min_2", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)min_2Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmin_3() {
        try {
            FilterFunction_min_3 min_3 = (FilterFunction_min_3)this.ff.function("min_3", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"min_3", (String)min_3.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)min_3.getFunctionName().getArgumentCount());
            Function min_3Function = this.ff.function("min_3", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"min of (1.0,-1.0):", (double)((float)Math.min(1.0, -1.0)), (double)((Float)min_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"min of (-1.0,2.0):", (double)((float)Math.min(-1.0, 2.0)), (double)((Float)min_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"min of (2.0,-2.0):", (double)((float)Math.min(2.0, -2.0)), (double)((Float)min_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"min of (-2.0,3.141592653589793):", (double)((float)Math.min(-2.0, Math.PI)), (double)((Float)min_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"min of (3.141592653589793,1.5707963267948966):", (double)((float)Math.min(Math.PI, 1.5707963267948966)), (double)((Float)min_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"min of (1.5707963267948966,1.0):", (double)((float)Math.min(1.5707963267948966, 1.0)), (double)((Float)min_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Float)min_3Function.evaluate(null)));
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Float)min_3Function.evaluate(null)));
            min_3Function = this.ff.function("min_3", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Float)min_3Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmin() {
        try {
            FilterFunction_min min = (FilterFunction_min)this.ff.function("min", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"min", (String)min.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)min.getFunctionName().getArgumentCount());
            Function minFunction = this.ff.function("min", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"min of (1.0,-1.0):", (double)Math.min(1.0, -1.0), (double)((Double)minFunction.evaluate(null)), (double)1.0E-5);
            minFunction = this.ff.function("min", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"min of (-1.0,2.0):", (double)Math.min(-1.0, 2.0), (double)((Double)minFunction.evaluate(null)), (double)1.0E-5);
            minFunction = this.ff.function("min", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"min of (2.0,-2.0):", (double)Math.min(2.0, -2.0), (double)((Double)minFunction.evaluate(null)), (double)1.0E-5);
            minFunction = this.ff.function("min", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"min of (-2.0,3.141592653589793):", (double)Math.min(-2.0, Math.PI), (double)((Double)minFunction.evaluate(null)), (double)1.0E-5);
            minFunction = this.ff.function("min", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"min of (3.141592653589793,1.5707963267948966):", (double)Math.min(Math.PI, 1.5707963267948966), (double)((Double)minFunction.evaluate(null)), (double)1.0E-5);
            minFunction = this.ff.function("min", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"min of (1.5707963267948966,1.0):", (double)Math.min(1.5707963267948966, 1.0), (double)((Double)minFunction.evaluate(null)), (double)1.0E-5);
            minFunction = this.ff.function("min", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Double)minFunction.evaluate(null)));
            minFunction = this.ff.function("min", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)minFunction.evaluate(null)));
            minFunction = this.ff.function("min", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)minFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmax_4() {
        try {
            FilterFunction_max_4 max_4 = (FilterFunction_max_4)this.ff.function("max_4", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"max_4", (String)max_4.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)max_4.getFunctionName().getArgumentCount());
            Function max_4Function = this.ff.function("max_4", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"max_4 of (1.0,-1.0):", (double)((int)Math.max(1.0, -1.0)), (double)((Integer)max_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"max_4 of (-1.0,2.0):", (double)((int)Math.max(-1.0, 2.0)), (double)((Integer)max_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"max_4 of (2.0,-2.0):", (double)((int)Math.max(2.0, -2.0)), (double)((Integer)max_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"max_4 of (-2.0,3.141592653589793):", (double)((int)Math.max(-2.0, Math.PI)), (double)((Integer)max_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"max_4 of (3.141592653589793,1.5707963267948966):", (double)((int)Math.max(Math.PI, 1.5707963267948966)), (double)((Integer)max_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"max_4 of (1.5707963267948966,1.0):", (double)((int)Math.max(1.5707963267948966, 1.0)), (double)((Integer)max_4Function.evaluate(null)).intValue(), (double)1.0E-5);
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Integer)max_4Function.evaluate(null)));
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Integer)max_4Function.evaluate(null)));
            max_4Function = this.ff.function("max_4", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Integer)max_4Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmax_2() {
        try {
            FilterFunction_max_2 max_2 = (FilterFunction_max_2)this.ff.function("max_2", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"max_2", (String)max_2.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)max_2.getFunctionName().getArgumentCount());
            Function max_2Function = this.ff.function("max_2", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"max_2 of (1.0,-1.0):", (double)((long)Math.max(1.0, -1.0)), (double)((Long)max_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"max_2 of (-1.0,2.0):", (double)((long)Math.max(-1.0, 2.0)), (double)((Long)max_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"max_2 of (2.0,-2.0):", (double)((long)Math.max(2.0, -2.0)), (double)((Long)max_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"max_2 of (-2.0,3.141592653589793):", (double)((long)Math.max(-2.0, Math.PI)), (double)((Long)max_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"max_2 of (3.141592653589793,1.5707963267948966):", (double)((long)Math.max(Math.PI, 1.5707963267948966)), (double)((Long)max_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"max_2 of (1.5707963267948966,1.0):", (double)((long)Math.max(1.5707963267948966, 1.0)), (double)((Long)max_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Long)max_2Function.evaluate(null)));
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)max_2Function.evaluate(null)));
            max_2Function = this.ff.function("max_2", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)max_2Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmax_3() {
        try {
            FilterFunction_max_3 max_3 = (FilterFunction_max_3)this.ff.function("max_3", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"max_3", (String)max_3.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)max_3.getFunctionName().getArgumentCount());
            Function max_3Function = this.ff.function("max_3", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"max_3 of (1.0,-1.0):", (double)((float)Math.max(1.0, -1.0)), (double)((Float)max_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"max_3 of (-1.0,2.0):", (double)((float)Math.max(-1.0, 2.0)), (double)((Float)max_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"max_3 of (2.0,-2.0):", (double)((float)Math.max(2.0, -2.0)), (double)((Float)max_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"max_3 of (-2.0,3.141592653589793):", (double)((float)Math.max(-2.0, Math.PI)), (double)((Float)max_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"max_3 of (3.141592653589793,1.5707963267948966):", (double)((float)Math.max(Math.PI, 1.5707963267948966)), (double)((Float)max_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"max_3 of (1.5707963267948966,1.0):", (double)((float)Math.max(1.5707963267948966, 1.0)), (double)((Float)max_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Float)max_3Function.evaluate(null)));
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Float)max_3Function.evaluate(null)));
            max_3Function = this.ff.function("max_3", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Float)max_3Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testmax() {
        try {
            FilterFunction_max max = (FilterFunction_max)this.ff.function("max", new Expression[2]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"max", (String)max.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)max.getFunctionName().getArgumentCount());
            Function maxFunction = this.ff.function("max", new Expression[]{this.literal_1, this.literal_m1});
            FilterFunction_Test.assertEquals((String)"max of (1.0,-1.0):", (double)Math.max(1.0, -1.0), (double)((Double)maxFunction.evaluate(null)), (double)1.0E-5);
            maxFunction = this.ff.function("max", new Expression[]{this.literal_m1, this.literal_2});
            FilterFunction_Test.assertEquals((String)"max of (-1.0,2.0):", (double)Math.max(-1.0, 2.0), (double)((Double)maxFunction.evaluate(null)), (double)1.0E-5);
            maxFunction = this.ff.function("max", new Expression[]{this.literal_2, this.literal_m2});
            FilterFunction_Test.assertEquals((String)"max of (2.0,-2.0):", (double)Math.max(2.0, -2.0), (double)((Double)maxFunction.evaluate(null)), (double)1.0E-5);
            maxFunction = this.ff.function("max", new Expression[]{this.literal_m2, this.literal_pi});
            FilterFunction_Test.assertEquals((String)"max of (-2.0,3.141592653589793):", (double)Math.max(-2.0, Math.PI), (double)((Double)maxFunction.evaluate(null)), (double)1.0E-5);
            maxFunction = this.ff.function("max", new Expression[]{this.literal_pi, this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"max of (3.141592653589793,1.5707963267948966):", (double)Math.max(Math.PI, 1.5707963267948966), (double)((Double)maxFunction.evaluate(null)), (double)1.0E-5);
            maxFunction = this.ff.function("max", new Expression[]{this.literal_05pi, this.literal_1});
            FilterFunction_Test.assertEquals((String)"max of (1.5707963267948966,1.0):", (double)Math.max(1.5707963267948966, 1.0), (double)((Double)maxFunction.evaluate(null)), (double)1.0E-5);
            maxFunction = this.ff.function("max", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Integer)maxFunction.evaluate(null)));
            maxFunction = this.ff.function("max", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Integer)maxFunction.evaluate(null)));
            maxFunction = this.ff.function("max", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Integer)maxFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testabs() {
        try {
            FilterFunction_abs abs = (FilterFunction_abs)this.ff.function("abs", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"abs", (String)abs.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)abs.getFunctionName().getArgumentCount());
            Function absFunction = this.ff.function("abs", new Expression[]{this.literal_1});
            FilterFunction_Test.assertEquals((String)"abs of (1.0):", (double)((int)Math.abs(1.0)), (double)((Integer)absFunction.evaluate(null)).intValue(), (double)1.0E-5);
            absFunction = this.ff.function("abs", new Expression[]{this.literal_m1});
            FilterFunction_Test.assertEquals((String)"abs of (-1.0):", (double)((int)Math.abs(-1.0)), (double)((Integer)absFunction.evaluate(null)).intValue(), (double)1.0E-5);
            absFunction = this.ff.function("abs", new Expression[]{this.literal_2});
            FilterFunction_Test.assertEquals((String)"abs of (2.0):", (double)((int)Math.abs(2.0)), (double)((Integer)absFunction.evaluate(null)).intValue(), (double)1.0E-5);
            absFunction = this.ff.function("abs", new Expression[]{this.literal_m2});
            FilterFunction_Test.assertEquals((String)"abs of (-2.0):", (double)((int)Math.abs(-2.0)), (double)((Integer)absFunction.evaluate(null)).intValue(), (double)1.0E-5);
            absFunction = this.ff.function("abs", new Expression[]{this.literal_pi});
            FilterFunction_Test.assertEquals((String)"abs of (3.141592653589793):", (double)((int)Math.abs(Math.PI)), (double)((Integer)absFunction.evaluate(null)).intValue(), (double)1.0E-5);
            absFunction = this.ff.function("abs", new Expression[]{this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"abs of (1.5707963267948966):", (double)((int)Math.abs(1.5707963267948966)), (double)((Integer)absFunction.evaluate(null)).intValue(), (double)1.0E-5);
            absFunction = this.ff.function("abs", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Integer)absFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testabs_4() {
        try {
            FilterFunction_abs_4 abs_4 = (FilterFunction_abs_4)this.ff.function("abs_4", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"abs_4", (String)abs_4.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)abs_4.getFunctionName().getArgumentCount());
            Function abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_1});
            FilterFunction_Test.assertEquals((String)"abs_4 of (1.0):", (double)Math.abs(1.0), (double)((Double)abs_4Function.evaluate(null)), (double)1.0E-5);
            abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_m1});
            FilterFunction_Test.assertEquals((String)"abs_4 of (-1.0):", (double)Math.abs(-1.0), (double)((Double)abs_4Function.evaluate(null)), (double)1.0E-5);
            abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_2});
            FilterFunction_Test.assertEquals((String)"abs_4 of (2.0):", (double)Math.abs(2.0), (double)((Double)abs_4Function.evaluate(null)), (double)1.0E-5);
            abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_m2});
            FilterFunction_Test.assertEquals((String)"abs_4 of (-2.0):", (double)Math.abs(-2.0), (double)((Double)abs_4Function.evaluate(null)), (double)1.0E-5);
            abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_pi});
            FilterFunction_Test.assertEquals((String)"abs_4 of (3.141592653589793):", (double)Math.abs(Math.PI), (double)((Double)abs_4Function.evaluate(null)), (double)1.0E-5);
            abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"abs_4 of (1.5707963267948966):", (double)Math.abs(1.5707963267948966), (double)((Double)abs_4Function.evaluate(null)), (double)1.0E-5);
            abs_4Function = this.ff.function("abs_4", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)abs_4Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testabs_3() {
        try {
            FilterFunction_abs_3 abs_3 = (FilterFunction_abs_3)this.ff.function("abs_3", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"abs_3", (String)abs_3.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)abs_3.getFunctionName().getArgumentCount());
            Function abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_1});
            FilterFunction_Test.assertEquals((String)"abs_3 of (1.0):", (double)((float)Math.abs(1.0)), (double)((Float)abs_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_m1});
            FilterFunction_Test.assertEquals((String)"abs_3 of (-1.0):", (double)((float)Math.abs(-1.0)), (double)((Float)abs_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_2});
            FilterFunction_Test.assertEquals((String)"abs_3 of (2.0):", (double)((float)Math.abs(2.0)), (double)((Float)abs_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_m2});
            FilterFunction_Test.assertEquals((String)"abs_3 of (-2.0):", (double)((float)Math.abs(-2.0)), (double)((Float)abs_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_pi});
            FilterFunction_Test.assertEquals((String)"abs_3 of (3.141592653589793):", (double)((float)Math.abs(Math.PI)), (double)((Float)abs_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"abs_3 of (1.5707963267948966):", (double)((float)Math.abs(1.5707963267948966)), (double)((Float)abs_3Function.evaluate(null)).floatValue(), (double)1.0E-5);
            abs_3Function = this.ff.function("abs_3", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Float)abs_3Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testabs_2() {
        try {
            FilterFunction_abs_2 abs_2 = (FilterFunction_abs_2)this.ff.function("abs_2", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"abs_2", (String)abs_2.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)abs_2.getFunctionName().getArgumentCount());
            Function abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_1});
            FilterFunction_Test.assertEquals((String)"abs_2 of (1.0):", (double)((long)Math.abs(1.0)), (double)((Long)abs_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_m1});
            FilterFunction_Test.assertEquals((String)"abs_2 of (-1.0):", (double)((long)Math.abs(-1.0)), (double)((Long)abs_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_2});
            FilterFunction_Test.assertEquals((String)"abs_2 of (2.0):", (double)((long)Math.abs(2.0)), (double)((Long)abs_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_m2});
            FilterFunction_Test.assertEquals((String)"abs_2 of (-2.0):", (double)((long)Math.abs(-2.0)), (double)((Long)abs_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_pi});
            FilterFunction_Test.assertEquals((String)"abs_2 of (3.141592653589793):", (double)((long)Math.abs(Math.PI)), (double)((Long)abs_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"abs_2 of (1.5707963267948966):", (double)((long)Math.abs(1.5707963267948966)), (double)((Long)abs_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            abs_2Function = this.ff.function("abs_2", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)abs_2Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testIEEEremainder() {
        try {
            FilterFunction_IEEEremainder IEEEremainder = (FilterFunction_IEEEremainder)this.ff.function("IEEEremainder", new Expression[]{Expression.NIL, Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"IEEEremainder", (String)IEEEremainder.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)2, (int)IEEEremainder.getFunctionName().getArgumentCount());
            Function IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_1, this.literal_m1});
            double good0 = Math.IEEEremainder(1.0, -1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"IEEEremainder of (1.0,-1.0):", (boolean)Double.isNaN((Double)IEEEremainderFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"IEEEremainder of (1.0,-1.0):", (double)Math.IEEEremainder(1.0, -1.0), (double)((Double)IEEEremainderFunction.evaluate(null)), (double)1.0E-5);
            }
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_m1, this.literal_2});
            double good1 = Math.IEEEremainder(-1.0, 2.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"IEEEremainder of (-1.0,2.0):", (boolean)Double.isNaN((Double)IEEEremainderFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"IEEEremainder of (-1.0,2.0):", (double)Math.IEEEremainder(-1.0, 2.0), (double)((Double)IEEEremainderFunction.evaluate(null)), (double)1.0E-5);
            }
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_2, this.literal_m2});
            double good2 = Math.IEEEremainder(2.0, -2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"IEEEremainder of (2.0,-2.0):", (boolean)Double.isNaN((Double)IEEEremainderFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"IEEEremainder of (2.0,-2.0):", (double)Math.IEEEremainder(2.0, -2.0), (double)((Double)IEEEremainderFunction.evaluate(null)), (double)1.0E-5);
            }
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_m2, this.literal_pi});
            double good3 = Math.IEEEremainder(-2.0, Math.PI);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"IEEEremainder of (-2.0,3.141592653589793):", (boolean)Double.isNaN((Double)IEEEremainderFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"IEEEremainder of (-2.0,3.141592653589793):", (double)Math.IEEEremainder(-2.0, Math.PI), (double)((Double)IEEEremainderFunction.evaluate(null)), (double)1.0E-5);
            }
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_pi, this.literal_05pi});
            double good4 = Math.IEEEremainder(Math.PI, 1.5707963267948966);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"IEEEremainder of (3.141592653589793,1.5707963267948966):", (boolean)Double.isNaN((Double)IEEEremainderFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"IEEEremainder of (3.141592653589793,1.5707963267948966):", (double)Math.IEEEremainder(Math.PI, 1.5707963267948966), (double)((Double)IEEEremainderFunction.evaluate(null)), (double)1.0E-5);
            }
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_05pi, this.literal_1});
            double good5 = Math.IEEEremainder(1.5707963267948966, 1.0);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"IEEEremainder of (1.5707963267948966,1.0):", (boolean)Double.isNaN((Double)IEEEremainderFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"IEEEremainder of (1.5707963267948966,1.0):", (double)Math.IEEEremainder(1.5707963267948966, 1.0), (double)((Double)IEEEremainderFunction.evaluate(null)), (double)1.0E-5);
            }
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_null, this.literal_1});
            FilterFunction_Test.assertNull((Object)((Double)IEEEremainderFunction.evaluate(null)));
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_1, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)IEEEremainderFunction.evaluate(null)));
            IEEEremainderFunction = this.ff.function("IEEEremainder", new Expression[]{this.literal_null, this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)IEEEremainderFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testacos() {
        try {
            FilterFunction_acos acos = (FilterFunction_acos)this.ff.function("acos", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"acos", (String)acos.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)acos.getFunctionName().getArgumentCount());
            Function acosFunction = this.ff.function("acos", new Expression[]{this.literal_1});
            double good0 = Math.acos(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"acos of (1.0):", (boolean)Double.isNaN((Double)acosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"acos of (1.0):", (double)Math.acos(1.0), (double)((Double)acosFunction.evaluate(null)), (double)1.0E-5);
            }
            acosFunction = this.ff.function("acos", new Expression[]{this.literal_m1});
            double good1 = Math.acos(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"acos of (-1.0):", (boolean)Double.isNaN((Double)acosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"acos of (-1.0):", (double)Math.acos(-1.0), (double)((Double)acosFunction.evaluate(null)), (double)1.0E-5);
            }
            acosFunction = this.ff.function("acos", new Expression[]{this.literal_2});
            double good2 = Math.acos(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"acos of (2.0):", (boolean)Double.isNaN((Double)acosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"acos of (2.0):", (double)Math.acos(2.0), (double)((Double)acosFunction.evaluate(null)), (double)1.0E-5);
            }
            acosFunction = this.ff.function("acos", new Expression[]{this.literal_m2});
            double good3 = Math.acos(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"acos of (-2.0):", (boolean)Double.isNaN((Double)acosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"acos of (-2.0):", (double)Math.acos(-2.0), (double)((Double)acosFunction.evaluate(null)), (double)1.0E-5);
            }
            acosFunction = this.ff.function("acos", new Expression[]{this.literal_pi});
            double good4 = Math.acos(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"acos of (3.141592653589793):", (boolean)Double.isNaN((Double)acosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"acos of (3.141592653589793):", (double)Math.acos(Math.PI), (double)((Double)acosFunction.evaluate(null)), (double)1.0E-5);
            }
            acosFunction = this.ff.function("acos", new Expression[]{this.literal_05pi});
            double good5 = Math.acos(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"acos of (1.5707963267948966):", (boolean)Double.isNaN((Double)acosFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"acos of (1.5707963267948966):", (double)Math.acos(1.5707963267948966), (double)((Double)acosFunction.evaluate(null)), (double)1.0E-5);
            }
            acosFunction = this.ff.function("acos", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)acosFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testasin() {
        try {
            FilterFunction_asin asin = (FilterFunction_asin)this.ff.function("asin", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"asin", (String)asin.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)asin.getFunctionName().getArgumentCount());
            Function asinFunction = this.ff.function("asin", new Expression[]{this.literal_1});
            double good0 = Math.asin(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"asin of (1.0):", (boolean)Double.isNaN((Double)asinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"asin of (1.0):", (double)Math.asin(1.0), (double)((Double)asinFunction.evaluate(null)), (double)1.0E-5);
            }
            asinFunction = this.ff.function("asin", new Expression[]{this.literal_m1});
            double good1 = Math.asin(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"asin of (-1.0):", (boolean)Double.isNaN((Double)asinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"asin of (-1.0):", (double)Math.asin(-1.0), (double)((Double)asinFunction.evaluate(null)), (double)1.0E-5);
            }
            asinFunction = this.ff.function("asin", new Expression[]{this.literal_2});
            double good2 = Math.asin(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"asin of (2.0):", (boolean)Double.isNaN((Double)asinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"asin of (2.0):", (double)Math.asin(2.0), (double)((Double)asinFunction.evaluate(null)), (double)1.0E-5);
            }
            asinFunction = this.ff.function("asin", new Expression[]{this.literal_m2});
            double good3 = Math.asin(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"asin of (-2.0):", (boolean)Double.isNaN((Double)asinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"asin of (-2.0):", (double)Math.asin(-2.0), (double)((Double)asinFunction.evaluate(null)), (double)1.0E-5);
            }
            asinFunction = this.ff.function("asin", new Expression[]{this.literal_pi});
            double good4 = Math.asin(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"asin of (3.141592653589793):", (boolean)Double.isNaN((Double)asinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"asin of (3.141592653589793):", (double)Math.asin(Math.PI), (double)((Double)asinFunction.evaluate(null)), (double)1.0E-5);
            }
            asinFunction = this.ff.function("asin", new Expression[]{this.literal_05pi});
            double good5 = Math.asin(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"asin of (1.5707963267948966):", (boolean)Double.isNaN((Double)asinFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"asin of (1.5707963267948966):", (double)Math.asin(1.5707963267948966), (double)((Double)asinFunction.evaluate(null)), (double)1.0E-5);
            }
            asinFunction = this.ff.function("asin", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)asinFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testatan() {
        try {
            FilterFunction_atan atan = (FilterFunction_atan)this.ff.function("atan", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"atan", (String)atan.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)atan.getFunctionName().getArgumentCount());
            Function atanFunction = this.ff.function("atan", new Expression[]{this.literal_1});
            double good0 = Math.atan(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"atan of (1.0):", (boolean)Double.isNaN((Double)atanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan of (1.0):", (double)Math.atan(1.0), (double)((Double)atanFunction.evaluate(null)), (double)1.0E-5);
            }
            atanFunction = this.ff.function("atan", new Expression[]{this.literal_m1});
            double good1 = Math.atan(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"atan of (-1.0):", (boolean)Double.isNaN((Double)atanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan of (-1.0):", (double)Math.atan(-1.0), (double)((Double)atanFunction.evaluate(null)), (double)1.0E-5);
            }
            atanFunction = this.ff.function("atan", new Expression[]{this.literal_2});
            double good2 = Math.atan(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"atan of (2.0):", (boolean)Double.isNaN((Double)atanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan of (2.0):", (double)Math.atan(2.0), (double)((Double)atanFunction.evaluate(null)), (double)1.0E-5);
            }
            atanFunction = this.ff.function("atan", new Expression[]{this.literal_m2});
            double good3 = Math.atan(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"atan of (-2.0):", (boolean)Double.isNaN((Double)atanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan of (-2.0):", (double)Math.atan(-2.0), (double)((Double)atanFunction.evaluate(null)), (double)1.0E-5);
            }
            atanFunction = this.ff.function("atan", new Expression[]{this.literal_pi});
            double good4 = Math.atan(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"atan of (3.141592653589793):", (boolean)Double.isNaN((Double)atanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan of (3.141592653589793):", (double)Math.atan(Math.PI), (double)((Double)atanFunction.evaluate(null)), (double)1.0E-5);
            }
            atanFunction = this.ff.function("atan", new Expression[]{this.literal_05pi});
            double good5 = Math.atan(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"atan of (1.5707963267948966):", (boolean)Double.isNaN((Double)atanFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"atan of (1.5707963267948966):", (double)Math.atan(1.5707963267948966), (double)((Double)atanFunction.evaluate(null)), (double)1.0E-5);
            }
            atanFunction = this.ff.function("atan", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)atanFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testceil() {
        try {
            FilterFunction_ceil ceil = (FilterFunction_ceil)this.ff.function("ceil", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"ceil", (String)ceil.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)ceil.getFunctionName().getArgumentCount());
            Function ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_1});
            double good0 = Math.ceil(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"ceil of (1.0):", (boolean)Double.isNaN((Double)ceilFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"ceil of (1.0):", (double)Math.ceil(1.0), (double)((Double)ceilFunction.evaluate(null)), (double)1.0E-5);
            }
            ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_m1});
            double good1 = Math.ceil(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"ceil of (-1.0):", (boolean)Double.isNaN((Double)ceilFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"ceil of (-1.0):", (double)Math.ceil(-1.0), (double)((Double)ceilFunction.evaluate(null)), (double)1.0E-5);
            }
            ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_2});
            double good2 = Math.ceil(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"ceil of (2.0):", (boolean)Double.isNaN((Double)ceilFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"ceil of (2.0):", (double)Math.ceil(2.0), (double)((Double)ceilFunction.evaluate(null)), (double)1.0E-5);
            }
            ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_m2});
            double good3 = Math.ceil(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"ceil of (-2.0):", (boolean)Double.isNaN((Double)ceilFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"ceil of (-2.0):", (double)Math.ceil(-2.0), (double)((Double)ceilFunction.evaluate(null)), (double)1.0E-5);
            }
            ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_pi});
            double good4 = Math.ceil(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"ceil of (3.141592653589793):", (boolean)Double.isNaN((Double)ceilFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"ceil of (3.141592653589793):", (double)Math.ceil(Math.PI), (double)((Double)ceilFunction.evaluate(null)), (double)1.0E-5);
            }
            ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_05pi});
            double good5 = Math.ceil(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"ceil of (1.5707963267948966):", (boolean)Double.isNaN((Double)ceilFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"ceil of (1.5707963267948966):", (double)Math.ceil(1.5707963267948966), (double)((Double)ceilFunction.evaluate(null)), (double)1.0E-5);
            }
            ceilFunction = this.ff.function("ceil", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)ceilFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testexp() {
        try {
            FilterFunction_exp exp = (FilterFunction_exp)this.ff.function("exp", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"exp", (String)exp.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)exp.getFunctionName().getArgumentCount());
            Function expFunction = this.ff.function("exp", new Expression[]{this.literal_1});
            double good0 = Math.exp(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"exp of (1.0):", (boolean)Double.isNaN((Double)expFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"exp of (1.0):", (double)Math.exp(1.0), (double)((Double)expFunction.evaluate(null)), (double)1.0E-5);
            }
            expFunction = this.ff.function("exp", new Expression[]{this.literal_m1});
            double good1 = Math.exp(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"exp of (-1.0):", (boolean)Double.isNaN((Double)expFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"exp of (-1.0):", (double)Math.exp(-1.0), (double)((Double)expFunction.evaluate(null)), (double)1.0E-5);
            }
            expFunction = this.ff.function("exp", new Expression[]{this.literal_2});
            double good2 = Math.exp(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"exp of (2.0):", (boolean)Double.isNaN((Double)expFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"exp of (2.0):", (double)Math.exp(2.0), (double)((Double)expFunction.evaluate(null)), (double)1.0E-5);
            }
            expFunction = this.ff.function("exp", new Expression[]{this.literal_m2});
            double good3 = Math.exp(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"exp of (-2.0):", (boolean)Double.isNaN((Double)expFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"exp of (-2.0):", (double)Math.exp(-2.0), (double)((Double)expFunction.evaluate(null)), (double)1.0E-5);
            }
            expFunction = this.ff.function("exp", new Expression[]{this.literal_pi});
            double good4 = Math.exp(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"exp of (3.141592653589793):", (boolean)Double.isNaN((Double)expFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"exp of (3.141592653589793):", (double)Math.exp(Math.PI), (double)((Double)expFunction.evaluate(null)), (double)1.0E-5);
            }
            expFunction = this.ff.function("exp", new Expression[]{this.literal_05pi});
            double good5 = Math.exp(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"exp of (1.5707963267948966):", (boolean)Double.isNaN((Double)expFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"exp of (1.5707963267948966):", (double)Math.exp(1.5707963267948966), (double)((Double)expFunction.evaluate(null)), (double)1.0E-5);
            }
            expFunction = this.ff.function("exp", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)expFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testfloor() {
        try {
            FilterFunction_floor floor = (FilterFunction_floor)this.ff.function("floor", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"floor", (String)floor.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)floor.getFunctionName().getArgumentCount());
            Function floorFunction = this.ff.function("floor", new Expression[]{this.literal_1});
            double good0 = Math.floor(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"floor of (1.0):", (boolean)Double.isNaN((Double)floorFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"floor of (1.0):", (double)Math.floor(1.0), (double)((Double)floorFunction.evaluate(null)), (double)1.0E-5);
            }
            floorFunction = this.ff.function("floor", new Expression[]{this.literal_m1});
            double good1 = Math.floor(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"floor of (-1.0):", (boolean)Double.isNaN((Double)floorFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"floor of (-1.0):", (double)Math.floor(-1.0), (double)((Double)floorFunction.evaluate(null)), (double)1.0E-5);
            }
            floorFunction = this.ff.function("floor", new Expression[]{this.literal_2});
            double good2 = Math.floor(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"floor of (2.0):", (boolean)Double.isNaN((Double)floorFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"floor of (2.0):", (double)Math.floor(2.0), (double)((Double)floorFunction.evaluate(null)), (double)1.0E-5);
            }
            floorFunction = this.ff.function("floor", new Expression[]{this.literal_m2});
            double good3 = Math.floor(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"floor of (-2.0):", (boolean)Double.isNaN((Double)floorFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"floor of (-2.0):", (double)Math.floor(-2.0), (double)((Double)floorFunction.evaluate(null)), (double)1.0E-5);
            }
            floorFunction = this.ff.function("floor", new Expression[]{this.literal_pi});
            double good4 = Math.floor(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"floor of (3.141592653589793):", (boolean)Double.isNaN((Double)floorFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"floor of (3.141592653589793):", (double)Math.floor(Math.PI), (double)((Double)floorFunction.evaluate(null)), (double)1.0E-5);
            }
            floorFunction = this.ff.function("floor", new Expression[]{this.literal_05pi});
            double good5 = Math.floor(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"floor of (1.5707963267948966):", (boolean)Double.isNaN((Double)floorFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"floor of (1.5707963267948966):", (double)Math.floor(1.5707963267948966), (double)((Double)floorFunction.evaluate(null)), (double)1.0E-5);
            }
            floorFunction = this.ff.function("floor", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)floorFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testlog() {
        try {
            FilterFunction_log log = (FilterFunction_log)this.ff.function("log", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"log", (String)log.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)log.getFunctionName().getArgumentCount());
            Function logFunction = this.ff.function("log", new Expression[]{this.literal_1});
            double good0 = Math.log(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"log of (1.0):", (boolean)Double.isNaN((Double)logFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"log of (1.0):", (double)Math.log(1.0), (double)((Double)logFunction.evaluate(null)), (double)1.0E-5);
            }
            logFunction = this.ff.function("log", new Expression[]{this.literal_m1});
            double good1 = Math.log(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"log of (-1.0):", (boolean)Double.isNaN((Double)logFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"log of (-1.0):", (double)Math.log(-1.0), (double)((Double)logFunction.evaluate(null)), (double)1.0E-5);
            }
            logFunction = this.ff.function("log", new Expression[]{this.literal_2});
            double good2 = Math.log(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"log of (2.0):", (boolean)Double.isNaN((Double)logFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"log of (2.0):", (double)Math.log(2.0), (double)((Double)logFunction.evaluate(null)), (double)1.0E-5);
            }
            logFunction = this.ff.function("log", new Expression[]{this.literal_m2});
            double good3 = Math.log(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"log of (-2.0):", (boolean)Double.isNaN((Double)logFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"log of (-2.0):", (double)Math.log(-2.0), (double)((Double)logFunction.evaluate(null)), (double)1.0E-5);
            }
            logFunction = this.ff.function("log", new Expression[]{this.literal_pi});
            double good4 = Math.log(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"log of (3.141592653589793):", (boolean)Double.isNaN((Double)logFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"log of (3.141592653589793):", (double)Math.log(Math.PI), (double)((Double)logFunction.evaluate(null)), (double)1.0E-5);
            }
            logFunction = this.ff.function("log", new Expression[]{this.literal_05pi});
            double good5 = Math.log(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"log of (1.5707963267948966):", (boolean)Double.isNaN((Double)logFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"log of (1.5707963267948966):", (double)Math.log(1.5707963267948966), (double)((Double)logFunction.evaluate(null)), (double)1.0E-5);
            }
            logFunction = this.ff.function("log", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)logFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testrandom() {
        try {
            FilterFunction_random randomFunction = (FilterFunction_random)this.ff.function("random", new Expression[0]);
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"random", (String)randomFunction.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)0, (int)randomFunction.getFunctionName().getArgumentCount());
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testrint() {
        try {
            FilterFunction_rint rint = (FilterFunction_rint)this.ff.function("rint", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"rint", (String)rint.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)rint.getFunctionName().getArgumentCount());
            Function rintFunction = this.ff.function("rint", new Expression[]{this.literal_1});
            double good0 = Math.rint(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"rint of (1.0):", (boolean)Double.isNaN((Double)rintFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"rint of (1.0):", (double)Math.rint(1.0), (double)((Double)rintFunction.evaluate(null)), (double)1.0E-5);
            }
            rintFunction = this.ff.function("rint", new Expression[]{this.literal_m1});
            double good1 = Math.rint(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"rint of (-1.0):", (boolean)Double.isNaN((Double)rintFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"rint of (-1.0):", (double)Math.rint(-1.0), (double)((Double)rintFunction.evaluate(null)), (double)1.0E-5);
            }
            rintFunction = this.ff.function("rint", new Expression[]{this.literal_2});
            double good2 = Math.rint(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"rint of (2.0):", (boolean)Double.isNaN((Double)rintFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"rint of (2.0):", (double)Math.rint(2.0), (double)((Double)rintFunction.evaluate(null)), (double)1.0E-5);
            }
            rintFunction = this.ff.function("rint", new Expression[]{this.literal_m2});
            double good3 = Math.rint(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"rint of (-2.0):", (boolean)Double.isNaN((Double)rintFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"rint of (-2.0):", (double)Math.rint(-2.0), (double)((Double)rintFunction.evaluate(null)), (double)1.0E-5);
            }
            rintFunction = this.ff.function("rint", new Expression[]{this.literal_pi});
            double good4 = Math.rint(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"rint of (3.141592653589793):", (boolean)Double.isNaN((Double)rintFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"rint of (3.141592653589793):", (double)Math.rint(Math.PI), (double)((Double)rintFunction.evaluate(null)), (double)1.0E-5);
            }
            rintFunction = this.ff.function("rint", new Expression[]{this.literal_05pi});
            double good5 = Math.rint(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"rint of (1.5707963267948966):", (boolean)Double.isNaN((Double)rintFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"rint of (1.5707963267948966):", (double)Math.rint(1.5707963267948966), (double)((Double)rintFunction.evaluate(null)), (double)1.0E-5);
            }
            rintFunction = this.ff.function("rint", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)rintFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testround() {
        try {
            FilterFunction_round round = (FilterFunction_round)this.ff.function("round", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"round", (String)round.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)round.getFunctionName().getArgumentCount());
            Function roundFunction = this.ff.function("round", new Expression[]{this.literal_1});
            FilterFunction_Test.assertEquals((String)"round of (1.0):", (double)((int)Math.round(1.0)), (double)((Integer)roundFunction.evaluate(null)).intValue(), (double)1.0E-5);
            roundFunction = this.ff.function("round", new Expression[]{this.literal_m1});
            FilterFunction_Test.assertEquals((String)"round of (-1.0):", (double)((int)Math.round(-1.0)), (double)((Integer)roundFunction.evaluate(null)).intValue(), (double)1.0E-5);
            roundFunction = this.ff.function("round", new Expression[]{this.literal_2});
            FilterFunction_Test.assertEquals((String)"round of (2.0):", (double)((int)Math.round(2.0)), (double)((Integer)roundFunction.evaluate(null)).intValue(), (double)1.0E-5);
            roundFunction = this.ff.function("round", new Expression[]{this.literal_m2});
            FilterFunction_Test.assertEquals((String)"round of (-2.0):", (double)((int)Math.round(-2.0)), (double)((Integer)roundFunction.evaluate(null)).intValue(), (double)1.0E-5);
            roundFunction = this.ff.function("round", new Expression[]{this.literal_pi});
            FilterFunction_Test.assertEquals((String)"round of (3.141592653589793):", (double)((int)Math.round(Math.PI)), (double)((Integer)roundFunction.evaluate(null)).intValue(), (double)1.0E-5);
            roundFunction = this.ff.function("round", new Expression[]{this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"round of (1.5707963267948966):", (double)((int)Math.round(1.5707963267948966)), (double)((Integer)roundFunction.evaluate(null)).intValue(), (double)1.0E-5);
            roundFunction = this.ff.function("round", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Integer)roundFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testround_2() {
        try {
            FilterFunction_round_2 round_2 = (FilterFunction_round_2)this.ff.function("round_2", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"round_2", (String)round_2.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)round_2.getFunctionName().getArgumentCount());
            Function round_2Function = this.ff.function("round_2", new Expression[]{this.literal_1});
            FilterFunction_Test.assertEquals((String)"round_2 of (1.0):", (double)Math.round(1.0), (double)((Long)round_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            round_2Function = this.ff.function("round_2", new Expression[]{this.literal_m1});
            FilterFunction_Test.assertEquals((String)"round_2 of (-1.0):", (double)Math.round(-1.0), (double)((Long)round_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            round_2Function = this.ff.function("round_2", new Expression[]{this.literal_2});
            FilterFunction_Test.assertEquals((String)"round_2 of (2.0):", (double)Math.round(2.0), (double)((Long)round_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            round_2Function = this.ff.function("round_2", new Expression[]{this.literal_m2});
            FilterFunction_Test.assertEquals((String)"round_2 of (-2.0):", (double)Math.round(-2.0), (double)((Long)round_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            round_2Function = this.ff.function("round_2", new Expression[]{this.literal_pi});
            FilterFunction_Test.assertEquals((String)"round_2 of (3.141592653589793):", (double)Math.round(Math.PI), (double)((Long)round_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            round_2Function = this.ff.function("round_2", new Expression[]{this.literal_05pi});
            FilterFunction_Test.assertEquals((String)"round_2 of (1.5707963267948966):", (double)Math.round(1.5707963267948966), (double)((Long)round_2Function.evaluate(null)).longValue(), (double)1.0E-5);
            round_2Function = this.ff.function("round_2", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Long)round_2Function.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testtoDegrees() {
        try {
            FilterFunction_toDegrees toDegrees = (FilterFunction_toDegrees)this.ff.function("toDegrees", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"toDegrees", (String)toDegrees.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)toDegrees.getFunctionName().getArgumentCount());
            Function toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_1});
            double good0 = Math.toDegrees(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"toDegrees of (1.0):", (boolean)Double.isNaN((Double)toDegreesFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toDegrees of (1.0):", (double)Math.toDegrees(1.0), (double)((Double)toDegreesFunction.evaluate(null)), (double)1.0E-5);
            }
            toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_m1});
            double good1 = Math.toDegrees(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"toDegrees of (-1.0):", (boolean)Double.isNaN((Double)toDegreesFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toDegrees of (-1.0):", (double)Math.toDegrees(-1.0), (double)((Double)toDegreesFunction.evaluate(null)), (double)1.0E-5);
            }
            toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_2});
            double good2 = Math.toDegrees(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"toDegrees of (2.0):", (boolean)Double.isNaN((Double)toDegreesFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toDegrees of (2.0):", (double)Math.toDegrees(2.0), (double)((Double)toDegreesFunction.evaluate(null)), (double)1.0E-5);
            }
            toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_m2});
            double good3 = Math.toDegrees(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"toDegrees of (-2.0):", (boolean)Double.isNaN((Double)toDegreesFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toDegrees of (-2.0):", (double)Math.toDegrees(-2.0), (double)((Double)toDegreesFunction.evaluate(null)), (double)1.0E-5);
            }
            toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_pi});
            double good4 = Math.toDegrees(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"toDegrees of (3.141592653589793):", (boolean)Double.isNaN((Double)toDegreesFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toDegrees of (3.141592653589793):", (double)Math.toDegrees(Math.PI), (double)((Double)toDegreesFunction.evaluate(null)), (double)1.0E-5);
            }
            toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_05pi});
            double good5 = Math.toDegrees(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"toDegrees of (1.5707963267948966):", (boolean)Double.isNaN((Double)toDegreesFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toDegrees of (1.5707963267948966):", (double)Math.toDegrees(1.5707963267948966), (double)((Double)toDegreesFunction.evaluate(null)), (double)1.0E-5);
            }
            toDegreesFunction = this.ff.function("toDegrees", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)toDegreesFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testtoRadians() {
        try {
            FilterFunction_toRadians toRadians = (FilterFunction_toRadians)this.ff.function("toRadians", new Expression[]{Expression.NIL});
            FilterFunction_Test.assertEquals((String)"Name is, ", (String)"toRadians", (String)toRadians.getName());
            FilterFunction_Test.assertEquals((String)"Number of arguments, ", (int)1, (int)toRadians.getFunctionName().getArgumentCount());
            Function toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_1});
            double good0 = Math.toRadians(1.0);
            if (Double.isNaN(good0)) {
                FilterFunction_Test.assertTrue((String)"toRadians of (1.0):", (boolean)Double.isNaN((Double)toRadiansFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toRadians of (1.0):", (double)Math.toRadians(1.0), (double)((Double)toRadiansFunction.evaluate(null)), (double)1.0E-5);
            }
            toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_m1});
            double good1 = Math.toRadians(-1.0);
            if (Double.isNaN(good1)) {
                FilterFunction_Test.assertTrue((String)"toRadians of (-1.0):", (boolean)Double.isNaN((Double)toRadiansFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toRadians of (-1.0):", (double)Math.toRadians(-1.0), (double)((Double)toRadiansFunction.evaluate(null)), (double)1.0E-5);
            }
            toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_2});
            double good2 = Math.toRadians(2.0);
            if (Double.isNaN(good2)) {
                FilterFunction_Test.assertTrue((String)"toRadians of (2.0):", (boolean)Double.isNaN((Double)toRadiansFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toRadians of (2.0):", (double)Math.toRadians(2.0), (double)((Double)toRadiansFunction.evaluate(null)), (double)1.0E-5);
            }
            toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_m2});
            double good3 = Math.toRadians(-2.0);
            if (Double.isNaN(good3)) {
                FilterFunction_Test.assertTrue((String)"toRadians of (-2.0):", (boolean)Double.isNaN((Double)toRadiansFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toRadians of (-2.0):", (double)Math.toRadians(-2.0), (double)((Double)toRadiansFunction.evaluate(null)), (double)1.0E-5);
            }
            toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_pi});
            double good4 = Math.toRadians(Math.PI);
            if (Double.isNaN(good4)) {
                FilterFunction_Test.assertTrue((String)"toRadians of (3.141592653589793):", (boolean)Double.isNaN((Double)toRadiansFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toRadians of (3.141592653589793):", (double)Math.toRadians(Math.PI), (double)((Double)toRadiansFunction.evaluate(null)), (double)1.0E-5);
            }
            toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_05pi});
            double good5 = Math.toRadians(1.5707963267948966);
            if (Double.isNaN(good5)) {
                FilterFunction_Test.assertTrue((String)"toRadians of (1.5707963267948966):", (boolean)Double.isNaN((Double)toRadiansFunction.evaluate(null)));
            } else {
                FilterFunction_Test.assertEquals((String)"toRadians of (1.5707963267948966):", (double)Math.toRadians(1.5707963267948966), (double)((Double)toRadiansFunction.evaluate(null)), (double)1.0E-5);
            }
            toRadiansFunction = this.ff.function("toRadians", new Expression[]{this.literal_null});
            FilterFunction_Test.assertNull((Object)((Double)toRadiansFunction.evaluate(null)));
        }
        catch (FactoryRegistryException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            FilterFunction_Test.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    public void testToLowerCase() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Function f = ff.function("strToLowerCase", new Expression[]{ff.literal((Object)"UPCASE")});
        FilterFunction_Test.assertEquals((Object)"upcase", (Object)f.evaluate(null));
    }

    public void testToUpperCase() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Function f = ff.function("strToUpperCase", new Expression[]{ff.literal((Object)"lowcase")});
        FilterFunction_Test.assertEquals((Object)"LOWCASE", (Object)f.evaluate(null));
    }
}

