/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.math.ModuloFunction;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class ModuloFunctionTest
extends TestCase {
    private FilterFactory ff;
    private String functionName;

    protected void setUp() throws Exception {
        super.setUp();
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.functionName = ModuloFunction.NAME.getName();
    }

    public void testModuloInvalidInitNoArgs() {
        try {
            this.ff.function(this.functionName, new Expression[0]);
        }
        catch (RuntimeException e) {
            ModuloFunctionTest.assertEquals((String)("Unable to find function " + this.functionName), (String)e.getMessage());
            return;
        }
        ModuloFunctionTest.fail((String)"Exception not thrown");
    }

    public void testModuloInvalidInitOneArg() {
        try {
            this.ff.function(this.functionName, new Expression[]{this.ff.literal(13)});
        }
        catch (RuntimeException e) {
            ModuloFunctionTest.assertEquals((String)("Unable to find function " + this.functionName), (String)e.getMessage());
            return;
        }
        ModuloFunctionTest.fail((String)"Exception not thrown");
    }

    public void testModuloInvalidInitThreeArgs() {
        try {
            this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(14), this.ff.literal(15)});
        }
        catch (RuntimeException e) {
            ModuloFunctionTest.assertEquals((String)("Unable to find function " + this.functionName), (String)e.getMessage());
            return;
        }
        ModuloFunctionTest.fail((String)"Exception not thrown");
    }

    public void testModulo() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(4)});
        ModuloFunctionTest.assertEquals((Object)1, (Object)function.evaluate(null));
    }

    public void testModuloNegativeDividend() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(-13), this.ff.literal(4)});
        ModuloFunctionTest.assertEquals((Object)3, (Object)function.evaluate(null));
    }

    public void testModuloNegativeDivisor() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(-4)});
        ModuloFunctionTest.assertEquals((Object)-3, (Object)function.evaluate(null));
    }

    public void testModuloFloat() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13.6), this.ff.literal(4)});
        ModuloFunctionTest.assertEquals((Object)1, (Object)function.evaluate(null));
    }

    public void testModuloOneDivisor() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(1)});
        ModuloFunctionTest.assertEquals((Object)0, (Object)function.evaluate(null));
    }

    public void testModuloZeroDivisor() {
        Function function = this.ff.function(this.functionName, new Expression[]{this.ff.literal(13), this.ff.literal(0)});
        try {
            function.evaluate(null);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        ModuloFunctionTest.fail((String)"IllegalArgumentException not thrown");
    }
}

