/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReprojectingFilterVisitorTest
extends TestCase {
    SimpleFeatureType ft;
    FilterFactory2 ff;
    ReprojectingFilterVisitor reprojector;

    protected void setUp() throws Exception {
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        GeoTools.fireConfigurationChanged();
        this.ft = DataUtilities.createType((String)"testType", (String)"geom:Point:srid=4326,line:LineString,name:String,id:int");
        this.ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        this.reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)this.ft);
    }

    public void testNoProjection() {
        Id idFilter = this.ff.id(Collections.singleton(this.ff.featureId("testType:1")));
        Filter clone = (Filter)idFilter.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)idFilter, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)idFilter, (Object)clone);
    }

    public void testBboxNoReprojection() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 10.0, 20.0, 20.0, "EPSG:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
    }

    public void testBboxReproject() throws FactoryException {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        ReprojectingFilterVisitorTest.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(15.0, 25.0, 10.0, 20.0, CRS.decode((String)"EPSG:4326", (boolean)false)), (BoundingBox)clonedBbox.getBounds(), (double)1.0E-6));
    }

    public void testBboxReprojectNoNativeAuthority() throws Exception {
        String wkt = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic longitude\", EAST], AXIS[\"Geodetic latitude\", NORTH]]";
        CoordinateReferenceSystem crs = CRS.parseWKT((String)wkt);
        SimpleFeatureType newFt = FeatureTypes.transform((SimpleFeatureType)this.ft, (CoordinateReferenceSystem)crs);
        this.reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)newFt);
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        ReprojectingFilterVisitorTest.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(15.0, 25.0, 10.0, 20.0, CRS.decode((String)"EPSG:4326", (boolean)false)), (BoundingBox)clonedBbox.getBounds(), (double)1.0E-6));
    }

    public void testBboxReprojectUnreferencedProperty() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("line"), 10.0, 15.0, 20.0, 25.0, "urn:x-ogc:def:crs:EPSG:6.11.2:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
    }

    public void testBboxReprojectUnreferencedBBox() {
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, null);
        Filter clone = (Filter)bbox.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox, (Object)clone);
    }

    public void testIntersectsReproject() throws Exception {
        PropertyName geom = this.ff.property("geom");
        this.testIntersectsReproject((Expression)geom);
    }

    public void testBoundedByReproject() throws Exception {
        Function geom = this.ff.function("boundedBy", new Expression[0]);
        this.testIntersectsReproject((Expression)geom);
    }

    public void testIntersectsReproject(Expression geom) throws FactoryException {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Intersects original = this.ff.intersects(geom, (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)((Literal)isClone.getExpression2()).getValue();
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testIntersectsUnreferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
    }

    public void testIntersectsReferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Intersects original = this.ff.intersects((Expression)this.ff.property("line"), (Expression)this.ff.literal((Object)ls));
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)isClone.getExpression2().evaluate(null);
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testPropertyEqualsFirstArgumentNotPropertyName() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Function function = this.ff.function("geometryType", new Expression[]{this.ff.property("geom")});
        PropertyIsEqualTo original = this.ff.equals((Expression)this.ff.literal((Object)"Point"), (Expression)function);
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
        original = this.ff.equals((Expression)function, (Expression)this.ff.literal((Object)"Point"));
        clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)original, (Object)clone);
    }

    public void testIntersectsWithFunction() throws Exception {
        GeometryFunction function = new GeometryFunction();
        Intersects original = this.ff.intersects((Expression)this.ff.property("geom"), (Expression)function);
        Filter clone = (Filter)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        Intersects isClone = (Intersects)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)isClone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)isClone.getExpression2().evaluate(null);
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testPropertyEqualWithFunction() throws Exception {
        GeometryFunction function = new GeometryFunction();
        PropertyIsEqualTo original = this.ff.equals((Expression)this.ff.property("geom"), (Expression)function);
        PropertyIsEqualTo clone = (PropertyIsEqualTo)original.accept((FilterVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)original, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)clone.getExpression1(), (Object)original.getExpression1());
        LineString clonedLs = (LineString)clone.getExpression2().evaluate(null);
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testIntersectsFilterFunctionUnreferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        Function intersects = this.ff.function("intersects", new Expression[]{this.ff.property("geom"), this.ff.literal((Object)ls)});
        Function clone = (Function)intersects.accept((ExpressionVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)intersects, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals(clone.getParameters().get(0), intersects.getParameters().get(0));
        ReprojectingFilterVisitorTest.assertEquals(clone.getParameters().get(1), intersects.getParameters().get(1));
    }

    public void testIntersectsFilterFunctionReferencedGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        LineString ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
        ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        Function intersects = this.ff.function("intersects", new Expression[]{this.ff.property("geom"), this.ff.literal((Object)ls)});
        Function clone = (Function)intersects.accept((ExpressionVisitor)this.reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)intersects, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals(clone.getParameters().get(0), intersects.getParameters().get(0));
        ReprojectingFilterVisitorTest.assertFalse((boolean)((Expression)clone.getParameters().get(1)).equals(intersects.getParameters().get(1)));
        LineString clonedLs = (LineString)((Literal)clone.getParameters().get(1)).getValue();
        ReprojectingFilterVisitorTest.assertTrue((15.0 == clonedLs.getCoordinateN((int)0).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((10.0 == clonedLs.getCoordinateN((int)0).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((25.0 == clonedLs.getCoordinateN((int)1).x ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertTrue((20.0 == clonedLs.getCoordinateN((int)1).y ? 1 : 0) != 0);
        ReprojectingFilterVisitorTest.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)clonedLs.getUserData());
    }

    public void testBboxReprojectWithTargetCrsProvided() throws FactoryException {
        CoordinateReferenceSystem webMercator = CRS.decode((String)"EPSG:3857");
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)this.ft, webMercator);
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("geom"), 10.0, 15.0, 20.0, 25.0, "EPSG:4326");
        Filter clone = (Filter)bbox.accept((FilterVisitor)reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        BBOX clonedBbox = (BBOX)clone;
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox.getExpression1(), (Object)clonedBbox.getExpression1());
        ReprojectingFilterVisitorTest.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(1113194.9079327357, 2226389.8158654715, 1689200.1396078924, 2875744.6243522423, webMercator), (BoundingBox)clonedBbox.getBounds(), (double)1.0E-6));
    }

    public void testTargetCrsProvidedButNoGeometryProperty() throws FactoryException {
        ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(this.ff, (FeatureType)this.ft, CRS.decode((String)"EPSG:3857"));
        BBOX bbox = this.ff.bbox((Expression)this.ff.property("name"), 10.0, 15.0, 20.0, 25.0, "EPSG:4326");
        BBOX clone = (BBOX)bbox.accept((FilterVisitor)reprojector, null);
        ReprojectingFilterVisitorTest.assertNotSame((Object)bbox, (Object)clone);
        ReprojectingFilterVisitorTest.assertEquals((Object)bbox.getExpression1(), (Object)clone.getExpression1());
        ReprojectingFilterVisitorTest.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(10.0, 20.0, 15.0, 25.0, CRS.decode((String)"EPSG:4326")), (BoundingBox)clone.getBounds(), (double)0.1));
    }

    private final class GeometryFunction
    implements Function {
        final LineString ls;

        public GeometryFunction() throws Exception {
            GeometryFactory gf = new GeometryFactory();
            this.ls = gf.createLineString(new Coordinate[]{new Coordinate(10.0, 15.0), new Coordinate(20.0, 25.0)});
            this.ls.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:4326"));
        }

        public String getName() {
            return "function";
        }

        public List<Expression> getParameters() {
            return Collections.EMPTY_LIST;
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return visitor.visit((Function)this, extraData);
        }

        public Object evaluate(Object object) {
            return this.ls;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            return (T)this.ls;
        }

        public Literal getFallbackValue() {
            return null;
        }

        public FunctionName getFunctionName() {
            return new FunctionNameImpl("geometryfunction", new String[0]);
        }
    }
}

