/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso;

import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MockPositionFactory
implements PositionFactory {
    private final CoordinateReferenceSystem crs;

    public MockPositionFactory() {
        this((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public MockPositionFactory(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public DirectPosition createDirectPosition() {
        return new MockDirectPosition();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Precision getPrecision() {
        throw new UnsupportedOperationException();
    }

    public DirectPosition createDirectPosition(double[] coordinates) {
        return new MockDirectPosition(coordinates);
    }

    public Position createPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    public PointArray createPointArray() {
        throw new UnsupportedOperationException();
    }

    public PointArray createPointArray(double[] coordinates, int start, int length) {
        throw new UnsupportedOperationException();
    }

    public PointArray createPointArray(float[] coordinates, int start, int length) {
        throw new UnsupportedOperationException();
    }

    class MockDirectPosition
    implements DirectPosition {
        double[] coordinates;

        MockDirectPosition() {
            this(new double[this$0.crs.getCoordinateSystem().getDimension()]);
        }

        public MockDirectPosition(double[] coordinates) {
            this.coordinates = coordinates;
        }

        public MockDirectPosition(DirectPosition position) {
            assert (position.getCoordinateReferenceSystem() == MockPositionFactory.this.crs);
            this.coordinates = position.getCoordinate();
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return MockPositionFactory.this.crs;
        }

        public double[] getCoordinate() {
            double[] copy = new double[MockPositionFactory.this.crs.getCoordinateSystem().getDimension()];
            System.arraycopy(this.coordinates, 0, copy, 0, this.getDimension());
            return copy;
        }

        public int getDimension() {
            return MockPositionFactory.this.crs.getCoordinateSystem().getDimension();
        }

        public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
            return this.coordinates[dimension];
        }

        public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
            this.coordinates[dimension] = value;
        }

        public DirectPosition getDirectPosition() {
            return this;
        }

        public MockDirectPosition clone() {
            return new MockDirectPosition(this);
        }
    }
}

