/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.text;

import junit.framework.TestCase;
import org.geotools.geometry.iso.MockGeometryFactory;
import org.geotools.geometry.iso.MockPositionFactory;
import org.geotools.geometry.iso.text.WKTParser;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveFactory;

public class WKTParserTest
extends TestCase {
    WKTParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        MockGeometryFactory mockFactory = new MockGeometryFactory();
        MockPositionFactory pf = new MockPositionFactory();
        this.parser = new WKTParser((GeometryFactory)mockFactory, (PrimitiveFactory)mockFactory, (PositionFactory)pf, null);
    }

    public void testPoint1() throws Exception {
        String WKT = "POINT (80 340)";
        Geometry geometry = this.parser.parse(WKT);
        WKTParserTest.assertNotNull((Object)geometry);
        WKTParserTest.assertTrue((boolean)(geometry instanceof Point));
        Point point = (Point)geometry;
        WKTParserTest.assertNotNull((Object)point.getDirectPosition());
        WKTParserTest.assertEquals((double)80.0, (double)point.getDirectPosition().getOrdinate(0), (double)0.0);
        WKTParserTest.assertEquals((double)340.0, (double)point.getDirectPosition().getOrdinate(1), (double)0.0);
    }

    public void testPoint2() throws Exception {
        String WKT = "POINT (320.324 180.234)";
        Geometry geometry = this.parser.parse(WKT);
        WKTParserTest.assertNotNull((Object)geometry);
        WKTParserTest.assertTrue((boolean)(geometry instanceof Point));
        Point point = (Point)geometry;
        WKTParserTest.assertEquals((double)320.324, (double)point.getDirectPosition().getOrdinate(0), (double)0.0);
        WKTParserTest.assertEquals((double)180.234, (double)point.getDirectPosition().getOrdinate(1), (double)0.0);
    }

    public void testPoint3() throws Exception {
        String WKT = "POINT (260.01 -360.55)";
        Geometry geometry = this.parser.parse(WKT);
        WKTParserTest.assertNotNull((Object)geometry);
        WKTParserTest.assertTrue((boolean)(geometry instanceof Point));
        Point point = (Point)geometry;
        WKTParserTest.assertEquals((double)260.01, (double)point.getDirectPosition().getOrdinate(0), (double)0.0);
        WKTParserTest.assertEquals((double)-360.55, (double)point.getDirectPosition().getOrdinate(1), (double)0.0);
    }

    public void testLine1() throws Exception {
        String WKT = "LINESTRING (60 380, 60 20, 200 400, 280 20, 360 400, 420 20, 500 400, 580 20, 620 400)";
        Geometry geometry = this.parser.parse(WKT);
        WKTParserTest.assertNotNull((Object)geometry);
        WKTParserTest.assertTrue((boolean)(geometry instanceof Curve));
        Curve linestring = (Curve)geometry;
    }

    public void testLine2() throws Exception {
        String WKT = "LINESTRING (80 360, 520 360, 520 40, 120 40, 120 300, 460 300, 460 100, 200 100, 200 240, 400 240, 400 140, 560 0)";
        Geometry geometry = this.parser.parse(WKT);
        WKTParserTest.assertNotNull((Object)geometry);
        WKTParserTest.assertTrue((boolean)(geometry instanceof Curve));
        Curve linestring = (Curve)geometry;
    }
}

