/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.Circle;
import org.geotools.geometry.jts.CircularArc;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class CircularArcTest {
    static final Coordinate ORIGIN = new Coordinate(0.0, 0.0);
    static final int COUNTER_CLOCKWISE = 1;
    static final int COLLINEAR = 0;
    static final int CLOCKWISE = -1;

    @BeforeClass
    public static void setupBaseSegmentsQuadrant() {
        CircularArc.setBaseSegmentsQuadrant((int)32);
    }

    @AfterClass
    public static void resetBaseSegmentsQuadrant() {
        CircularArc.setBaseSegmentsQuadrant((int)12);
    }

    Envelope envelopeFrom(CircularArc arc, double ... otherPoints) {
        Envelope env = new Envelope();
        env.expandToInclude(arc.controlPoints[0], arc.controlPoints[1]);
        env.expandToInclude(arc.controlPoints[2], arc.controlPoints[3]);
        env.expandToInclude(arc.controlPoints[4], arc.controlPoints[5]);
        if (otherPoints != null) {
            int i = 0;
            while (i < otherPoints.length) {
                env.expandToInclude(otherPoints[i++], otherPoints[i++]);
            }
        }
        return env;
    }

    static void assertCoordinateEquals(Coordinate expected, Coordinate actual) {
        if (expected == null) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertEquals((double)expected.x, (double)actual.x, (double)1.0E-6);
            Assert.assertEquals((double)expected.y, (double)actual.y, (double)1.0E-6);
        }
    }

    @Test
    public void testCollinear() {
        CircularArc arc = new CircularArc(0.0, 0.0, 0.0, 10.0, 0.0, 20.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)arc.getRadius(), (double)0.0);
        CircularArcTest.assertCoordinateEquals(null, arc.getCenter());
        double[] linearized = arc.linearize(0.0);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 20.0}, (double[])linearized, (double)0.0);
        Assert.assertEquals((Object)this.envelopeFrom(arc, new double[0]), (Object)arc.getEnvelope());
    }

    @Test
    public void testSamePoints() {
        CircularArc arc = new CircularArc(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)0.0, (double)arc.getRadius(), (double)0.0);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] linearized = arc.linearize(0.0);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, (double[])linearized, (double)0.0);
        Assert.assertEquals((Object)this.envelopeFrom(arc, new double[0]), (Object)arc.getEnvelope());
        Assert.assertEquals((double)0.0, (double)arc.getEnvelope().getArea(), (double)0.0);
    }

    @Test
    public void testMinuscule() {
        Circle circle = new Circle(100.0);
        CircularArc arc = circle.getCircularArc(0.0, 0.01227184630308513, 0.02454369260617026);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        Assert.assertArrayEquals((double[])arc.getControlPoints(), (double[])arc.linearize(10.0), (double)0.0);
        Assert.assertEquals((Object)this.envelopeFrom(arc, new double[0]), (Object)arc.getEnvelope());
    }

    @Test
    public void testMatchingSequence() {
        Circle circle = new Circle(100.0);
        CircularArc arc = circle.getCircularArc(0.0, 0.04908738521234052, 0.09817477042468103);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        Assert.assertArrayEquals((double[])arc.getControlPoints(), (double[])arc.linearize(10.0), (double)0.0);
    }

    @Test
    public void testOutsideSequence() {
        Circle circle = new Circle(100.0);
        double halfStep = 0.02454369260617026;
        CircularArc arc = circle.getCircularArc(halfStep, halfStep * 3.0, halfStep * 5.0);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] expected = circle.samplePoints(halfStep, halfStep * 2.0, halfStep * 3.0, halfStep * 4.0, halfStep * 5.0);
        Assert.assertArrayEquals((double[])expected, (double[])arc.linearize(0.1), (double)1.0E-6);
    }

    @Test
    public void testOutsideSequenceClockwise() {
        Circle circle = new Circle(100.0);
        double halfStep = 0.02454369260617026;
        CircularArc arc = circle.getCircularArc(halfStep * 5.0, halfStep * 3.0, halfStep);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] expected = circle.samplePoints(halfStep * 5.0, halfStep * 4.0, halfStep * 3.0, halfStep * 2.0, halfStep);
        Assert.assertArrayEquals((double[])expected, (double[])arc.linearize(0.1), (double)1.0E-6);
        Assert.assertEquals((Object)this.envelopeFrom(arc, new double[0]), (Object)arc.getEnvelope());
    }

    @Test
    public void testStartMatchSequence() {
        Circle circle = new Circle(100.0);
        double halfStep = 0.02454369260617026;
        CircularArc arc = circle.getCircularArc(0.0, halfStep * 3.0, halfStep * 5.0);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] expected = circle.samplePoints(0.0, halfStep * 2.0, halfStep * 3.0, halfStep * 4.0, halfStep * 5.0);
        Assert.assertArrayEquals((double[])expected, (double[])arc.linearize(0.2), (double)1.0E-6);
    }

    @Test
    public void testMidMatchSequence() {
        Circle circle = new Circle(100.0);
        double halfStep = 0.02454369260617026;
        CircularArc arc = circle.getCircularArc(halfStep, halfStep * 2.0, halfStep * 5.0);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] expected = circle.samplePoints(halfStep, halfStep * 2.0, halfStep * 4.0, halfStep * 5.0);
        Assert.assertArrayEquals((double[])expected, (double[])arc.linearize(0.2), (double)1.0E-6);
    }

    @Test
    public void testEndMatchSequence() {
        Circle circle = new Circle(100.0);
        double halfStep = 0.02454369260617026;
        CircularArc arc = circle.getCircularArc(halfStep, halfStep * 3.0, halfStep * 4.0);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] expected = circle.samplePoints(halfStep, halfStep * 3.0, halfStep * 4.0);
        Assert.assertArrayEquals((double[])expected, (double[])arc.linearize(10.0), (double)1.0E-6);
    }

    @Test
    public void testMatchTolerance() {
        Circle circle = new Circle(100.0);
        CircularArc arc = circle.getCircularArc(0.0, 1.5707963267948966, Math.PI);
        double tolerance = 1.0;
        for (int i = 0; i < 12; ++i) {
            double[] linearized = arc.linearize(tolerance);
            Assert.assertTrue((linearized.length >= 64 ? 1 : 0) != 0);
            circle.assertTolerance(linearized, tolerance);
            tolerance /= 4.0;
        }
    }

    @Test
    public void testMatchToleranceClockwise() {
        Circle circle = new Circle(100.0);
        CircularArc arc = circle.getCircularArc(Math.PI, 1.5707963267948966, 0.0);
        double tolerance = 1.0;
        for (int i = 0; i < 12; ++i) {
            double[] linearized = arc.linearize(tolerance);
            Assert.assertTrue((linearized.length >= 64 ? 1 : 0) != 0);
            circle.assertTolerance(linearized, tolerance);
            tolerance /= 4.0;
        }
    }

    @Test
    public void testCrossPIPI() {
        Circle circle = new Circle(100.0);
        double step = 0.04908738521234052;
        CircularArc arc = circle.getCircularArc(-step * 2.0, step, step * 2.0);
        Assert.assertEquals((double)100.0, (double)arc.getRadius(), (double)1.0E-9);
        CircularArcTest.assertCoordinateEquals(ORIGIN, arc.getCenter());
        double[] expected = circle.samplePoints(-step * 2.0, -step, 0.0, step, step * 2.0);
        Assert.assertArrayEquals((double[])expected, (double[])arc.linearize(0.2), (double)1.0E-6);
        Assert.assertEquals((Object)this.envelopeFrom(arc, 100.0, 0.0), (Object)arc.getEnvelope());
    }

    @Test
    public void testFullCircle() {
        Circle circle = new Circle(100.0);
        CircularArc arc = circle.getCircularArc(0.0, Math.PI, 0.0);
        Assert.assertEquals((Object)this.envelopeFrom(arc, 100.0, 0.0, 0.0, 100.0, -100.0, 0.0, 0.0, -100.0), (Object)arc.getEnvelope());
    }

    @Test
    public void testOrientations() {
        Circle circle = new Circle(100.0);
        Assert.assertEquals((long)1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, 0.0, 1.5707963267948966, Math.PI)));
        Assert.assertEquals((long)-1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, Math.PI, 1.5707963267948966, 0.0)));
        Assert.assertEquals((long)-1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, -Math.PI, 1.5707963267948966, 0.0)));
        Assert.assertEquals((long)1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, Math.PI, 4.71238898038469, 0.0)));
        Assert.assertEquals((long)-1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, 0.0, 4.71238898038469, Math.PI)));
        Assert.assertEquals((long)-1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, 0.0, -1.5707963267948966, -Math.PI)));
        Assert.assertEquals((long)1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, 1.5707963267948966, 0.7853981633974483, 1.1780972450961724)));
        Assert.assertEquals((long)-1L, (long)this.getOrientationIndex(this.getLinearizedArc(circle, 1.1780972450961724, 0.7853981633974483, 1.5707963267948966)));
    }

    private int getOrientationIndex(LineString ls) {
        return Orientation.index((Coordinate)ls.getCoordinateN(0), (Coordinate)ls.getCoordinateN(1), (Coordinate)ls.getCoordinateN(2));
    }

    private LineString getLinearizedArc(Circle c, double startAngle, double midAngle, double endAngle) {
        CircularArc arc = c.getCircularArc(startAngle, midAngle, endAngle);
        double[] linearized = arc.linearize(Double.MAX_VALUE);
        Coordinate[] coords = new Coordinate[linearized.length / 2];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = new Coordinate(linearized[i * 2], linearized[i * 2 + 1]);
        }
        CoordinateArraySequence cs = new CoordinateArraySequence(coords);
        return new LineString((CoordinateSequence)cs, new GeometryFactory());
    }
}

