/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Map;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.NormalizeContrastMethodStrategy;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.ContrastMethod;

public class ContrastEnhancementImplTest
extends TestCase {
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public void testGetSetGammaValue() {
        ContrastEnhancementImpl contrastEnhancementImpl = new ContrastEnhancementImpl();
        double expected = 1.5;
        contrastEnhancementImpl.setGammaValue((Expression)filterFactory.literal(expected));
        double actual = (Double)((Literal)contrastEnhancementImpl.getGammaValue()).getValue();
        ContrastEnhancementImplTest.assertEquals((double)expected, (double)actual, (double)0.1);
    }

    public void testGetSetMethod() {
        ContrastMethod expected = ContrastMethod.HISTOGRAM;
        ContrastEnhancementImpl contrastEnhancementImpl = new ContrastEnhancementImpl();
        contrastEnhancementImpl.setMethod(expected);
        ContrastMethod actual = contrastEnhancementImpl.getMethod();
        ContrastEnhancementImplTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testNormalize() {
        NormalizeContrastMethodStrategy normalize = new NormalizeContrastMethodStrategy();
        normalize.setAlgorithm((Expression)filterFactory.literal((Object)"ClipToMinimumMaximum"));
        Map params = normalize.getParameters();
        ContrastEnhancementImplTest.assertNotNull((String)"Null parameters returned by Normalize", (Object)params);
        normalize.addParameter("min", (Expression)filterFactory.literal(45.9));
        params = normalize.getParameters();
        ContrastEnhancementImplTest.assertEquals((String)"Wrong number of parameters returned", (int)1, (int)params.size());
        normalize.addParameter("max", (Expression)filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"arg1"), filterFactory.literal((Object)"arg2")}));
        params = normalize.getParameters();
        Expression max = (Expression)params.get("max");
        ContrastEnhancementImplTest.assertEquals((String)"mangled the function in normalize", (String)"env([arg1], [arg2])", (String)max.toString());
    }
}

