/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.LabelPlacement;
import org.opengis.util.Cloneable;

public class StyleObjectTest
extends TestCase {
    private StyleFactory styleFactory;
    private FilterFactory filterFactory;

    public StyleObjectTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        this.styleFactory = CommonFactoryFinder.getStyleFactory();
        this.filterFactory = CommonFactoryFinder.getFilterFactory(null);
    }

    protected void tearDown() throws Exception {
        this.styleFactory = null;
    }

    public void testStyle() throws Exception {
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type-1"));
        FeatureTypeStyle fts2 = this.fts2();
        Style style = this.styleFactory.getDefaultStyle();
        style.featureTypeStyles().add(fts);
        style.featureTypeStyles().add(fts2);
        Style clone = (Style)((Cloneable)style).clone();
        StyleObjectTest.assertClone(style, clone);
        Style notEq = this.styleFactory.getDefaultStyle();
        fts2 = this.fts2();
        notEq.featureTypeStyles().add(fts2);
        StyleObjectTest.assertEqualsContract(clone, notEq, style);
    }

    private FeatureTypeStyle fts2() {
        FeatureTypeStyle fts2 = this.styleFactory.createFeatureTypeStyle();
        Rule rule = this.styleFactory.createRule();
        fts2.rules().add(rule);
        fts2.featureTypeNames().add(new NameImpl("feature-type-2"));
        return fts2;
    }

    public void testFeatureTypeStyle() throws Exception {
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type"));
        Rule rule1 = this.styleFactory.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.filterFactory.id(Collections.singleton(this.filterFactory.featureId("FID"))));
        Rule rule2 = this.styleFactory.createRule();
        rule2.setElseFilter(true);
        rule2.setName("rule2");
        fts.rules().add(rule1);
        fts.rules().add(rule2);
        FeatureTypeStyle clone = (FeatureTypeStyle)((Cloneable)fts).clone();
        StyleObjectTest.assertClone(fts, clone);
        rule1 = this.styleFactory.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.filterFactory.id(Collections.singleton(this.filterFactory.featureId("FID"))));
        FeatureTypeStyle notEq = this.styleFactory.createFeatureTypeStyle();
        notEq.setName("fts-not-equal");
        notEq.rules().add(rule1);
        StyleObjectTest.assertEqualsContract(clone, notEq, fts);
    }

    public void testRule() throws Exception {
        LineSymbolizer symb1 = this.styleFactory.createLineSymbolizer(this.styleFactory.getDefaultStroke(), "geometry");
        PolygonSymbolizer symb2 = this.styleFactory.createPolygonSymbolizer(this.styleFactory.getDefaultStroke(), this.styleFactory.getDefaultFill(), "shape");
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().addAll(Arrays.asList(symb1, symb2));
        Rule clone = (Rule)((Cloneable)rule).clone();
        StyleObjectTest.assertClone(rule, clone);
        symb2 = this.styleFactory.createPolygonSymbolizer(this.styleFactory.getDefaultStroke(), this.styleFactory.getDefaultFill(), "shape");
        Rule notEq = this.styleFactory.createRule();
        notEq.symbolizers().add(symb2);
        StyleObjectTest.assertEqualsContract(clone, notEq, rule);
        symb1 = this.styleFactory.createLineSymbolizer(this.styleFactory.getDefaultStroke(), "geometry");
        clone.symbolizers().clear();
        clone.symbolizers().add(symb1);
        StyleObjectTest.assertTrue((!rule.equals(clone) ? 1 : 0) != 0);
    }

    public void testPointSymbolizer() throws Exception {
        PointSymbolizer pointSymb = this.styleFactory.createPointSymbolizer();
        PointSymbolizer clone = (PointSymbolizer)((Cloneable)pointSymb).clone();
        StyleObjectTest.assertClone(pointSymb, clone);
        PointSymbolizer notEq = this.styleFactory.getDefaultPointSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        StyleObjectTest.assertEqualsContract(clone, notEq, pointSymb);
    }

    public void testTextSymbolizer() {
        TextSymbolizer textSymb = this.styleFactory.createTextSymbolizer();
        Literal offset = this.filterFactory.literal(10);
        textSymb.setLabelPlacement((LabelPlacement)this.styleFactory.createLinePlacement((Expression)offset));
        TextSymbolizer clone = (TextSymbolizer)((Cloneable)textSymb).clone();
        StyleObjectTest.assertClone(textSymb, clone);
        TextSymbolizer notEq = this.styleFactory.getDefaultTextSymbolizer();
        Literal ancX = this.filterFactory.literal(10);
        Literal ancY = this.filterFactory.literal(10);
        AnchorPoint ancPoint = this.styleFactory.createAnchorPoint((Expression)ancX, (Expression)ancY);
        PointPlacement placement = this.styleFactory.createPointPlacement(ancPoint, null, null);
        notEq.setLabelPlacement((LabelPlacement)placement);
        StyleObjectTest.assertEqualsContract(clone, notEq, textSymb);
    }

    public void testFont() {
        Font font = this.styleFactory.getDefaultFont();
        Font clone = (Font)((Cloneable)font).clone();
        StyleObjectTest.assertClone(font, clone);
        Font other = this.styleFactory.createFont((Expression)this.filterFactory.literal((Object)"other"), (Expression)this.filterFactory.literal((Object)"normal"), (Expression)this.filterFactory.literal((Object)"BOLD"), (Expression)this.filterFactory.literal(12));
        StyleObjectTest.assertEqualsContract(clone, other, font);
    }

    public void testHalo() {
        Halo halo = this.styleFactory.createHalo(this.styleFactory.getDefaultFill(), (Expression)this.filterFactory.literal(10));
        Halo clone = (Halo)((Cloneable)halo).clone();
        StyleObjectTest.assertClone(halo, clone);
        Halo other = this.styleFactory.createHalo(this.styleFactory.getDefaultFill(), (Expression)this.filterFactory.literal(12));
        StyleObjectTest.assertEqualsContract(clone, other, halo);
    }

    public void testLinePlacement() throws Exception {
        LinePlacement linePlacement = this.styleFactory.createLinePlacement((Expression)this.filterFactory.literal(12));
        LinePlacement clone = (LinePlacement)((Cloneable)linePlacement).clone();
        StyleObjectTest.assertClone(linePlacement, clone);
        LinePlacement other = this.styleFactory.createLinePlacement((Expression)this.filterFactory.property("NAME"));
        StyleObjectTest.assertEqualsContract(clone, other, linePlacement);
    }

    public void testAnchorPoint() {
        AnchorPoint anchorPoint = this.styleFactory.createAnchorPoint((Expression)this.filterFactory.literal(1), (Expression)this.filterFactory.literal(2));
        AnchorPoint clone = (AnchorPoint)((Cloneable)anchorPoint).clone();
        StyleObjectTest.assertClone(anchorPoint, clone);
        AnchorPoint other = this.styleFactory.createAnchorPoint((Expression)this.filterFactory.literal(3), (Expression)this.filterFactory.literal(4));
        StyleObjectTest.assertEqualsContract(clone, other, anchorPoint);
    }

    public void testDisplacement() {
        Displacement displacement = this.styleFactory.createDisplacement((Expression)this.filterFactory.literal(1), (Expression)this.filterFactory.literal(2));
        Displacement clone = (Displacement)((Cloneable)displacement).clone();
        StyleObjectTest.assertClone(displacement, clone);
        Displacement other = this.styleFactory.createDisplacement((Expression)this.filterFactory.literal(3), (Expression)this.filterFactory.literal(4));
        StyleObjectTest.assertEqualsContract(clone, other, displacement);
    }

    public void testPointPlacement() {
        PointPlacement pointPl = this.styleFactory.getDefaultPointPlacement();
        PointPlacement clone = (PointPlacement)((Cloneable)pointPl).clone();
        StyleObjectTest.assertClone(pointPl, clone);
        PointPlacement other = (PointPlacement)((Cloneable)pointPl).clone();
        other.setRotation((Expression)this.filterFactory.literal(274.0));
        StyleObjectTest.assertEqualsContract(clone, other, pointPl);
    }

    public void testPolygonSymbolizer() {
        PolygonSymbolizer polygonSymb = this.styleFactory.createPolygonSymbolizer();
        PolygonSymbolizer clone = (PolygonSymbolizer)((Cloneable)polygonSymb).clone();
        StyleObjectTest.assertClone(polygonSymb, clone);
        PolygonSymbolizer notEq = this.styleFactory.getDefaultPolygonSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        StyleObjectTest.assertEqualsContract(clone, notEq, polygonSymb);
    }

    public void testLineSymbolizer() {
        LineSymbolizer lineSymb = this.styleFactory.createLineSymbolizer();
        LineSymbolizer clone = (LineSymbolizer)((Cloneable)lineSymb).clone();
        StyleObjectTest.assertClone(lineSymb, clone);
        LineSymbolizer notEq = this.styleFactory.getDefaultLineSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        StyleObjectTest.assertEqualsContract(clone, notEq, lineSymb);
    }

    public void testGraphic() {
        Graphic graphic = this.styleFactory.getDefaultGraphic();
        graphic.graphicalSymbols().add(this.styleFactory.getDefaultMark());
        Graphic clone = (Graphic)((Cloneable)graphic).clone();
        StyleObjectTest.assertClone(graphic, clone);
        StyleObjectTest.assertEqualsContract(clone, graphic);
        StyleObjectTest.assertEquals((int)clone.graphicalSymbols().size(), (int)graphic.graphicalSymbols().size());
        Graphic notEq = this.styleFactory.getDefaultGraphic();
        StyleObjectTest.assertEqualsContract(clone, notEq, graphic);
    }

    public void testExternalGraphic() {
        ExternalGraphic exGraphic = this.styleFactory.createExternalGraphic("http://somewhere", "image/png");
        ExternalGraphic clone = (ExternalGraphic)((Cloneable)exGraphic).clone();
        StyleObjectTest.assertClone(exGraphic, clone);
        ExternalGraphic notEq = this.styleFactory.createExternalGraphic("http://somewhereelse", "image/jpeg");
        StyleObjectTest.assertEqualsContract(clone, notEq, exGraphic);
        ExternalGraphic notEq2 = (ExternalGraphic)((Cloneable)clone).clone();
        notEq2.setFormat("image/jpeg");
        StyleObjectTest.assertEqualsContract(clone, notEq2, exGraphic);
    }

    public void testMark() {
        Mark mark = this.styleFactory.getCircleMark();
        Mark clone = (Mark)((Cloneable)mark).clone();
        StyleObjectTest.assertClone(mark, clone);
        Mark notEq = this.styleFactory.getStarMark();
        StyleObjectTest.assertEqualsContract(clone, notEq, mark);
    }

    public void testFill() {
        Fill fill = this.styleFactory.getDefaultFill();
        Fill clone = (Fill)((Cloneable)fill).clone();
        StyleObjectTest.assertClone(fill, clone);
        Fill notEq = this.styleFactory.createFill((Expression)this.filterFactory.literal((Object)"#FF0000"));
        StyleObjectTest.assertEqualsContract(clone, notEq, fill);
    }

    public void testStroke() {
        Stroke stroke = this.styleFactory.getDefaultStroke();
        DuplicatingStyleVisitor duplicate = new DuplicatingStyleVisitor(this.styleFactory);
        stroke.accept((StyleVisitor)duplicate);
        Stroke clone = (Stroke)duplicate.getCopy();
        StyleObjectTest.assertClone(stroke, clone);
        Stroke notEq = this.styleFactory.createStroke((Expression)this.filterFactory.literal((Object)"#FF0000"), (Expression)this.filterFactory.literal(10));
        StyleObjectTest.assertEqualsContract(clone, notEq, stroke);
        Stroke dashArray = this.styleFactory.getDefaultStroke();
        dashArray.setDashArray(new float[]{1.0f, 2.0f, 3.0f});
        dashArray.accept((StyleVisitor)duplicate);
        Stroke dashArray2 = (Stroke)duplicate.getCopy();
        StyleObjectTest.assertEqualsContract(dashArray, dashArray2);
    }

    private static void assertClone(Object real, Object clone) {
        StyleObjectTest.assertNotNull((String)"Real was null", (Object)real);
        StyleObjectTest.assertNotNull((String)"Clone was null", (Object)clone);
        StyleObjectTest.assertTrue((String)("" + real.getClass().getName() + " was not cloned"), (real != clone ? 1 : 0) != 0);
    }

    private static void assertEqualsContract(Object controlEqual, Object controlNe, Object test) {
        StyleObjectTest.assertNotNull((Object)controlEqual);
        StyleObjectTest.assertNotNull((Object)controlNe);
        StyleObjectTest.assertNotNull((Object)test);
        StyleObjectTest.assertTrue((String)"Reflexivity test failed", (boolean)test.equals(test));
        StyleObjectTest.assertTrue((String)"Symmetry test failed", (boolean)controlEqual.equals(test));
        StyleObjectTest.assertTrue((String)"Symmetry test failed", (boolean)test.equals(controlEqual));
        StyleObjectTest.assertTrue((String)"Symmetry test failed", (!test.equals(controlNe) ? 1 : 0) != 0);
        StyleObjectTest.assertTrue((String)"Symmetry test failed", (!controlNe.equals(test) ? 1 : 0) != 0);
        StyleObjectTest.assertTrue((String)"Transitivity test failed", (!controlEqual.equals(controlNe) ? 1 : 0) != 0);
        StyleObjectTest.assertTrue((String)"Transitivity test failed", (!test.equals(controlNe) ? 1 : 0) != 0);
        StyleObjectTest.assertTrue((String)"Transitivity test failed", (!controlNe.equals(controlEqual) ? 1 : 0) != 0);
        StyleObjectTest.assertTrue((String)"Transitivity test failed", (!controlNe.equals(test) ? 1 : 0) != 0);
        StyleObjectTest.assertTrue((String)"Non-null test failed", (!test.equals(null) ? 1 : 0) != 0);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        StyleObjectTest.assertTrue((String)"Equal objects should return equal hashcodes", (controlEqHash == testHash ? 1 : 0) != 0);
    }

    private static void assertEqualsContract(Object controlEqual, Object test) {
        StyleObjectTest.assertNotNull((Object)controlEqual);
        StyleObjectTest.assertNotNull((Object)test);
        StyleObjectTest.assertTrue((String)"Reflexivity test failed", (boolean)test.equals(test));
        StyleObjectTest.assertTrue((String)"Symmetry test failed", (boolean)controlEqual.equals(test));
        StyleObjectTest.assertTrue((String)"Symmetry test failed", (boolean)test.equals(controlEqual));
        StyleObjectTest.assertTrue((String)"Non-null test failed", (!test.equals(null) ? 1 : 0) != 0);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        StyleObjectTest.assertTrue((String)"Equal objects should return equal hashcodes", (controlEqHash == testHash ? 1 : 0) != 0);
    }

    public void testFeatureStyleImplCopy() throws Exception {
        FeatureTypeStyleImpl fts = new FeatureTypeStyleImpl();
        StyleObjectTest.assertNull((Object)fts.getTransformation());
        StyleObjectTest.assertNull((Object)fts.getOnlineResource());
        OnLineResourceImpl impl = new OnLineResourceImpl();
        Literal style = this.filterFactory.literal((Object)"square");
        fts.setTransformation((Expression)style);
        fts.setOnlineResource((OnLineResource)impl);
        StyleObjectTest.assertEquals((Object)fts.getTransformation(), (Object)this.filterFactory.literal((Object)"square"));
        StyleObjectTest.assertEquals((Object)fts.getOnlineResource(), (Object)new OnLineResourceImpl());
        FeatureTypeStyleImpl fts2 = new FeatureTypeStyleImpl((org.opengis.style.FeatureTypeStyle)fts);
        StyleObjectTest.assertEquals((Object)fts.getTransformation(), (Object)fts2.getTransformation());
        StyleObjectTest.assertEquals((Object)fts.getOnlineResource(), (Object)fts2.getOnlineResource());
    }
}

