/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultCalendarDate;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultCalendarDateTest {
    private CalendarDate calendarDate1;
    private CalendarDate calendarDate2;

    @Before
    public void setUp() {
        NamedIdentifier name = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        DefaultTemporalReferenceSystem frame = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name, null);
        int[] cal1 = new int[]{1981, 6, 25};
        int[] cal2 = new int[]{2000, 1, 1};
        SimpleInternationalString cal_era = new SimpleInternationalString("Cenozoic");
        this.calendarDate1 = new DefaultCalendarDate((TemporalReferenceSystem)frame, null, (InternationalString)cal_era, cal1);
        this.calendarDate2 = new DefaultCalendarDate((TemporalReferenceSystem)frame, null, (InternationalString)cal_era, cal2);
    }

    @After
    public void tearDown() {
        this.calendarDate1 = null;
        this.calendarDate2 = null;
    }

    @Test
    public void testGetCalendarEraName() {
        InternationalString result = this.calendarDate1.getCalendarEraName();
        Assert.assertTrue((boolean)this.calendarDate2.getCalendarEraName().equals(result));
    }

    @Test
    public void testGetCalendarDate() {
        int[] result = this.calendarDate1.getCalendarDate();
        Assert.assertThat((Object)this.calendarDate2.getCalendarDate(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testSetCalendarEraName() {
        InternationalString result = this.calendarDate1.getCalendarEraName();
        ((DefaultCalendarDate)this.calendarDate1).setCalendarEraName((InternationalString)new SimpleInternationalString("new Era"));
        Assert.assertFalse((boolean)this.calendarDate1.getCalendarEraName().equals(result));
    }

    @Test
    public void testSetCalendarDate() {
        int[] result = this.calendarDate1.getCalendarDate();
        int[] caldate = new int[]{1995, 5, 5};
        ((DefaultCalendarDate)this.calendarDate1).setCalendarDate(caldate);
        Assert.assertThat((Object)this.calendarDate1.getCalendarDate(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.calendarDate1.equals(null));
        Assert.assertEquals((Object)this.calendarDate1, (Object)this.calendarDate1);
    }

    @Test
    public void testHashCode() {
        int result = this.calendarDate1.hashCode();
        Assert.assertFalse((this.calendarDate2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.calendarDate1.toString();
        Assert.assertFalse((boolean)this.calendarDate2.toString().equals(result));
    }
}

