/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import javax.measure.Unit;
import org.geotools.temporal.object.DefaultIntervalLength;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.temporal.IntervalLength;
import si.uom.SI;

public class DefaultIntervalLengthTest {
    private IntervalLength intervalLength1;
    private IntervalLength intervalLength2;

    @Before
    public void setUp() {
        Unit unit1 = SI.SECOND;
        Unit unit2 = SI.SECOND.multiply(3600.0);
        int radix1 = 10;
        int radix2 = 10;
        int factor1 = 3;
        int factor2 = 6;
        int value1 = 7;
        int value2 = 12;
        this.intervalLength1 = new DefaultIntervalLength(unit1, radix1, factor1, value1);
        this.intervalLength2 = new DefaultIntervalLength(unit2, radix2, factor2, value2);
    }

    @After
    public void tearDown() {
        this.intervalLength1 = null;
        this.intervalLength2 = null;
    }

    @Test
    public void testGetUnit() {
        Unit result = this.intervalLength1.getUnit();
        Assert.assertFalse((boolean)this.intervalLength2.getUnit().equals(result));
    }

    @Test
    public void testGetRadix() {
        int result = this.intervalLength1.getRadix();
        Assert.assertTrue((this.intervalLength2.getRadix() == result ? 1 : 0) != 0);
    }

    @Test
    public void testGetFactor() {
        int result = this.intervalLength1.getFactor();
        Assert.assertFalse((this.intervalLength2.getFactor() == result ? 1 : 0) != 0);
    }

    @Test
    public void testGetValue() {
        int result = this.intervalLength1.getValue();
        Assert.assertFalse((this.intervalLength2.getValue() == result ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.intervalLength1.equals(null));
        Assert.assertEquals((Object)this.intervalLength1, (Object)this.intervalLength1);
        Assert.assertFalse((boolean)this.intervalLength1.equals(this.intervalLength2));
    }

    @Test
    public void testHashCode() {
        int result = this.intervalLength1.hashCode();
        Assert.assertFalse((this.intervalLength2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.intervalLength1.toString();
        Assert.assertFalse((boolean)this.intervalLength2.toString().equals(result));
    }
}

