/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.GregorianCalendar;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultTemporalCoordinate;
import org.geotools.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalCoordinateTest {
    private TemporalCoordinate temporalCoordinate1;
    private TemporalCoordinate temporalCoordinate2;

    @Before
    public void setUp() {
        NamedIdentifier name = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        GregorianCalendar gc = new GregorianCalendar(-4713, 1, 1);
        Integer coordinateValue = 100;
        DefaultTemporalCoordinateSystem frame1 = new DefaultTemporalCoordinateSystem((ReferenceIdentifier)new NamedIdentifier(Citations.CRS, (InternationalString)new SimpleInternationalString("Julian calendar")), null, gc.getTime(), (InternationalString)new SimpleInternationalString("day"));
        DefaultTemporalCoordinateSystem frame2 = new DefaultTemporalCoordinateSystem((ReferenceIdentifier)new NamedIdentifier(Citations.CRS, (InternationalString)new SimpleInternationalString("Julian calendar")), null, gc.getTime(), (InternationalString)new SimpleInternationalString("hour"));
        this.temporalCoordinate1 = new DefaultTemporalCoordinate((TemporalReferenceSystem)frame1, IndeterminateValue.NOW, (Number)coordinateValue);
        this.temporalCoordinate2 = new DefaultTemporalCoordinate((TemporalReferenceSystem)frame2, IndeterminateValue.AFTER, (Number)coordinateValue);
    }

    @After
    public void tearDown() {
        this.temporalCoordinate1 = null;
        this.temporalCoordinate2 = null;
    }

    @Test
    public void testGetCoordinateValue() {
        Number result = this.temporalCoordinate1.getCoordinateValue();
        Assert.assertTrue((this.temporalCoordinate2.getCoordinateValue() == result ? 1 : 0) != 0);
    }

    @Test
    public void testSetCoordinateValue() {
        Number result = this.temporalCoordinate1.getCoordinateValue();
        ((DefaultTemporalCoordinate)this.temporalCoordinate1).setCoordinateValue((Number)250);
        Assert.assertFalse((this.temporalCoordinate1.getCoordinateValue() == result ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.temporalCoordinate1.equals(null));
        Assert.assertEquals((Object)this.temporalCoordinate1, (Object)this.temporalCoordinate1);
        Assert.assertFalse((boolean)this.temporalCoordinate1.equals(this.temporalCoordinate2));
    }

    @Test
    public void testHashCode() {
        int result = this.temporalCoordinate1.hashCode();
        Assert.assertFalse((this.temporalCoordinate2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.temporalCoordinate1.toString();
        Assert.assertFalse((boolean)this.temporalCoordinate2.toString().equals(result));
    }
}

