/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Calendar;
import java.util.Date;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.temporal.object.DefaultTemporalPrimitive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.temporal.Duration;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.opengis.temporal.TemporalPrimitive;

public class DefaultTemporalGeometricPrimitiveTest {
    private TemporalGeometricPrimitive temporalGeomericPrimitive1;
    private TemporalGeometricPrimitive temporalGeomericPrimitive2;
    private Position position1;
    private Position position2;
    private Calendar cal = Calendar.getInstance();

    @Before
    public void setUp() {
        this.cal.set(1981, 6, 25);
        Date date = this.cal.getTime();
        Calendar c2 = Calendar.getInstance();
        c2.set(2018, 4, 21);
        this.position1 = new DefaultPosition(date);
        this.position2 = new DefaultPosition(c2.getTime());
        this.temporalGeomericPrimitive1 = new DefaultInstant(this.position1);
        this.temporalGeomericPrimitive2 = new DefaultInstant(this.position2);
    }

    @After
    public void tearDown() {
        this.position1 = null;
        this.position2 = null;
        this.temporalGeomericPrimitive1 = null;
        this.temporalGeomericPrimitive2 = null;
    }

    @Test
    public void testDistance() {
        this.cal.set(2000, 0, 1);
        DefaultPosition position = new DefaultPosition(this.cal.getTime());
        DefaultInstant other = new DefaultInstant((Position)position);
        Duration result = this.temporalGeomericPrimitive1.distance((TemporalGeometricPrimitive)other);
        Assert.assertFalse((boolean)this.temporalGeomericPrimitive2.distance((TemporalGeometricPrimitive)other).equals(result));
        this.cal.set(2009, 1, 1);
        DefaultInstant i1 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        this.cal.set(2012, 1, 1);
        DefaultInstant i2 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        other = new DefaultPeriod((Instant)i1, (Instant)i2);
        result = this.temporalGeomericPrimitive1.distance((TemporalGeometricPrimitive)other);
        Assert.assertFalse((boolean)this.temporalGeomericPrimitive2.distance((TemporalGeometricPrimitive)other).equals(result));
        this.temporalGeomericPrimitive1 = new DefaultPeriod((Instant)new DefaultInstant(this.position1), (Instant)new DefaultInstant(this.position2));
        this.temporalGeomericPrimitive2 = new DefaultPeriod((Instant)i1, (Instant)new DefaultInstant(this.position2));
        result = this.temporalGeomericPrimitive1.distance((TemporalGeometricPrimitive)other);
        Assert.assertTrue((boolean)this.temporalGeomericPrimitive2.distance((TemporalGeometricPrimitive)other).equals(result));
    }

    @Test
    public void testLength() {
        this.cal.set(2020, 0, 1);
        this.temporalGeomericPrimitive1 = new DefaultPeriod((Instant)new DefaultInstant(this.position1), (Instant)new DefaultInstant(this.position2));
        this.temporalGeomericPrimitive2 = new DefaultPeriod((Instant)new DefaultInstant(this.position2), (Instant)new DefaultInstant((Position)new DefaultPosition(this.cal.getTime())));
        Duration result = this.temporalGeomericPrimitive1.length();
        Assert.assertFalse((boolean)this.temporalGeomericPrimitive2.length().equals(result));
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((long)-1L, (long)((DefaultTemporalPrimitive)this.temporalGeomericPrimitive1).compareTo((TemporalPrimitive)this.temporalGeomericPrimitive2));
        Assert.assertEquals((long)0L, (long)((DefaultTemporalPrimitive)this.temporalGeomericPrimitive1).compareTo((TemporalPrimitive)this.temporalGeomericPrimitive1));
        Assert.assertEquals((long)0L, (long)((DefaultTemporalPrimitive)this.temporalGeomericPrimitive2).compareTo((TemporalPrimitive)this.temporalGeomericPrimitive2));
    }
}

