/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.geotools.temporal.reference.DefaultOrdinalEra;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.temporal.OrdinalEra;
import org.opengis.util.InternationalString;

public class DefaultOrdinalEraTest {
    private OrdinalEra ordinalEra1;
    private OrdinalEra ordinalEra2;
    private Calendar cal = Calendar.getInstance();

    @Before
    public void setUp() {
        this.cal.set(1900, 1, 1);
        Date beginning1 = this.cal.getTime();
        this.cal.set(2000, 1, 1);
        Date end1 = this.cal.getTime();
        this.cal.set(2000, 1, 1);
        Date beginning2 = this.cal.getTime();
        this.cal.set(2012, 1, 1);
        Date end2 = this.cal.getTime();
        this.ordinalEra1 = new DefaultOrdinalEra((InternationalString)new SimpleInternationalString("old Era"), beginning1, end1);
        this.ordinalEra2 = new DefaultOrdinalEra((InternationalString)new SimpleInternationalString("new Era"), beginning2, end2);
    }

    @After
    public void tearDown() {
        this.ordinalEra1 = null;
        this.ordinalEra2 = null;
    }

    @Test
    public void testGetName() {
        InternationalString result = this.ordinalEra1.getName();
        Assert.assertFalse((boolean)this.ordinalEra2.getName().equals(result));
    }

    @Test
    public void testGetBeginning() {
        Date result = this.ordinalEra1.getBeginning();
        Assert.assertFalse((boolean)this.ordinalEra2.getBeginning().equals(result));
    }

    @Test
    public void testGetEnd() {
        Date result = this.ordinalEra1.getEnd();
        Assert.assertFalse((boolean)this.ordinalEra2.getEnd().equals(result));
    }

    @Test
    public void testGetComposition() {
        Collection result = this.ordinalEra1.getComposition();
        Assert.assertEquals((Object)this.ordinalEra2.getComposition(), (Object)result);
    }

    @Test
    public void testSetName() {
        InternationalString result = this.ordinalEra1.getName();
        ((DefaultOrdinalEra)this.ordinalEra1).setName((InternationalString)new SimpleInternationalString(""));
        Assert.assertFalse((boolean)this.ordinalEra1.getName().equals(result));
    }

    @Test
    public void testSetBeginning() {
        Date result = this.ordinalEra1.getBeginning();
        ((DefaultOrdinalEra)this.ordinalEra1).setBeginning(new Date());
        Assert.assertFalse((boolean)this.ordinalEra1.getBeginning().equals(result));
    }

    @Test
    public void testSetEnd() {
        Date result = this.ordinalEra1.getEnd();
        ((DefaultOrdinalEra)this.ordinalEra1).setEnd(new Date());
        Assert.assertFalse((boolean)this.ordinalEra1.getEnd().equals(result));
    }

    @Test
    public void testGetGroup() {
        DefaultOrdinalEra result = ((DefaultOrdinalEra)this.ordinalEra1).getGroup();
        Assert.assertEquals((Object)((DefaultOrdinalEra)this.ordinalEra2).getGroup(), (Object)result);
    }

    @Test
    public void testSetGroup() {
        DefaultOrdinalEra result = ((DefaultOrdinalEra)this.ordinalEra1).getGroup();
        this.cal.set(1900, 0, 0);
        ((DefaultOrdinalEra)this.ordinalEra1).setGroup(new DefaultOrdinalEra((InternationalString)new SimpleInternationalString(""), this.cal.getTime(), new Date()));
        Assert.assertFalse((boolean)((DefaultOrdinalEra)this.ordinalEra1).getGroup().equals((Object)result));
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.ordinalEra1.equals(null));
        Assert.assertEquals((Object)this.ordinalEra1, (Object)this.ordinalEra1);
        Assert.assertFalse((boolean)this.ordinalEra1.equals(this.ordinalEra2));
    }

    @Test
    public void testHashCode() {
        int result = this.ordinalEra1.hashCode();
        Assert.assertFalse((this.ordinalEra2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.ordinalEra1.toString();
        Assert.assertFalse((boolean)this.ordinalEra2.toString().equals(result));
    }
}

