/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.TemporalExtentImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultTemporalReferenceSystemTest {
    private TemporalReferenceSystem temporalReferenceSystem1;
    private TemporalReferenceSystem temporalReferenceSystem2;

    @Before
    public void setUp() {
        NamedIdentifier name1 = new NamedIdentifier(Citations.CRS, "ref system1");
        NamedIdentifier name2 = new NamedIdentifier(Citations.CRS, "ref system2");
        this.temporalReferenceSystem1 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name1, null);
        this.temporalReferenceSystem2 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name2, null);
    }

    @After
    public void tearDown() {
        this.temporalReferenceSystem1 = null;
        this.temporalReferenceSystem2 = null;
    }

    @Test
    public void testGetName() {
        ReferenceIdentifier result = this.temporalReferenceSystem1.getName();
        Assert.assertFalse((boolean)this.temporalReferenceSystem2.getName().equals(result));
    }

    @Test
    public void testGetDomainOfValidity() {
        Extent result = this.temporalReferenceSystem1.getDomainOfValidity();
        Assert.assertEquals((Object)this.temporalReferenceSystem2.getDomainOfValidity(), (Object)result);
    }

    @Test
    public void testGetScope() {
        InternationalString result = this.temporalReferenceSystem1.getScope();
        Assert.assertEquals((Object)this.temporalReferenceSystem2.getScope(), (Object)result);
    }

    @Test
    public void testGetAlias() {
        Collection result = this.temporalReferenceSystem1.getAlias();
        Assert.assertEquals((Object)this.temporalReferenceSystem2.getAlias(), (Object)result);
    }

    @Test
    public void testGetIdentifiers() {
        Set result = this.temporalReferenceSystem1.getIdentifiers();
        Assert.assertEquals((Object)this.temporalReferenceSystem2.getIdentifiers(), (Object)result);
    }

    @Test
    public void testGetRemarks() {
        InternationalString result = this.temporalReferenceSystem1.getRemarks();
        Assert.assertEquals((Object)this.temporalReferenceSystem2.getRemarks(), (Object)result);
    }

    @Test
    public void testToWKT() {
    }

    @Test
    public void testSetName() {
        ReferenceIdentifier result = this.temporalReferenceSystem1.getName();
        ((DefaultTemporalReferenceSystem)this.temporalReferenceSystem1).setName((ReferenceIdentifier)new NamedIdentifier(Citations.CRS, "new name"));
        Assert.assertFalse((boolean)this.temporalReferenceSystem1.getName().equals(result));
    }

    @Test
    public void testSetDomainOfValidity() {
        Extent result = this.temporalReferenceSystem1.getDomainOfValidity();
        ExtentImpl domainOfValidity = new ExtentImpl();
        domainOfValidity.setDescription((InternationalString)new SimpleInternationalString("Western Europe"));
        Calendar cal = Calendar.getInstance();
        cal.set(0, 0, 0);
        TemporalExtentImpl temporalExt = new TemporalExtentImpl(cal.getTime(), new Date());
        ArrayList<TemporalExtentImpl> collection = new ArrayList<TemporalExtentImpl>();
        collection.add(temporalExt);
        domainOfValidity.setTemporalElements(collection);
        ((DefaultTemporalReferenceSystem)this.temporalReferenceSystem1).setDomainOfValidity((Extent)domainOfValidity);
        Assert.assertFalse((boolean)this.temporalReferenceSystem1.getDomainOfValidity().equals(result));
    }

    @Test
    public void testSetValidArea() {
    }

    @Test
    public void testSetScope() {
        InternationalString result = ((DefaultTemporalReferenceSystem)this.temporalReferenceSystem1).getScope();
        Assert.assertEquals((Object)((DefaultTemporalReferenceSystem)this.temporalReferenceSystem1).getScope(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.temporalReferenceSystem1.equals(null));
        Assert.assertEquals((Object)this.temporalReferenceSystem1, (Object)this.temporalReferenceSystem1);
        Assert.assertFalse((boolean)this.temporalReferenceSystem1.equals(this.temporalReferenceSystem2));
    }

    @Test
    public void testHashCode() {
        int result = this.temporalReferenceSystem1.hashCode();
        Assert.assertFalse((this.temporalReferenceSystem2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.temporalReferenceSystem1.toString();
        Assert.assertFalse((boolean)this.temporalReferenceSystem2.toString().equals(result));
    }
}

