/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.net.URL;
import java.util.List;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.data.MapInfoFileReader;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.junit.Assert;
import org.junit.Test;

public class MapInfoFileReaderTest {
    @Test
    public void testReaderFile() throws Exception {
        URL tabFile = this.getClass().getResource("test-data/london.tab");
        MapInfoFileReader reader = new MapInfoFileReader(tabFile);
        List controlPoints = reader.getControlPoints();
        Assert.assertEquals((long)3L, (long)controlPoints.size());
        Assert.assertEquals((double)0.0, (double)((MappedPosition)controlPoints.get(0)).getSource().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((MappedPosition)controlPoints.get(0)).getSource().getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((MappedPosition)controlPoints.get(1)).getSource().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((MappedPosition)controlPoints.get(1)).getSource().getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((MappedPosition)controlPoints.get(2)).getSource().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((MappedPosition)controlPoints.get(2)).getSource().getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)297055.0, (double)((MappedPosition)controlPoints.get(0)).getTarget().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)5717803.0, (double)((MappedPosition)controlPoints.get(0)).getTarget().getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)297065.0, (double)((MappedPosition)controlPoints.get(1)).getTarget().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)5717803.0, (double)((MappedPosition)controlPoints.get(1)).getTarget().getOrdinate(1), (double)0.0);
        Assert.assertEquals((double)297055.0, (double)((MappedPosition)controlPoints.get(2)).getTarget().getOrdinate(0), (double)0.0);
        Assert.assertEquals((double)5717793.0, (double)((MappedPosition)controlPoints.get(2)).getTarget().getOrdinate(1), (double)0.0);
        MathTransform transform = reader.getTransform();
        Assert.assertNotNull((Object)transform);
        CoordinateReferenceSystem crs = reader.getCRS();
        Assert.assertTrue((boolean)(crs instanceof DefaultProjectedCRS));
        DefaultProjectedCRS geocrs = (DefaultProjectedCRS)crs;
        Assert.assertEquals((Object)"WGS_1984", (Object)geocrs.getDatum().getName().toString());
        Assert.assertEquals((Object)"Transverse_Mercator", (Object)geocrs.getConversionFromBase().getMethod().getName().toString());
    }
}

