/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.TreeSetFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureComparators;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public abstract class FeatureCollectionTest {
    SimpleFeatureCollection features;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("Dummy");
        SimpleFeatureType schema = tb.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(schema);
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        for (int i = 0; i < 100; ++i) {
            list.add(b.buildFeature(null));
        }
        this.features = this.newCollection(schema, list);
    }

    protected abstract SimpleFeatureCollection newCollection(SimpleFeatureType var1, List<SimpleFeature> var2);

    public Collection randomPiece(Collection original) {
        LinkedList next = new LinkedList();
        Iterator og = original.iterator();
        while (og.hasNext()) {
            if (Math.random() > 0.5) {
                next.add(og.next());
                continue;
            }
            og.next();
        }
        return next;
    }

    public <F extends Feature> Collection<F> randomPiece(FeatureCollection<?, F> original) {
        LinkedList<Feature> next = new LinkedList<Feature>();
        try (FeatureIterator og = original.features();){
            while (og.hasNext()) {
                if (Math.random() > 0.5) {
                    next.add(og.next());
                    continue;
                }
                og.next();
            }
            LinkedList<Feature> linkedList = next;
            return linkedList;
        }
    }

    @Test
    public void testBounds() throws Exception {
        PrecisionModel pm = new PrecisionModel();
        Geometry[] g = new Geometry[4];
        GeometryFactory gf = new GeometryFactory(pm);
        g[0] = gf.createPoint(new Coordinate(0.0, 0.0));
        g[1] = gf.createPoint(new Coordinate(0.0, 10.0));
        g[2] = gf.createPoint(new Coordinate(10.0, 0.0));
        g[3] = gf.createPoint(new Coordinate(10.0, 10.0));
        GeometryCollection gc = gf.createGeometryCollection(g);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("bounds");
        tb.setCRS(null);
        tb.add("p1", Point.class);
        SimpleFeatureType t = tb.buildFeatureType();
        TreeSetFeatureCollection fc = new TreeSetFeatureCollection(null, t);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(t);
        for (Geometry geometry : g) {
            b.add((Object)geometry);
            fc.add(b.buildFeature(null));
        }
        Assert.assertEquals((Object)gc.getEnvelopeInternal(), (Object)fc.getBounds());
    }

    @Test
    public void testSetAbilities() {
        int size = this.features.size();
        if (this.features instanceof Collection) {
            ((Collection)this.features).addAll(this.randomPiece((FeatureCollection)this.features));
            Assert.assertEquals((long)this.features.size(), (long)size);
        }
    }

    @Test
    public void testAddRemoveAllAbilities() throws Exception {
        Collection half = this.randomPiece((FeatureCollection)this.features);
        List otherHalf = DataUtilities.list((FeatureCollection)this.features);
        if (this.features instanceof Collection) {
            Collection collection = (Collection)this.features;
            otherHalf.removeAll(half);
            collection.removeAll(half);
            Assert.assertTrue((boolean)this.features.containsAll((Collection)otherHalf));
            Assert.assertFalse((boolean)this.features.containsAll(half));
            collection.removeAll(otherHalf);
            Assert.assertEquals((long)0L, (long)this.features.size());
            collection.addAll(half);
            Assert.assertTrue((boolean)this.features.containsAll(half));
            collection.addAll(otherHalf);
            Assert.assertTrue((boolean)this.features.containsAll((Collection)otherHalf));
            collection.retainAll(otherHalf);
            Assert.assertTrue((boolean)this.features.containsAll((Collection)otherHalf));
            Assert.assertFalse((boolean)this.features.containsAll(half));
            collection.addAll(otherHalf);
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            Assert.assertEquals((long)this.features.size(), (long)0L);
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setName("XXX");
            SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
            Assert.assertFalse((boolean)collection.remove(b.buildFeature(null)));
        }
    }

    @Test
    public void testAssorted() {
        TreeSetFeatureCollection copy = new TreeSetFeatureCollection();
        copy.addAll((FeatureCollection)this.features);
        copy.clear();
        Assert.assertTrue((boolean)copy.isEmpty());
        copy.addAll((FeatureCollection)this.features);
        Assert.assertFalse((boolean)copy.isEmpty());
        List list = DataUtilities.list((FeatureCollection)this.features);
        SimpleFeature[] f1 = list.toArray(new SimpleFeature[list.size()]);
        SimpleFeature[] f2 = (SimpleFeature[])this.features.toArray((Object[])new SimpleFeature[list.size()]);
        Assert.assertEquals((long)f1.length, (long)f2.length);
        for (int i = 0; i < f1.length; ++i) {
            Assert.assertSame((Object)f1[i], (Object)f2[i]);
        }
        try (SimpleFeatureIterator copyIterator = copy.features();
             SimpleFeatureIterator featuresIterator = this.features.features();){
            while (copyIterator.hasNext() && featuresIterator.hasNext()) {
                Assert.assertEquals((Object)copyIterator.next(), (Object)featuresIterator.next());
            }
        }
    }

    @Test
    public void testFeatureComparatorsNameWithNullValues() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("DummyToBeSorted");
        tb.add("name", String.class);
        tb.add("number", Integer.class);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(tb.buildFeatureType());
        SimpleFeature f1 = b.buildFeature(null, new Object[]{"Steve", 32});
        SimpleFeature f2 = b.buildFeature(null, new Object[]{null, null});
        SimpleFeature f3 = b.buildFeature(null, new Object[]{null, null});
        FeatureComparators.Name compareName = new FeatureComparators.Name("name");
        Assert.assertTrue((compareName.compare((Object)f1, (Object)f2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((compareName.compare((Object)f2, (Object)f1) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)compareName.compare((Object)f2, (Object)f3));
        FeatureComparators.Name compareNumber = new FeatureComparators.Name("name");
        Assert.assertTrue((compareNumber.compare((Object)f1, (Object)f2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((compareNumber.compare((Object)f2, (Object)f1) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)compareNumber.compare((Object)f2, (Object)f3));
    }

    class ListenerProxy
    implements CollectionListener {
        int changeEvents = 0;

        ListenerProxy() {
        }

        public void collectionChanged(CollectionEvent tce) {
            ++this.changeEvents;
        }
    }
}

