/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import java.util.Comparator;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.junit.Assert;
import org.junit.Test;

public class SortedFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testNaturalSort() throws Exception {
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, new SortBy[]{SortBy.NATURAL_ORDER});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)SortBy.NATURAL_ORDER));
    }

    @Test
    public void testReverseSort() throws Exception {
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, new SortBy[]{SortBy.REVERSE_ORDER});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)SortBy.REVERSE_ORDER));
    }

    @Test
    public void testSortAttribute() throws Exception {
        SortBy sort = this.ff.sort("someAtt", SortOrder.ASCENDING);
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, new SortBy[]{sort});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)sort));
    }

    @Test
    public void testSortAttributeDescending() throws Exception {
        SortBy sort = this.ff.sort("someAtt", SortOrder.DESCENDING);
        SortedSimpleFeatureCollection sorted = new SortedSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, new SortBy[]{sort});
        this.checkSorted(sorted, DataUtilities.sortComparator((SortBy)sort));
    }

    private void checkSorted(SortedSimpleFeatureCollection sorted, Comparator<SimpleFeature> comparator) {
        try (SimpleFeatureIterator fi = sorted.features();){
            SimpleFeature prev = null;
            while (fi.hasNext()) {
                SimpleFeature curr = (SimpleFeature)fi.next();
                if (prev != null) {
                    Assert.assertTrue((String)("Failed on " + prev + " / " + curr), (comparator.compare(prev, curr) <= 0 ? 1 : 0) != 0);
                }
                prev = curr;
            }
        }
    }
}

