/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.data.sort.SimpleFeatureIO;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.referencing.CRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;

public class SimpleFeatureIOTest {
    private static final String NAME_FIELD = "name";
    private static final String BASE_STRING = "Testing Simple Feature IO big string";
    private static final int MULTIPLIER = 3333;

    @Before
    @After
    public void resetProperty() {
        System.clearProperty("geotools.simplefeatureio.deserialization");
    }

    @Test
    public void testBigString() throws Exception {
        String bigString = this.bigString();
        this.checkStringNameEncodeDecode(bigString);
    }

    @Test
    public void testSmallString() throws Exception {
        String smallString = "Hello geotools.";
        this.checkStringNameEncodeDecode(smallString);
    }

    private void checkStringNameEncodeDecode(String name) throws IOException, NoSuchAuthorityCodeException, FactoryException, FileNotFoundException {
        File tempFile = File.createTempFile("temp", "simpleFeatureIO");
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("type1");
        typeBuilder.add(NAME_FIELD, String.class);
        typeBuilder.add("location", Point.class, CRS.decode((String)"EPSG:4326"));
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        if (name.getBytes().length >= 65535) {
            type.getDescriptor(NAME_FIELD).getUserData().put("bigString", Boolean.TRUE);
        }
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(type);
        fbuilder.set(NAME_FIELD, (Object)name);
        GeometryBuilder gb = new GeometryBuilder();
        fbuilder.set("location", (Object)gb.point(10.0, 10.0));
        SimpleFeature feature = fbuilder.buildFeature("1");
        SimpleFeatureIO sfio = new SimpleFeatureIO(tempFile, type);
        sfio.write(feature);
        sfio.close(false);
        sfio = new SimpleFeatureIO(tempFile, type);
        SimpleFeature readFeature = sfio.read();
        Assert.assertEquals((long)name.length(), (long)((String)readFeature.getAttribute(NAME_FIELD)).length());
        Assert.assertEquals((Object)name, (Object)readFeature.getAttribute(NAME_FIELD));
        sfio.close(true);
    }

    private String bigString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3333; ++i) {
            sb.append(BASE_STRING);
        }
        return sb.toString();
    }

    @Test
    public void testDeserializationDefault() throws Exception {
        SimpleFeatureIOTest.doTestDeserialization(false, true);
    }

    @Test
    public void testDeserializationEnabled() throws Exception {
        System.setProperty("geotools.simplefeatureio.deserialization", "true");
        SimpleFeatureIOTest.doTestDeserialization(false, false);
    }

    @Test
    public void testDeserializationDisabled() throws Exception {
        System.setProperty("geotools.simplefeatureio.deserialization", "false");
        SimpleFeatureIOTest.doTestDeserialization(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTestDeserialization(boolean exception1, boolean exception2) throws Exception {
        URI uri = URI.create("http://localhost/");
        File tempFile = File.createTempFile("temp", "simpleFeatureIODeserialization");
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("type2");
        typeBuilder.add("uri", URI.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        featureBuilder.set("uri", (Object)uri);
        SimpleFeatureIO sfio1 = new SimpleFeatureIO(tempFile, type);
        try {
            sfio1.write(featureBuilder.buildFeature("1"));
            sfio1.seek(0L);
            if (exception1) {
                Assert.assertThrows(IllegalStateException.class, () -> sfio1.read());
            } else {
                Assert.assertEquals((Object)uri, (Object)sfio1.read().getAttribute("uri"));
            }
        }
        finally {
            sfio1.close(false);
        }
        SimpleFeatureIO sfio2 = new SimpleFeatureIO(tempFile, type);
        try {
            if (exception2) {
                Assert.assertThrows(IllegalStateException.class, () -> sfio2.read());
            } else {
                Assert.assertEquals((Object)uri, (Object)sfio2.read().getAttribute("uri"));
            }
        }
        finally {
            sfio2.close(true);
        }
    }
}

