/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Assert;
import org.junit.Test;

public class MaxVisitorTest {
    private static SimpleFeatureType SCHEMA;

    @Test(expected=IllegalStateException.class)
    public void visitedFlagSetWithoutValue() throws Exception {
        MemoryFeatureCollection collection = new MemoryFeatureCollection(SCHEMA);
        collection.add(SimpleFeatureBuilder.build((SimpleFeatureType)SCHEMA, (Object[])new Object[]{1, 0}, (String)"1"));
        PreVisitedMaxVisitor falseVisitor = new PreVisitedMaxVisitor("AInteger");
        try {
            collection.accepts((FeatureVisitor)falseVisitor, null);
        }
        catch (Exception e) {
            while (e.getCause() != null) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    @Test
    public void resetCallWillNullify() throws Exception {
        MemoryFeatureCollection collection = new MemoryFeatureCollection(SCHEMA);
        collection.add(SimpleFeatureBuilder.build((SimpleFeatureType)SCHEMA, (Object[])new Object[]{0, Integer.MAX_VALUE}, (String)"1"));
        MaxVisitor visitor = new MaxVisitor("ALong");
        collection.accepts((FeatureVisitor)visitor, null);
        visitor.reset();
        collection.accepts((FeatureVisitor)visitor, null);
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)((Long)visitor.getMax()));
    }

    static {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Test");
        builder.add("AInteger", Integer.class);
        builder.add("ALong", Long.class);
        SCHEMA = builder.buildFeatureType();
    }

    private class PreVisitedMaxVisitor
    extends MaxVisitor {
        PreVisitedMaxVisitor(String attribute) {
            super(attribute);
            this.visited = true;
        }
    }
}

