/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.SumAreaVisitor;
import org.geotools.feature.visitor.VisitorTestCase;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@RunWith(value=Parameterized.class)
public class SumAreaVisitorTest<T>
extends VisitorTestCase<T, T> {
    private static final GeometryFactory GF = new GeometryFactory();

    public SumAreaVisitorTest(Class<T> valueClass, List<T> values, T expectedValue) {
        super(valueClass, values, expectedValue);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Polygon.class, Arrays.asList(SumAreaVisitorTest.polygon(new int[]{12, 6, 14, 8, 16, 6, 16, 4, 12, 4, 12, 6}), SumAreaVisitorTest.polygon(new int[]{10, 3, 12, 5, 16, 6, 15, 4, 13, 4, 10, 3})), 18.5}, {Polygon.class, Arrays.asList(SumAreaVisitorTest.polygon(new int[]{12, 6, 14, 8, 16, 6, 16, 4, 12, 4, 12, 6})), 12.0});
    }

    public static Polygon polygon(int[] xy) {
        LinearRing shell = SumAreaVisitorTest.ring(xy);
        return GF.createPolygon(shell, null);
    }

    public static LinearRing ring(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return GF.createLinearRing(coords);
    }

    @Override
    protected FeatureCalc createVisitor(int attributeTypeIndex, SimpleFeatureType type) {
        return new SumAreaVisitor(attributeTypeIndex, type);
    }
}

