/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.HashSet;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.filter.function.FunctionTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class Collection_FunctionsTest
extends FunctionTestSupport {
    @Test
    public void testInstance() {
        Function cmin = this.ff.function("Collection_Min", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Assert.assertNotNull((Object)cmin);
    }

    @Test
    public void testAverage() throws Exception {
        this.performNumberTest("Collection_Average", 33.375);
    }

    @Test
    public void testCount() throws Exception {
        this.performNumberTest("Collection_Count", 8);
    }

    @Test
    public void testMin() throws Exception {
        this.performNumberTest("Collection_Min", 4);
    }

    @Test
    public void testMedian() throws Exception {
        this.performNumberTest("Collection_Median", 24.5);
    }

    @Test
    public void testMax() throws Exception {
        this.performNumberTest("Collection_Max", 90);
    }

    @Test
    public void testSum() throws Exception {
        this.performNumberTest("Collection_Sum", 267);
    }

    @Test
    public void testUnique() throws Exception {
        HashSet<Integer> result = new HashSet<Integer>(8);
        result.add(90);
        result.add(4);
        result.add(8);
        result.add(43);
        result.add(61);
        result.add(20);
        result.add(29);
        result.add(12);
        this.performObjectTest("Collection_Unique", result);
    }

    @Test
    public void testNearest() throws Exception {
        Function func = this.ff.function("Collection_Nearest", new Expression[]{this.ff.property("foo"), this.ff.literal(9)});
        Object match = func.evaluate((Object)this.featureCollection);
        Assert.assertEquals((String)"Nearest to 9 is 8", (Object)8, (Object)match);
    }

    @Test
    public void testCountFunctionDescription() throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Collection_Count", new Expression[]{exp});
        Assert.assertEquals((long)func.getParameters().size(), (long)1L);
        Assert.assertEquals((Object)func.getFunctionName().getReturn().toString(), (Object)"count:Number");
    }

    public void performNumberTest(String functionName, Object expectedValue) throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(functionName, new Expression[]{exp});
        Object obj = func.evaluate((Object)this.featureCollection);
        Number result = (Number)obj;
        Number expected = (Number)expectedValue;
        Assert.assertEquals((double)expected.doubleValue(), (double)result.doubleValue(), (double)0.0);
    }

    public void performObjectTest(String functionName, Object expectedValue) throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(functionName, new Expression[]{exp});
        Object result = func.evaluate((Object)this.featureCollection);
        Assert.assertEquals((Object)expectedValue, (Object)result);
    }
}

