/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.temporal;

import org.geotools.api.filter.expression.Expression;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.TemporalPrimitive;
import org.geotools.filter.temporal.TContainsImpl;
import org.geotools.filter.temporal.TemporalFilterTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class TContainsImplTest
extends TemporalFilterTestSupport {
    @Test
    public void test() throws Exception {
        Instant i1 = this.instant("2001-07-04T12:08:56.235-0700");
        Instant i2 = this.instant("2001-07-05T12:08:56.235-0700");
        this.doAssert((TemporalPrimitive)i1, (TemporalPrimitive)i2, false);
        this.doAssert((TemporalPrimitive)i2, (TemporalPrimitive)i1, false);
        this.doAssert((TemporalPrimitive)i1, (TemporalPrimitive)i1, false);
        Period p1 = this.period("2001-07-04T12:08:56.235-0700", "2001-07-05T12:08:56.235-0700");
        Instant i3 = this.instant("2001-07-05T12:00:00.235-0700");
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)i1, false);
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)i2, false);
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)i3, true);
        this.doAssert((TemporalPrimitive)i3, (TemporalPrimitive)p1, false);
        Period p2 = this.period("2001-07-04T12:08:56.235-0700", "2001-07-05T12:00:56.235-0700");
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)p2, false);
        Period p3 = this.period("2001-07-04T13:08:56.235-0700", "2001-07-05T12:08:56.235-0700");
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)p3, false);
        Period p4 = this.period("2001-07-04T13:08:56.235-0700", "2001-07-05T12:00:56.235-0700");
        this.doAssert((TemporalPrimitive)p1, (TemporalPrimitive)p4, true);
    }

    void doAssert(TemporalPrimitive tp1, TemporalPrimitive tp2, boolean b) {
        TContainsImpl a = new TContainsImpl((Expression)ff.literal((Object)tp1), (Expression)ff.literal((Object)tp2));
        Assert.assertEquals((Object)b, (Object)a.evaluate(null));
        Assert.assertFalse((boolean)a.toString().contains(TContainsImpl.class.getName()));
        Assert.assertTrue((boolean)a.toString().contains("TContains"));
    }
}

