/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.visitor.AbstractCapabilitiesFilterSplitterTests;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class CapabilitiesFilterSplitterSpatialTest
extends AbstractCapabilitiesFilterSplitterTests {
    private Geometry geom = new GeometryFactory().createPoint();

    @Test
    public void testBBOX() throws Exception {
        BBOX f = this.ff.bbox("geom", 10.0, 10.0, 20.0, 20.0, "");
        this.runTest((Filter)f, this.newCapabilities(BBOX.class), "geom");
    }

    @Test
    public void testBEYOND() throws Exception {
        Beyond f = this.ff.beyond("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, this.newCapabilities(Beyond.class), "geom");
    }

    @Test
    public void testCONTAINS() throws Exception {
        Contains f = this.ff.contains("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Contains.class), "geom");
    }

    @Test
    public void testCROSSES() throws Exception {
        Crosses f = this.ff.crosses("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Crosses.class), "geom");
    }

    @Test
    public void testDISJOINT() throws Exception {
        Disjoint f = this.ff.disjoint("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Disjoint.class), "geom");
    }

    @Test
    public void tesDWITHINt() throws Exception {
        DWithin f = this.ff.dwithin("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, this.newCapabilities(DWithin.class), "geom");
    }

    @Test
    public void testEQUALS() throws Exception {
        Equals f = this.ff.equals("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Equals.class), "geom");
    }

    @Test
    public void testINTERSECTS() throws Exception {
        Intersects f = this.ff.intersects("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Intersects.class), "geom");
    }

    @Test
    public void testOVERLAPS() throws Exception {
        Overlaps f = this.ff.overlaps("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Overlaps.class), "geom");
    }

    @Test
    public void testTOUCHES() throws Exception {
        Touches f = this.ff.touches("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Touches.class), "geom");
    }

    @Test
    public void testWITHIN() throws Exception {
        Within f = this.ff.within("geom", this.geom);
        this.runTest((Filter)f, this.newCapabilities(Within.class), "geom");
    }
}

