/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.visitor.AbstractPostPreProcessFilterSplittingVisitorTests;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class PostPreProcessFilterSplittingVisitorSpatialTest
extends AbstractPostPreProcessFilterSplittingVisitorTests {
    Geometry geom = new GeometryFactory().createPoint();

    @Test
    public void testBBOX() throws Exception {
        BBOX f = this.ff.bbox("geom", 10.0, 10.0, 20.0, 20.0, "");
        this.runTest((Filter)f, new FilterCapabilities(BBOX.class), "geom");
    }

    @Test
    public void testBEYOND() throws Exception {
        Beyond f = this.ff.beyond("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, new FilterCapabilities(Beyond.class), "geom");
    }

    @Test
    public void testCONTAINS() throws Exception {
        Contains f = this.ff.contains("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Contains.class), "geom");
    }

    @Test
    public void testCROSSES() throws Exception {
        Crosses f = this.ff.crosses("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Crosses.class), "geom");
    }

    @Test
    public void testDISJOINT() throws Exception {
        Disjoint f = this.ff.disjoint("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Disjoint.class), "geom");
    }

    @Test
    public void testDWITHIN() throws Exception {
        DWithin f = this.ff.dwithin("geom", this.geom, 10.0, "");
        this.runTest((Filter)f, new FilterCapabilities(DWithin.class), "geom");
    }

    @Test
    public void testEQUALS() throws Exception {
        Equals f = this.ff.equals("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Equals.class), "geom");
    }

    @Test
    public void testINTERSECTS() throws Exception {
        Intersects f = this.ff.intersects("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Intersects.class), "geom");
    }

    @Test
    public void testOVERLAPS() throws Exception {
        Overlaps f = this.ff.overlaps("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Overlaps.class), "geom");
    }

    @Test
    public void testTOUCHES() throws Exception {
        Touches f = this.ff.touches("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Touches.class), "geom");
    }

    @Test
    public void testWITHIN() throws Exception {
        Within f = this.ff.within("geom", this.geom);
        this.runTest((Filter)f, new FilterCapabilities(Within.class), "geom");
    }
}

