/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.CircularArc;
import org.junit.Assert;
import org.locationtech.jts.geom.CoordinateSequence;

class Circle {
    double radius;
    double cx;
    double cy;
    static final double EPS = 1.0E-6;

    public Circle(double radius, double cx, double cy) {
        this.radius = radius;
        this.cx = cx;
        this.cy = cy;
    }

    public Circle(double radius) {
        this(radius, 0.0, 0.0);
    }

    public double[] samplePoints(double ... angles) {
        double[] result = new double[angles.length * 2];
        int i = 0;
        for (double angle : angles) {
            result[i++] = this.cx + this.radius * Math.cos(angle);
            result[i++] = this.cy + this.radius * Math.sin(angle);
        }
        return result;
    }

    public CircularArc getCircularArc(double startAngle, double midAngle, double endAngle) {
        double[] controlPoints = this.samplePoints(startAngle, midAngle, endAngle);
        return new CircularArc(controlPoints);
    }

    public void assertTolerance(CoordinateSequence cs, double tolerance) {
        double[] ordinates = new double[cs.size() * 2];
        for (int i = 0; i < cs.size(); ++i) {
            ordinates[i * 2] = cs.getOrdinate(i, 0);
            ordinates[i * 2 + 1] = cs.getOrdinate(i, 1);
        }
        this.assertTolerance(ordinates, tolerance);
    }

    public void assertTolerance(double[] ordinates, double tolerance) {
        if (this.clockwise(ordinates)) {
            for (int i = 0; i < ordinates.length / 2; ++i) {
                double temp = ordinates[i];
                ordinates[i] = ordinates[ordinates.length - i - 1];
                ordinates[ordinates.length - i - 1] = temp;
            }
        }
        double prevAngle = 0.0;
        for (int i = 0; i < ordinates.length; i += 2) {
            double x = ordinates[i];
            double dx = x - this.cx;
            double y = ordinates[i + 1];
            double dy = y - this.cy;
            double d = Math.sqrt(dx * dx + dy * dy);
            double distanceFromCircle = Math.abs(this.radius - d);
            if (distanceFromCircle > tolerance) {
                Assert.fail((String)("Found a point " + x + "," + y + " that's not on the circle with distance " + distanceFromCircle + " from it"));
            }
            Assert.assertEquals((double)this.radius, (double)d, (double)tolerance);
            double angle = Math.atan2(dy, dx);
            if (i > 1) {
                double chordAngle = angle - prevAngle;
                if (chordAngle < 0.0) {
                    chordAngle += Math.PI * 2;
                } else if (chordAngle > Math.PI) {
                    chordAngle = Math.PI * 2 - chordAngle;
                }
                double halfChordLength = this.radius * Math.sin(chordAngle / 2.0);
                double apothem = Math.sqrt(this.radius * this.radius - halfChordLength * halfChordLength);
                double distance = this.radius - apothem;
                if (distance > tolerance) {
                    Assert.fail((String)("Max tolerance is " + tolerance + " but found a chord that is at " + distance + " from the circle"));
                }
            }
            prevAngle = angle;
        }
    }

    boolean clockwise(double[] ordinates) {
        double sa = Math.atan2(ordinates[1] - this.cx, ordinates[0] - this.cy);
        double ma = Math.atan2(ordinates[3] - this.cx, ordinates[2] - this.cy);
        double ea = Math.atan2(ordinates[5] - this.cx, ordinates[3] - this.cy);
        return sa > ma && ma > ea || sa < ma && sa > ea || ma < ea && sa > ea;
    }
}

