/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.List;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class OrthographicProjectionHandlerFactoryTest {
    private static final GeometryFactory GFACTORY = new GeometryFactory();
    private static DefaultGeographicCRS WGS84;
    private static Envelope WORLD;

    @BeforeClass
    public static void setup() throws Exception {
        WGS84 = DefaultGeographicCRS.WGS84;
        MapProjection.SKIP_SANITY_CHECKS = true;
    }

    @AfterClass
    public static void teardown() throws Exception {
        MapProjection.SKIP_SANITY_CHECKS = false;
    }

    @Test
    public void testObliqueEurope() throws Exception {
        CoordinateReferenceSystem ortho = CRS.decode((String)"AUTO:42003,9001,11,48");
        ReferencedEnvelope re = new ReferencedEnvelope(WORLD, ortho);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)WGS84, (boolean)false);
        Assert.assertNotNull((Object)handler);
        Geometry validArea = handler.getValidArea();
        Assert.assertNotNull((Object)validArea);
        MatcherAssert.assertThat((Object)validArea, (Matcher)CoreMatchers.instanceOf(Polygon.class));
        Assert.assertTrue((boolean)validArea.contains((Geometry)this.point(10.0, -41.0)));
        Assert.assertFalse((boolean)validArea.contains((Geometry)this.point(10.0, -42.0)));
        Assert.assertTrue((boolean)validArea.contains((Geometry)this.point(-161.0, 42.0)));
        Assert.assertFalse((boolean)validArea.contains((Geometry)this.point(-161.0, 41.0)));
        Assert.assertTrue((boolean)validArea.contains((Geometry)this.point(173.0, 41.0)));
        Assert.assertFalse((boolean)validArea.contains((Geometry)this.point(173.0, 40.0)));
        for (double lon = -179.0; lon < 180.0; lon += 5.0) {
            for (double lat = 44.9; lat < 89.7; lat += 5.0) {
                Assert.assertTrue((String)("Failed check with " + lon + "," + lat), (boolean)validArea.contains((Geometry)this.point(lon, lat)));
            }
        }
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.size());
        ReferencedEnvelope envelope = (ReferencedEnvelope)envelopes.get(0);
        Assert.assertTrue((boolean)JTS.equals((Envelope)new Envelope(-180.0, 180.0, -42.0, 90.0), (Envelope)envelope, (double)0.3));
    }

    @Test
    public void testObliqueAfrica() throws Exception {
        CoordinateReferenceSystem ortho = CRS.decode((String)"AUTO:42003,9001,11,-48");
        ReferencedEnvelope re = new ReferencedEnvelope(WORLD, ortho);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)WGS84, (boolean)false);
        Assert.assertNotNull((Object)handler);
        Geometry validArea = handler.getValidArea();
        Assert.assertNotNull((Object)validArea);
        MatcherAssert.assertThat((Object)validArea, (Matcher)CoreMatchers.instanceOf(Polygon.class));
        Assert.assertTrue((boolean)validArea.contains((Geometry)this.point(10.0, 41.0)));
        Assert.assertFalse((boolean)validArea.contains((Geometry)this.point(10.0, 42.0)));
        Assert.assertTrue((boolean)validArea.contains((Geometry)this.point(-161.0, -42.0)));
        Assert.assertFalse((boolean)validArea.contains((Geometry)this.point(-161.0, -41.0)));
        Assert.assertTrue((boolean)validArea.contains((Geometry)this.point(173.0, -41.0)));
        Assert.assertFalse((boolean)validArea.contains((Geometry)this.point(173.0, -40.0)));
        for (double lon = -179.0; lon < 180.0; lon += 5.0) {
            for (double lat = -89.7; lat < -41.0; lat += 5.0) {
                Assert.assertTrue((String)("Failed check with " + lon + "," + lat), (boolean)validArea.contains((Geometry)this.point(lon, lat)));
            }
        }
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.size());
        ReferencedEnvelope envelope = (ReferencedEnvelope)envelopes.get(0);
        Assert.assertTrue((boolean)JTS.equals((Envelope)new Envelope(-180.0, 180.0, -90.0, 42.0), (Envelope)envelope, (double)0.3));
    }

    @Test
    public void testNorthPolar() throws Exception {
        CoordinateReferenceSystem ortho = CRS.decode((String)"AUTO:42003,9001,0,90");
        ReferencedEnvelope re = new ReferencedEnvelope(WORLD, ortho);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)WGS84, (boolean)false);
        Assert.assertNotNull((Object)handler);
        Geometry validArea = handler.getValidArea();
        Assert.assertNotNull((Object)validArea);
        Assert.assertTrue((boolean)validArea.isRectangle());
        Envelope expectedValid = new Envelope(-180.0, 180.0, 0.0, 90.0);
        Assert.assertTrue((boolean)JTS.equals((Envelope)expectedValid, (Envelope)validArea.getEnvelopeInternal(), (double)0.3));
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.size());
        ReferencedEnvelope envelope = (ReferencedEnvelope)envelopes.get(0);
        Assert.assertTrue((boolean)JTS.equals((Envelope)expectedValid, (Envelope)envelope, (double)0.3));
    }

    @Test
    public void testSouthPolar() throws Exception {
        CoordinateReferenceSystem ortho = CRS.decode((String)"AUTO:42003,9001,0,-90");
        ReferencedEnvelope re = new ReferencedEnvelope(WORLD, ortho);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)WGS84, (boolean)false);
        Assert.assertNotNull((Object)handler);
        Geometry validArea = handler.getValidArea();
        Assert.assertNotNull((Object)validArea);
        Assert.assertTrue((boolean)validArea.isRectangle());
        Envelope expectedValid = new Envelope(-180.0, 180.0, -90.0, 0.0);
        Assert.assertTrue((boolean)JTS.equals((Envelope)expectedValid, (Envelope)validArea.getEnvelopeInternal(), (double)0.3));
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.size());
        ReferencedEnvelope envelope = (ReferencedEnvelope)envelopes.get(0);
        Assert.assertTrue((boolean)JTS.equals((Envelope)expectedValid, (Envelope)envelope, (double)0.3));
    }

    @Test
    public void testEquatorialNoDateline() throws Exception {
        CoordinateReferenceSystem ortho = CRS.decode((String)"AUTO:42003,9001,0,0");
        ReferencedEnvelope re = new ReferencedEnvelope(WORLD, ortho);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)WGS84, (boolean)false);
        Assert.assertNotNull((Object)handler);
        Geometry validArea = handler.getValidArea();
        Assert.assertNotNull((Object)validArea);
        Polygon expected = JTS.toGeometry((Envelope)new Envelope(-90.0, 90.0, -90.0, 90.0));
        Assert.assertEquals((double)0.0, (double)expected.difference(validArea).getArea(), (double)0.5);
        Assert.assertEquals((double)0.0, (double)validArea.difference((Geometry)expected).getArea(), (double)0.5);
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)1L, (long)envelopes.size());
        Assert.assertTrue((boolean)JTS.equals((Envelope)expected.getEnvelopeInternal(), (Envelope)((Envelope)envelopes.get(0)), (double)0.1));
    }

    @Test
    public void testEquatorialWestDateline() throws Exception {
        CoordinateReferenceSystem ortho = CRS.decode((String)"AUTO:42003,9001,150,0");
        ReferencedEnvelope re = new ReferencedEnvelope(WORLD, ortho);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)re, (CoordinateReferenceSystem)WGS84, (boolean)false);
        Assert.assertNotNull((Object)handler);
        Geometry validArea = handler.getValidArea();
        Assert.assertNotNull((Object)validArea);
        MatcherAssert.assertThat((Object)validArea, (Matcher)CoreMatchers.instanceOf(MultiPolygon.class));
        MultiPolygon mp = (MultiPolygon)validArea;
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        Polygon p1 = (Polygon)mp.getGeometryN(0);
        Polygon p2 = (Polygon)mp.getGeometryN(1);
        Polygon e1 = JTS.toGeometry((Envelope)new Envelope(-180.0, -120.0, -90.0, 90.0));
        Assert.assertEquals((double)0.0, (double)e1.difference((Geometry)p1).getArea(), (double)0.5);
        Assert.assertEquals((double)0.0, (double)p1.difference((Geometry)e1).getArea(), (double)0.5);
        Polygon e2 = JTS.toGeometry((Envelope)new Envelope(60.0, 180.0, -90.0, 90.0));
        Assert.assertEquals((double)0.0, (double)e2.difference((Geometry)p2).getArea(), (double)0.5);
        Assert.assertEquals((double)0.0, (double)p2.difference((Geometry)e2).getArea(), (double)0.5);
        List envelopes = handler.getQueryEnvelopes();
        Assert.assertEquals((long)2L, (long)envelopes.size());
        Assert.assertTrue((boolean)JTS.equals((Envelope)p1.getEnvelopeInternal(), (Envelope)((Envelope)envelopes.get(0)), (double)0.1));
        Assert.assertTrue((boolean)JTS.equals((Envelope)p2.getEnvelopeInternal(), (Envelope)((Envelope)envelopes.get(1)), (double)0.1));
    }

    private Point point(double x, double y) {
        return GFACTORY.createPoint(new Coordinate(x, y));
    }

    static {
        WORLD = new Envelope(-7000000.0, 7000000.0, -7000000.0, 7000000.0);
    }
}

