/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.swing.Icon;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.style.ExternalMark;
import org.geotools.api.style.TraversingStyleVisitor;

public class ExternalMarkImpl
implements ExternalMark {
    private OnLineResource onlineResource;
    private Icon inlineContent;
    private int index;
    private String format;

    public ExternalMarkImpl() {
    }

    public ExternalMarkImpl(Icon icon) {
        this.inlineContent = icon;
        this.index = -1;
        this.onlineResource = null;
        this.format = null;
    }

    public ExternalMarkImpl(OnLineResource resource, String format, int markIndex) {
        this.inlineContent = null;
        this.index = markIndex;
        this.onlineResource = resource;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public Icon getInlineContent() {
        return this.inlineContent;
    }

    public int getMarkIndex() {
        return this.index;
    }

    public OnLineResource getOnlineResource() {
        return this.onlineResource;
    }

    public Object accept(TraversingStyleVisitor visitor, Object extraData) {
        return visitor.visit((ExternalMark)this, extraData);
    }

    public void setInlineContent(Icon inline) {
        this.inlineContent = inline;
    }

    public void setFormat(String mimeType) {
        this.format = mimeType;
    }

    public void setMarkIndex(int markIndex) {
        this.index = markIndex;
    }

    public void setOnlineResource(OnLineResource resource) {
        this.onlineResource = resource;
    }

    static ExternalMarkImpl cast(ExternalMark mark) {
        if (mark == null) {
            return null;
        }
        if (mark instanceof ExternalMarkImpl) {
            return (ExternalMarkImpl)mark;
        }
        ExternalMarkImpl copy = new ExternalMarkImpl();
        copy.setFormat(mark.getFormat());
        copy.setMarkIndex(mark.getMarkIndex());
        copy.setOnlineResource(mark.getOnlineResource());
        return copy;
    }
}

