/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;

public class GeosProjectionHandlerFactory
implements ProjectionHandlerFactory {
    public static final Polygon WORLD_LEFT = JTS.toGeometry(new Envelope(-360.0, -180.0, -90.0, 90.0));
    public static final Polygon WORLD = JTS.toGeometry(new Envelope(-180.0, 180.0, -90.0, 90.0));
    public static final Polygon WORLD_RIGHT = JTS.toGeometry(new Envelope(180.0, 360.0, -90.0, 90.0));

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCRS, boolean wrap, int wrapLimit) throws FactoryException {
        CoordinateReferenceSystem targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)targetCRS);
        if (!(mapProjection instanceof GeostationarySatellite)) {
            return null;
        }
        ParameterValueGroup params = mapProjection.getParameterValues();
        double cm = params.parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
        double height = params.parameter(GeostationarySatellite.Provider.SATELLITE_HEIGHT.getName().getCode()).doubleValue();
        Ellipsoid ellipsoid = ((ProjectedCRS)targetCRS).getBaseCRS().getDatum().getEllipsoid();
        double radius = (ellipsoid.getSemiMajorAxis() + ellipsoid.getSemiMajorAxis()) / 2.0;
        double angle = GeosProjectionHandlerFactory.getInnerAngle(height, radius);
        Geometry validArea = GeosProjectionHandlerFactory.getValidAreaLatLon(cm, angle);
        return new GeosProjectionHandler(sourceCRS, validArea, renderingEnvelope);
    }

    static double getInnerAngle(double hypotenuse, double cathetus) {
        double opposite = Math.sqrt(hypotenuse * hypotenuse - cathetus * cathetus);
        return Math.toDegrees(Math.atan2(opposite, cathetus));
    }

    static Geometry getValidAreaLatLon(double centralMeridian, double angle) {
        Point center = new GeometryFactory().createPoint(new Coordinate(centralMeridian, 0.0));
        Geometry circle = center.buffer(angle, 45);
        Envelope env = circle.getEnvelopeInternal();
        if (env.getMinX() < -180.0) {
            Geometry left = circle.intersection((Geometry)WORLD_LEFT);
            Geometry leftTranslated = AffineTransformation.translationInstance((double)360.0, (double)0.0).transform(left);
            Geometry right = circle.intersection((Geometry)WORLD);
            return right.union(leftTranslated);
        }
        if (env.getMaxX() > 180.0) {
            Geometry left = circle.intersection((Geometry)WORLD);
            Geometry right = circle.intersection((Geometry)WORLD_RIGHT);
            Geometry rightTranslated = AffineTransformation.translationInstance((double)-360.0, (double)0.0).transform(right);
            return left.union(rightTranslated);
        }
        return circle;
    }

    class GeosProjectionHandler
    extends ProjectionHandler {
        Geometry p1;
        Geometry p2;

        public GeosProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope) throws FactoryException {
            super(sourceCRS, validArea, renderingEnvelope);
            if (validArea instanceof MultiPolygon) {
                MultiPolygon mp = (MultiPolygon)validArea;
                this.p1 = mp.getGeometryN(0);
                this.p2 = mp.getGeometryN(1);
            }
        }

        @Override
        protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
            return this.transformEnvelope(envelope, targetCRS, this.validArea);
        }

        protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS, Geometry validArea) throws FactoryException, TransformException {
            Polygon geometry;
            Geometry intersection;
            CoordinateReferenceSystem envelopeCRS = envelope.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata((Object)envelopeCRS, (Object)targetCRS)) {
                return envelope;
            }
            Geometry validAreaInEnvelopeCRS = JTS.transform(validArea, CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)envelopeCRS));
            if (validArea instanceof MultiPolygon) {
                validAreaInEnvelopeCRS = validAreaInEnvelopeCRS.buffer(0.0);
            }
            if ((intersection = (geometry = JTS.toGeometry(envelope)).intersection(validAreaInEnvelopeCRS)) == null || intersection.isEmpty()) {
                return null;
            }
            Envelope ie = intersection.getEnvelopeInternal();
            double distance = (ie.getWidth() / 10.0 + ie.getHeight() / 10.0) / 2.0;
            intersection = Densifier.densify((Geometry)intersection, (double)distance);
            Geometry transformed = JTS.transform(intersection, CRS.findMathTransform((CoordinateReferenceSystem)envelopeCRS, (CoordinateReferenceSystem)targetCRS));
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(targetCRS), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true, Collections.emptyMap());
            if (handler == null || handler instanceof WrappingProjectionHandler) {
                return new ReferencedEnvelope(transformed.getEnvelopeInternal(), targetCRS);
            }
            ReferencedEnvelope validAreaBounds = handler.getValidAreaBounds();
            Polygon validAreaTarget = JTS.toGeometry(validAreaBounds.transform(targetCRS, true));
            Geometry reduced = transformed.intersection((Geometry)validAreaTarget);
            if (reduced == null || reduced.isEmpty()) {
                return null;
            }
            return new ReferencedEnvelope(reduced.getEnvelopeInternal(), targetCRS);
        }

        @Override
        public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
            if (this.p1 == null) {
                return super.getQueryEnvelopes();
            }
            ReferencedEnvelope e1 = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS, this.p1);
            ReferencedEnvelope e2 = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS, this.p2);
            if (e1 != null && e2 != null && e1.intersects(e2)) {
                e1.expandToInclude(e2);
                return Collections.singletonList(e1);
            }
            ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
            if (e1 != null) {
                result.add(e1);
            }
            if (e2 != null) {
                result.add(e2);
            }
            return result;
        }
    }
}

