/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.logging.Level;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

class WrappingCoordinateFilter
implements GeometryComponentFilter {
    static final int EAST_TO_WEST = 0;
    static final int WEST_TO_EAST = 1;
    static final int NOWRAP = 2;
    final double wrapLimit;
    final double offset;
    final MathTransform mt;
    final int ordinateIdx;
    final boolean isPreFlipped;

    public WrappingCoordinateFilter(double wrapLimit, double offset, MathTransform mt, boolean wrapOnY, boolean isPreFlipped) {
        this.wrapLimit = wrapLimit;
        this.offset = offset;
        this.mt = mt;
        this.ordinateIdx = wrapOnY ? 1 : 0;
        this.isPreFlipped = isPreFlipped;
    }

    public void filter(Geometry geom) {
        if (geom instanceof LineString) {
            LineString ls = (LineString)geom;
            CoordinateSequence cs = ls.getCoordinateSequence();
            int direction = this.getDisconinuityDirection(cs);
            if (direction == 2) {
                return;
            }
            boolean ring = geom instanceof LinearRing || cs.getCoordinate(0).equals((Object)cs.getCoordinate(cs.size() - 1));
            this.applyOffset(cs, direction == 0 ? 0.0 : this.wrapLimit * 2.0, ring, this.isPreFlipped);
        }
    }

    private int getDisconinuityDirection(CoordinateSequence cs) {
        double lastOrdinate = cs.getOrdinate(0, this.ordinateIdx);
        for (int i = 0; i < cs.size(); ++i) {
            double ordinate = cs.getOrdinate(i, this.ordinateIdx);
            if (Math.abs(ordinate - lastOrdinate) > this.wrapLimit) {
                if (ordinate > lastOrdinate) {
                    return 1;
                }
                if (ordinate < lastOrdinate) {
                    return 0;
                }
            }
            lastOrdinate = ordinate;
        }
        return 2;
    }

    private void applyOffset(CoordinateSequence cs, double offset, boolean ring, boolean preFlipped) {
        double maxWrap = this.wrapLimit * 1.9;
        double lastOrdinate = cs.getOrdinate(0, this.ordinateIdx);
        int last = ring ? cs.size() - 1 : cs.size();
        for (int i = 0; i < last; ++i) {
            double ordinate = cs.getOrdinate(i, this.ordinateIdx);
            double distance = Math.abs(ordinate - lastOrdinate);
            if (distance > this.wrapLimit) {
                boolean wraps;
                boolean bl = wraps = distance < maxWrap || preFlipped;
                if (!wraps && this.mt != null) {
                    double[] src = this.ordinateIdx == 0 ? new double[]{lastOrdinate, cs.getY(i - 1), ordinate, cs.getY(i)} : new double[]{cs.getX(i - 1), lastOrdinate, cs.getX(i), ordinate};
                    double[] dest = new double[4];
                    try {
                        this.mt.transform(src, 0, dest, 0, 2);
                        src[0] = Math.min(dest[0], dest[2]) + Math.abs(dest[2] - dest[0]) / 2.0;
                        src[1] = Math.min(dest[1], dest[3]) + Math.abs(dest[3] - dest[1]) / 2.0;
                        this.mt.inverse().transform(src, 0, dest, 0, 1);
                        wraps = !(dest[this.ordinateIdx] > Math.min(lastOrdinate, ordinate)) || !(dest[this.ordinateIdx] < Math.max(lastOrdinate, ordinate));
                    }
                    catch (TransformException ex) {
                        Logging.getLogger(WrappingCoordinateFilter.class).log(Level.WARNING, "Unable to perform transform to detect dateline wrapping", ex);
                    }
                }
                if (wraps) {
                    offset = offset != 0.0 ? 0.0 : this.wrapLimit * 2.0;
                }
            }
            if (offset != 0.0) {
                cs.setOrdinate(i, this.ordinateIdx, ordinate + offset);
            }
            lastOrdinate = ordinate;
        }
        if (ring) {
            cs.setOrdinate(last, this.ordinateIdx, cs.getOrdinate(0, this.ordinateIdx));
        }
    }
}

