/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import org.easymock.EasyMock;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultFeatureResults;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFeatureResultsTest {
    @Test
    public void testMaxFeatureOptimized() throws Exception {
        Query q = new Query("roads");
        q.setMaxFeatures(10);
        SimpleFeatureType type = DataUtilities.createType((String)"roads", (String)"_=the_geom:Point,FID:String,NAME:String");
        SimpleFeatureSource fs = (SimpleFeatureSource)EasyMock.createMock(SimpleFeatureSource.class);
        EasyMock.expect((Object)((SimpleFeatureType)fs.getSchema())).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)fs.getCount(q)).andReturn((Object)20);
        EasyMock.replay((Object[])new Object[]{fs});
        DefaultFeatureResults results = new DefaultFeatureResults(fs, q);
        Assert.assertEquals((long)10L, (long)results.size());
    }

    @Test
    public void testMaxfeaturesHandCount() throws Exception {
        Query q = new Query("roads");
        q.setMaxFeatures(1);
        FeatureReader fr = (FeatureReader)EasyMock.createNiceMock(FeatureReader.class);
        EasyMock.expect((Object)fr.hasNext()).andReturn((Object)true).times(2).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{fr});
        DataStore ds = (DataStore)EasyMock.createMock(DataStore.class);
        EasyMock.expect((Object)ds.getFeatureReader(q, Transaction.AUTO_COMMIT)).andReturn((Object)fr);
        EasyMock.replay((Object[])new Object[]{ds});
        SimpleFeatureType type = DataUtilities.createType((String)"roads", (String)"_=the_geom:Point,FID:String,NAME:String");
        SimpleFeatureSource fs = (SimpleFeatureSource)EasyMock.createMock(SimpleFeatureSource.class);
        EasyMock.expect((Object)((SimpleFeatureType)fs.getSchema())).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)fs.getCount(q)).andReturn((Object)-1);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.replay((Object[])new Object[]{fs});
        DefaultFeatureResults results = new DefaultFeatureResults(fs, q);
        Assert.assertEquals((long)1L, (long)results.size());
    }
}

