/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataTestCase;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.DecoratingDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class DecoratingDataStoreTest
extends DataTestCase {
    SimpleFeatureType riverType;
    SimpleFeature[] riverFeatures;
    ReferencedEnvelope riverBounds;
    Transaction defaultTransaction = new DefaultTransaction();
    MemoryDataStore data;
    MyDecoratingDataStore decorator;

    public void init() throws Exception {
        super.init();
        this.data = new MemoryDataStore();
        this.data.addFeatures(this.roadFeatures);
        this.riverType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)((DataTestCase)this).riverType, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326"));
        this.riverBounds = new ReferencedEnvelope((Envelope)((DataTestCase)this).riverBounds, CRS.decode((String)"EPSG:4326"));
        this.riverFeatures = new SimpleFeature[((DataTestCase)this).riverFeatures.length];
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            this.riverFeatures[i] = SimpleFeatureBuilder.retype((SimpleFeature)((DataTestCase)this).riverFeatures[i], (SimpleFeatureType)this.riverType);
        }
        this.data.addFeatures(this.riverFeatures);
        this.decorator = new MyDecoratingDataStore((DataStore)this.data);
    }

    @After
    public void tearDown() throws Exception {
        this.defaultTransaction.close();
        this.data = null;
        super.tearDown();
    }

    @Test
    public void testUnwrap() {
        Assert.assertSame((Object)this.decorator.unwrap(DataStore.class), (Object)this.data);
        Assert.assertSame((Object)this.decorator.unwrap(DataAccess.class), (Object)this.data);
    }

    @Test
    public void testUnwrapWrongClass() {
        boolean error = false;
        try {
            this.decorator.unwrap(String.class);
        }
        catch (Exception e) {
            error = true;
        }
        Assert.assertTrue((boolean)error);
    }

    @Test
    public void testDataStore() throws IOException {
        Assert.assertEquals((long)2L, (long)this.decorator.getTypeNames().length);
        SimpleFeatureSource featureSource = this.decorator.getFeatureSource(this.riverType.getTypeName());
        Assert.assertNotNull((Object)featureSource);
        Assert.assertEquals((long)this.riverFeatures.length, (long)featureSource.getFeatures().size());
    }

    public static class MyDecoratingDataStore
    extends DecoratingDataStore {
        public MyDecoratingDataStore(DataStore delegate) {
            super(delegate);
        }
    }
}

