/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.data.util.CommonsConverterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommonsConverterFactoryTest {
    CommonsConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new CommonsConverterFactory();
        Locale.setDefault(new Locale("en", "US"));
    }

    @Test
    public void testStringNumberConversion() throws Exception {
        Assert.assertEquals((Object)12, (Object)this.convert("12", Integer.class));
        Assert.assertNull((Object)this.convert("12.0", Integer.class));
        Assert.assertNull((Object)this.convert("12.5", Integer.class));
        Assert.assertNull((Object)this.convert("9223372036854775807", Integer.class));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)this.convert("9223372036854775807", Long.class));
        Assert.assertNull((Object)this.convert("1e100", Long.class));
        Assert.assertNull((Object)this.convert("12.5", Long.class));
        Assert.assertEquals((Object)9.223372036854776E18, (Object)this.convert("9223372036854775807", Double.class));
        Assert.assertEquals((Object)1.0E100, (Object)this.convert("1e100", Double.class));
        Assert.assertEquals((Object)12.5, (Object)this.convert("12.5", Double.class));
        BigDecimal d = new BigDecimal(12345);
        d = d.divide(new BigDecimal(100));
        Assert.assertEquals((Object)d, (Object)this.convert("123.45", BigDecimal.class));
    }

    @Test
    public void testDateConversion() throws Exception {
        Assert.assertEquals((Object)TimeZone.getTimeZone("UTC"), (Object)this.convert("UTC", TimeZone.class));
        Assert.assertNull((Object)this.convert("foobar", TimeZone.class));
        Assert.assertNull((Object)this.factory.createConverter(String.class, TimeZone.class, null).convert(null, TimeZone.class));
    }

    @Test
    public void testTimeZoneConversion() throws Exception {
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse("2011-08-02T00:00:00.000Z"), (Object)this.factory.createConverter(String.class, Date.class, null).convert((Object)"2011-08-02T00:00:00.000Z", Date.class));
        Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ssa").parse("2011-08-02 00:00:00AM"), (Object)this.factory.createConverter(String.class, Date.class, null).convert((Object)"2011-08-02 00:00:00AM", Date.class));
        Assert.assertNull((Object)this.factory.createConverter(String.class, Date.class, null).convert((Object)"2011-08-02", Date.class));
    }

    Object convert(Object source, Class<?> target) throws Exception {
        return this.factory.createConverter(source.getClass(), target, null).convert(source, target);
    }

    @Test
    public void testDataUrlConversion() throws Exception {
        String url = "data:,YQo=";
        Assert.assertNotNull((Object)this.convert(url, URL.class));
    }
}

