/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.util.Set;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import org.geotools.data.util.InterpolationConverterFactory;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;

public class InterpolationConverterFactoryTest
extends Assert {
    private static final Class<Interpolation> INTERPOLATION_CLASS = Interpolation.class;

    @Test
    public void testInterpolationConverterFactory() {
        Set set = Converters.getConverterFactories(String.class, INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)set);
        InterpolationConverterFactoryTest.assertFalse((boolean)set.isEmpty());
        InterpolationConverterFactoryTest.assertEquals((long)set.size(), (long)1L);
        InterpolationConverterFactoryTest.assertSame(((ConverterFactory)set.iterator().next()).getClass(), InterpolationConverterFactory.class);
        InterpolationConverterFactoryTest.assertNull((Object)new InterpolationConverterFactory().createConverter(null, null, null));
        InterpolationConverterFactoryTest.assertNull((Object)new InterpolationConverterFactory().createConverter(String.class, null, null));
        InterpolationConverterFactoryTest.assertNull((Object)new InterpolationConverterFactory().createConverter(String.class, Double.class, null));
    }

    @Test
    public void testInterpolationNearest() {
        Interpolation result = (Interpolation)Converters.convert((Object)"InterpolationNearest", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationNearest.class);
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"Interpolationnearest", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationnearest", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolatioNnearest", INTERPOLATION_CLASS));
    }

    @Test
    public void testInterpolationBilinear() {
        Interpolation result = (Interpolation)Converters.convert((Object)"InterpolationBilinear(2)", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBilinear.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)2);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)2);
        result = (Interpolation)Converters.convert((Object)"InterpolationBilinear(4)", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBilinear.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)4);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)4);
        result = (Interpolation)Converters.convert((Object)"InterpolationBilinear", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBilinear.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)8);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)8);
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationBilinear", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"Interpolationbilinear", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationbilinear", INTERPOLATION_CLASS));
    }

    @Test
    public void testInterpolationBicubic() {
        Interpolation result = (Interpolation)Converters.convert((Object)"InterpolationBicubic(2)", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBicubic.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)2);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)2);
        result = (Interpolation)Converters.convert((Object)"InterpolationBicubic(4)", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBicubic.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)4);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)4);
        result = (Interpolation)Converters.convert((Object)"InterpolationBicubic", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNull((Object)result);
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationBicubic(2)", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"Interpolationbicubic(2)", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationbicubic(2)", INTERPOLATION_CLASS));
    }

    @Test
    public void testInterpolationBicubic2() {
        Interpolation result = (Interpolation)Converters.convert((Object)"InterpolationBicubic2(2)", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBicubic2.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)2);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)2);
        result = (Interpolation)Converters.convert((Object)"InterpolationBicubic2(4)", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNotNull((Object)result);
        InterpolationConverterFactoryTest.assertSame(result.getClass(), InterpolationBicubic2.class);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsH(), (Object)2);
        InterpolationConverterFactoryTest.assertSame((Object)result.getSubsampleBitsV(), (Object)2);
        result = (Interpolation)Converters.convert((Object)"InterpolationBicubic2", INTERPOLATION_CLASS);
        InterpolationConverterFactoryTest.assertNull((Object)result);
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationBicubic2(2)", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"Interpolationbicubic2(2)", INTERPOLATION_CLASS));
        InterpolationConverterFactoryTest.assertNull((Object)Converters.convert((Object)"interpolationbicubic2(2)", INTERPOLATION_CLASS));
    }
}

