/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class BetweenTest {
    protected static final Logger LOGGER = Logging.getLogger(BetweenTest.class);

    @Test
    public void testContains() throws Exception {
        IsBetweenImpl a = new IsBetweenImpl(null, null, null);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setCRS(null);
        ftb.add("value", Integer.class);
        ftb.add("geometry", Geometry.class);
        ftb.setName("testSchema");
        SimpleFeatureType schema = ftb.buildFeatureType();
        a.setExpression1((Expression)new LiteralExpressionImpl((Object)5.0));
        a.setExpression2((Expression)new LiteralExpressionImpl((Object)15.0));
        a.setExpression((Expression)new AttributeExpressionImpl(schema, "value"));
        LOGGER.fine("geometry is " + schema.getDescriptor("geometry"));
        LOGGER.fine("value is " + schema.getDescriptor("value"));
        LOGGER.fine("schema has value in it ? " + (schema.getDescriptor("value") != null));
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{12, gf.createPoint(new Coordinate(12.0, 12.0))}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{3, gf.createPoint(new Coordinate(3.0, 3.0))}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{15, gf.createPoint(new Coordinate(15.0, 15.0))}, null);
        SimpleFeature f4 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{5, gf.createPoint(new Coordinate(5.0, 5.0))}, null);
        SimpleFeature f5 = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])new Object[]{30, gf.createPoint(new Coordinate(30.0, 30.0))}, null);
        Assert.assertTrue((boolean)a.evaluate((Object)f1));
        Assert.assertFalse((boolean)a.evaluate((Object)f2));
        Assert.assertTrue((boolean)a.evaluate((Object)f3));
        Assert.assertTrue((boolean)a.evaluate((Object)f4));
        Assert.assertFalse((boolean)a.evaluate((Object)f5));
    }

    @Test
    public void testEquals() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsBetween f1 = ff.between((Expression)ff.property("abc"), (Expression)ff.literal(10), (Expression)ff.literal(20));
        PropertyIsBetween f2 = ff.between((Expression)ff.property("efg"), (Expression)ff.literal(10), (Expression)ff.literal(20));
        PropertyIsBetween f3 = ff.between((Expression)ff.property("abc"), (Expression)ff.literal(10), (Expression)ff.literal(20));
        Assert.assertEquals((Object)f1, (Object)f3);
        Assert.assertNotEquals((Object)f1, (Object)f2);
    }
}

