/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class EnvFunctionTest {
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @After
    public void tearDown() {
        EnvFunction.clearGlobalValues();
        EnvFunction.clearLocalValues();
    }

    @Test
    public void testSetLocalValues() throws Exception {
        String key1 = "foo";
        String key2 = "bar";
        HashMap<String, Integer> table0 = new HashMap<String, Integer>();
        table0.put("foo", 1);
        table0.put("bar", 2);
        HashMap<String, Integer> table1 = new HashMap<String, Integer>();
        table1.put("foo", 10);
        table1.put("bar", 20);
        final ArrayList<HashMap<String, Integer>> tables = new ArrayList<HashMap<String, Integer>>();
        tables.add(table0);
        tables.add(table1);
        final CountDownLatch latch = new CountDownLatch(2);
        class Task
        implements Runnable {
            private final int threadIndex;

            public Task(int threadIndex) {
                this.threadIndex = threadIndex;
            }

            @Override
            public void run() {
                EnvFunction.setLocalValues((Map)((Map)tables.get(this.threadIndex)));
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                Map table = (Map)tables.get(this.threadIndex);
                for (String name : table.keySet()) {
                    Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)name)}).evaluate(null);
                    int value = ((Number)result).intValue();
                    Assert.assertEquals(table.get(name), (Object)value);
                }
            }
        }
        Future<?> f1 = this.executor.submit(new Task(0));
        Future<?> f2 = this.executor.submit(new Task(1));
        f1.get();
        f2.get();
    }

    @Test
    public void testSetLocalValue() throws Exception {
        String varName = "foo";
        final int[] values = new int[]{1, 2};
        final CountDownLatch latch = new CountDownLatch(2);
        class Task
        implements Runnable {
            private final int threadIndex;

            public Task(int threadIndex) {
                this.threadIndex = threadIndex;
            }

            @Override
            public void run() {
                EnvFunction.setLocalValue((String)"foo", (Object)values[this.threadIndex]);
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)"foo")}).evaluate(null);
                int value = ((Number)result).intValue();
                Assert.assertEquals((long)values[this.threadIndex], (long)value);
            }
        }
        Future<?> f1 = this.executor.submit(new Task(0));
        Future<?> f2 = this.executor.submit(new Task(1));
        f1.get();
        f2.get();
    }

    @Test
    public void testSetGlobalValues() throws Exception {
        final HashMap<String, Integer> table = new HashMap<String, Integer>();
        table.put("foo", 1);
        table.put("bar", 2);
        EnvFunction.setGlobalValues(table);
        final CountDownLatch latch = new CountDownLatch(2);
        class Task
        implements Runnable {
            final String key;

            Task(String key) {
                if (!table.containsKey(key)) {
                    throw new IllegalArgumentException("Invalid arg " + key);
                }
                this.key = key;
            }

            @Override
            public void run() {
                EnvFunction.setGlobalValue((String)this.key, table.get(this.key));
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
                for (String name : table.keySet()) {
                    Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)name)}).evaluate(null);
                    int value = ((Number)result).intValue();
                    Assert.assertEquals(table.get(name), (Object)value);
                }
            }
        }
        Future<?> f1 = this.executor.submit(new Task("foo"));
        Future<?> f2 = this.executor.submit(new Task("bar"));
        f1.get();
        f2.get();
    }

    @Test
    public void testSetGlobalValue() throws Exception {
        String varName = "foo";
        String varValue = "a global value";
        EnvFunction.setGlobalValue((String)"foo", (Object)"a global value");
        class Task
        implements Runnable {
            Task() {
            }

            @Override
            public void run() {
                Object result = EnvFunctionTest.this.ff.function("env", new Expression[]{EnvFunctionTest.this.ff.literal((Object)"foo")}).evaluate(null);
                Assert.assertEquals((Object)"a global value", (Object)result.toString());
            }
        }
        Future<?> f1 = this.executor.submit(new Task());
        Future<?> f2 = this.executor.submit(new Task());
        f1.get();
        f2.get();
    }

    @Test
    public void testCaseInsensitiveGlobalLookup() {
        String varName = "foo";
        String altVarName = "FoO";
        String varValue = "globalCaseTest";
        EnvFunction.setGlobalValue((String)"foo", (Object)"globalCaseTest");
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"FoO")}).evaluate(null);
        Assert.assertEquals((Object)"globalCaseTest", (Object)result.toString());
    }

    @Test
    public void testCaseInsensitiveLocalLookup() {
        String varName = "foo";
        String altVarName = "FoO";
        String varValue = "localCaseTest";
        EnvFunction.setLocalValue((String)"foo", (Object)"localCaseTest");
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"FoO")}).evaluate(null);
        Assert.assertEquals((Object)"localCaseTest", (Object)result.toString());
    }

    @Test
    public void testClearGlobal() {
        String varName = "foo";
        String varValue = "clearGlobal";
        EnvFunction.setGlobalValue((String)"foo", (Object)"clearGlobal");
        EnvFunction.clearGlobalValues();
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}).evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testClearLocal() {
        String varName = "foo";
        String varValue = "clearLocal";
        EnvFunction.setLocalValue((String)"foo", (Object)"clearLocal");
        EnvFunction.clearLocalValues();
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}).evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetArgCount() {
        EnvFunction fn = new EnvFunction();
        Assert.assertEquals((long)1L, (long)fn.getFunctionName().getArgumentCount());
    }

    @Test
    public void testLiteralDefaultValue() {
        int defaultValue = 42;
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"doesnotexist"), this.ff.literal(defaultValue)}).evaluate(null);
        int value = ((Number)result).intValue();
        Assert.assertEquals((long)defaultValue, (long)value);
    }

    @Test
    public void testNonLiteralDefaultValue() {
        int x = 21;
        Add defaultExpr = this.ff.add((Expression)this.ff.literal(x), (Expression)this.ff.literal(x));
        Object result = this.ff.function("env", new Expression[]{this.ff.literal((Object)"doesnotexist"), defaultExpr}).evaluate(null);
        int value = ((Number)result).intValue();
        Assert.assertEquals((long)(x + x), (long)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetFallbackNotAllowed() {
        Logger logger = Logging.getLogger(EnvFunction.class);
        Level level = logger.getLevel();
        try {
            logger.setLevel(Level.INFO);
            SimpleFormatter formatter = new SimpleFormatter();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamHandler handler = new StreamHandler(out, formatter);
            logger.addHandler(handler);
            try {
                EnvFunction function = new EnvFunction();
                function.setFallbackValue(this.ff.literal(0));
                ((Handler)handler).flush();
                String logMsg = out.toString();
                Assert.assertNotNull((Object)logMsg);
                Assert.assertTrue((boolean)logMsg.toLowerCase().contains("setfallbackvalue"));
            }
            finally {
                logger.removeHandler(handler);
            }
        }
        finally {
            logger.setLevel(level);
        }
    }

    @Test
    public void testRemoveEntryFromGlobalDefault() {
        String expectedString = "test";
        EnvFunction.setGlobalValue((String)"foo", (Object)"test");
        this.assertEvalStringEquals(expectedString, this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}));
        String expectedFallback = "does not exist";
        EnvFunction.removeGlobalValue((String)"foo");
        this.assertEvalStringEquals(expectedFallback, this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo"), this.ff.literal((Object)expectedFallback)}));
    }

    @Test
    public void testRemoveEntryFromLocalWithDefault() {
        String expectedString = "test";
        EnvFunction.setLocalValue((String)"foo", (Object)"test");
        this.assertEvalStringEquals(expectedString, this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}));
        String expectedFallback = "does not exist";
        EnvFunction.removeLocalValue((String)"foo");
        this.assertEvalStringEquals(expectedFallback, this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo"), this.ff.literal((Object)expectedFallback)}));
    }

    @Test
    public void testNonExistingKeyEvalIsNilWithoutDefault() {
        boolean isNil = this.ff.isNil((Expression)this.ff.function("env", new Expression[]{this.ff.literal((Object)"not existig key")}), null).evaluate(null);
        Assert.assertTrue((boolean)isNil);
    }

    @Test
    public void testExistingKeyEvalIsNotNil() {
        EnvFunction.setGlobalValue((String)"foo", (Object)"whatever");
        boolean isNil = this.ff.isNil((Expression)this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")}), null).evaluate(null);
        Assert.assertFalse((boolean)isNil);
    }

    @Test
    public void testExistingKeyNullValueAndIsNullGlobal() {
        EnvFunction.setGlobalValue((String)"foo", null);
        boolean isNull = this.ff.isNull((Expression)this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")})).evaluate(null);
        Assert.assertTrue((boolean)isNull);
    }

    @Test
    public void testExistingKeyNullValueAndIsNullLocal() {
        EnvFunction.setLocalValue((String)"foo", null);
        boolean isNull = this.ff.isNull((Expression)this.ff.function("env", new Expression[]{this.ff.literal((Object)"foo")})).evaluate(null);
        Assert.assertTrue((boolean)isNull);
    }

    private void assertEvalStringEquals(String expectedString, Function function) {
        String result = (String)function.evaluate(null);
        Assert.assertEquals((Object)expectedString, (Object)result);
    }

    @Test
    public void testGetLocalValues() {
        String varName = "foo";
        String varValue = "clearLocal";
        EnvFunction.setLocalValue((String)"foo", (Object)"clearLocal");
        Map localValues = EnvFunction.getLocalValues();
        Assert.assertEquals((Object)localValues, Collections.singletonMap("foo".toUpperCase(), "clearLocal"));
        try {
            localValues.put("foo", "fooBar");
            Assert.fail((String)"Should have been read only");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

