/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.EqualAreaListVisitorTest;
import org.geotools.filter.function.EqualAreaFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.NumberRange;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;

@RunWith(value=Enclosed.class)
public class EqualAreaFunctionTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static final Expression PERSONS = FF.property("PERSONS");

    static RangedClassifier assertRangedClassifier(Object classifier) {
        Assert.assertNotNull((Object)classifier);
        MatcherAssert.assertThat((Object)classifier, (Matcher)CoreMatchers.instanceOf(RangedClassifier.class));
        RangedClassifier ranged = (RangedClassifier)classifier;
        for (int i = 1; i < ranged.getSize(); ++i) {
            Assert.assertEquals((double)((Number)ranged.getMin(i)).doubleValue(), (double)((Number)ranged.getMax(i - 1)).doubleValue(), (double)0.0);
        }
        return ranged;
    }

    @RunWith(value=Parameterized.class)
    public static class ParametricBreaksTest {
        @Parameterized.Parameter
        public int numClasses;
        @Parameterized.Parameter(value=1)
        public double tolerance;

        @Parameterized.Parameters(name="Classes: {0}, Tolerance {1}")
        public static Collection<Object[]> data() {
            return Arrays.asList({2, 0.1}, {3, 0.1}, {4, 0.4}, {5, 0.5}, {6, 0.6}, {7, 0.5});
        }

        @Test
        public void testEqualAreaClassification() throws IOException, SchemaException {
            ListFeatureCollection fc = EqualAreaListVisitorTest.getSimplifiedStatesCollection();
            Function areaFunction = EqualAreaFunction.getCartesianAreaFunction();
            double totalArea = EqualAreaListVisitorTest.getTotalArea(fc, (Expression)areaFunction);
            NumberRange<Double> minMax = EqualAreaListVisitorTest.getMinMax(fc, PERSONS);
            Function function = FF.function("EqualArea", new Expression[]{PERSONS, FF.literal(this.numClasses)});
            RangedClassifier rangedClassifier = EqualAreaFunctionTest.assertRangedClassifier(function.evaluate((Object)fc));
            Assert.assertEquals((long)this.numClasses, (long)rangedClassifier.getSize());
            MatcherAssert.assertThat((Object)minMax.getMinimum(), (Matcher)Matchers.equalTo((Object)rangedClassifier.getMin(0)));
            MatcherAssert.assertThat((Object)minMax.getMaximum(), (Matcher)Matchers.equalTo((Object)rangedClassifier.getMax(this.numClasses - 1)));
            LinkedHashMap<And, Double> filterMap = new LinkedHashMap<And, Double>();
            for (int i = 0; i < rangedClassifier.getSize(); ++i) {
                PropertyIsGreaterThanOrEqualTo greater = FF.greaterOrEqual(PERSONS, (Expression)FF.literal(rangedClassifier.getMin(i)));
                Object less = i < rangedClassifier.getSize() - 1 ? FF.less(PERSONS, (Expression)FF.literal(rangedClassifier.getMax(i))) : FF.lessOrEqual(PERSONS, (Expression)FF.literal(rangedClassifier.getMax(i)));
                And filter = FF.and((Filter)greater, (Filter)less);
                filterMap.put(filter, 0.0);
            }
            for (SimpleFeature feature : fc) {
                boolean found = false;
                for (Map.Entry entry : filterMap.entrySet()) {
                    if (!((Filter)entry.getKey()).evaluate((Object)feature)) continue;
                    entry.setValue((Double)entry.getValue() + (Double)areaFunction.evaluate((Object)feature, Double.class));
                    found = true;
                    break;
                }
                Assert.assertTrue((String)("Feature " + feature + " not matched by " + filterMap.keySet()), (boolean)found);
            }
            double averageArea = totalArea / (double)filterMap.size();
            for (Map.Entry entry : filterMap.entrySet()) {
                double d = (Double)entry.getValue();
                double deviation = Math.abs(d - averageArea) / averageArea;
                MatcherAssert.assertThat((Object)deviation, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(this.tolerance)));
            }
        }
    }

    public static class BasicTests {
        @Test
        public void testEmptyCollection() throws SchemaException, IOException {
            ListFeatureCollection empty = new ListFeatureCollection(EqualAreaListVisitorTest.getSimplifiedStatesCollection().getSchema());
            Function function = FF.function("EqualArea", new Expression[]{PERSONS, FF.literal(5)});
            Assert.assertNull((Object)function.evaluate((Object)empty));
        }

        @Test
        public void testMoreClassesThanFeatures() throws SchemaException, IOException {
            ListFeatureCollection fc = EqualAreaListVisitorTest.getSimplifiedStatesCollection();
            Function function = FF.function("EqualArea", new Expression[]{PERSONS, FF.literal(fc.size() * 2)});
            RangedClassifier ranged = EqualAreaFunctionTest.assertRangedClassifier(function.evaluate((Object)fc));
            Assert.assertEquals((long)ranged.getSize(), (long)43L);
        }

        @Test
        public void testSingleBin() throws Exception {
            SimpleFeatureType dataType = DataUtilities.createType((String)"singleBin", (String)"id:0,value:int,geom:Polygon");
            int[] iVal = new int[]{1, 2, 3, 4, 5};
            SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
            Polygon polygon = (Polygon)new WKTReader().read("POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))");
            for (int i = 0; i < iVal.length; ++i) {
                myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i], polygon}, (String)("classification.test1" + (i + 1)));
            }
            SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
            Function function = FF.function("EqualArea", new Expression[]{FF.property("value"), FF.literal(5)});
            RangedClassifier ranged = EqualAreaFunctionTest.assertRangedClassifier(function.evaluate((Object)myFeatureCollection));
            Assert.assertEquals((long)5L, (long)ranged.getSize());
            for (int i = 0; i < 5; ++i) {
                Assert.assertEquals((double)(i + 1), (double)((Number)ranged.getMin(i)).doubleValue(), (double)0.0);
                if (i != 4) {
                    Assert.assertEquals((double)(i + 2), (double)((Number)ranged.getMax(i)).doubleValue(), (double)0.0);
                    Assert.assertEquals((Object)(i + 1 + ".." + (i + 2)), (Object)ranged.getTitle(i));
                    continue;
                }
                Assert.assertEquals((double)(i + 1), (double)((Number)ranged.getMax(i)).doubleValue(), (double)0.0);
                Assert.assertEquals((Object)(i + 1 + ".." + (i + 1)), (Object)ranged.getTitle(i));
            }
        }

        @Test
        public void testConstantValue() throws Exception {
            SimpleFeatureType dataType = DataUtilities.createType((String)"singleBin", (String)"id:0,value:int,geom:Polygon");
            int[] iVal = new int[]{1, 1, 1, 1, 1};
            SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
            Polygon polygon = (Polygon)new WKTReader().read("POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))");
            for (int i = 0; i < iVal.length; ++i) {
                myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i], polygon}, (String)("classification.test1" + (i + 1)));
            }
            SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
            Function function = FF.function("EqualArea", new Expression[]{FF.property("value"), FF.literal(5)});
            RangedClassifier ranged = EqualAreaFunctionTest.assertRangedClassifier(function.evaluate((Object)myFeatureCollection));
            Assert.assertEquals((long)1L, (long)ranged.getSize());
            Assert.assertEquals((Object)1, (Object)ranged.getMin(0));
            Assert.assertEquals((Object)1, (Object)ranged.getMax(0));
        }

        @Test
        public void testEvaluateWithPercentages() throws Exception {
            SimpleFeatureType dataType = DataUtilities.createType((String)"singleBin", (String)"id:0,value:int,geom:Polygon");
            SimpleFeature[] myfeatures = new SimpleFeature[3];
            Polygon polygon = (Polygon)new WKTReader().read("POLYGON ((22.52313252202016 20, 22.47465123810405 19.50776126378972, 22.33107049490801 19.03443898616134, 22.097908019872047 18.598222676801925, 21.78412411615277 18.21587588384723, 21.401777323198075 17.902091980127953, 20.96556101383866 17.66892950509199, 20.49223873621028 17.52534876189595, 20 17.47686747797984, 19.50776126378972 17.52534876189595, 19.03443898616134 17.66892950509199, 18.598222676801925 17.902091980127953, 18.21587588384723 18.21587588384723, 17.902091980127953 18.598222676801925, 17.668929505091988 19.03443898616134, 17.52534876189595 19.50776126378972, 17.47686747797984 20.000000000000004, 17.52534876189595 20.492238736210282, 17.66892950509199 20.965561013838663, 17.902091980127956 21.40177732319808, 18.215875883847232 21.784124116152775, 18.598222676801928 22.097908019872047, 19.034438986161344 22.331070494908012, 19.507761263789728 22.474651238104055, 20.000000000000007 22.52313252202016, 20.492238736210286 22.47465123810405, 20.965561013838666 22.33107049490801, 21.401777323198083 22.09790801987204, 21.78412411615278 21.784124116152764, 22.09790801987205 21.40177732319807, 22.331070494908012 20.965561013838652, 22.474651238104055 20.49223873621027, 22.52313252202016 20))");
            Polygon polygon2 = (Polygon)new WKTReader().read("POLYGON ((95.35237234845832 90, 95.24952801460519 88.95580395498905, 94.94494726312 87.95173577839597, 94.4503349614715 87.02638124715934, 93.78469878303024 86.21530121696976, 92.97361875284066 85.5496650385285, 92.04826422160403 85.05505273688, 91.04419604501095 84.75047198539481, 90 84.64762765154168, 88.95580395498905 84.75047198539481, 87.95173577839597 85.05505273688, 87.02638124715934 85.5496650385285, 86.21530121696976 86.21530121696976, 85.5496650385285 87.02638124715934, 85.05505273688 87.95173577839597, 84.75047198539481 88.95580395498905, 84.64762765154168 90, 84.75047198539482 91.04419604501096, 85.05505273688 92.04826422160403, 85.5496650385285 92.97361875284066, 86.21530121696976 93.78469878303025, 87.02638124715935 94.4503349614715, 87.95173577839599 94.94494726312001, 88.95580395498907 95.24952801460519, 90.00000000000001 95.35237234845832, 91.04419604501096 95.24952801460518, 92.04826422160404 94.94494726312, 92.97361875284068 94.45033496147148, 93.78469878303025 93.78469878303022, 94.45033496147151 92.97361875284065, 94.94494726312001 92.048264221604, 95.24952801460519 91.04419604501093, 95.35237234845832 90))");
            Polygon polygon3 = (Polygon)new WKTReader().read("POLYGON ((95.35237234845832 90, 95.24952801460519 88.95580395498905, 94.94494726312 87.95173577839597, 94.4503349614715 87.02638124715934, 93.78469878303024 86.21530121696976, 92.97361875284066 85.5496650385285, 92.04826422160403 85.05505273688, 91.04419604501095 84.75047198539481, 90 84.64762765154168, 88.95580395498905 84.75047198539481, 87.95173577839597 85.05505273688, 87.02638124715934 85.5496650385285, 86.21530121696976 86.21530121696976, 85.5496650385285 87.02638124715934, 85.05505273688 87.95173577839597, 84.75047198539481 88.95580395498905, 84.64762765154168 90, 84.75047198539482 91.04419604501096, 85.05505273688 92.04826422160403, 85.5496650385285 92.97361875284066, 86.21530121696976 93.78469878303025, 87.02638124715935 94.4503349614715, 87.95173577839599 94.94494726312001, 88.95580395498907 95.24952801460519, 90.00000000000001 95.35237234845832, 91.04419604501096 95.24952801460518, 92.04826422160404 94.94494726312, 92.97361875284068 94.45033496147148, 93.78469878303025 93.78469878303022, 94.45033496147151 92.97361875284065, 94.94494726312001 92.048264221604, 95.24952801460519 91.04419604501093, 95.35237234845832 90))");
            myfeatures[0] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{1, 0, polygon}, (String)"classification.test11");
            myfeatures[1] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{2, 1, polygon2}, (String)"classification.test12");
            myfeatures[2] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{3, 2, polygon3}, (String)"classification.test13");
            SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
            Function function = FF.function("EqualArea", new Expression[]{FF.property("value"), FF.literal(2), FF.literal(1.0), FF.literal(true)});
            RangedClassifier ranged = EqualAreaFunctionTest.assertRangedClassifier(function.evaluate((Object)myFeatureCollection));
            double[] percentages = ranged.getPercentages();
            Assert.assertEquals((long)2L, (long)ranged.getSize());
            Assert.assertEquals((long)2L, (long)percentages.length);
            Assert.assertEquals((double)Math.ceil(percentages[0]), (double)67.0, (double)0.0);
            Assert.assertEquals((double)Math.floor(percentages[1]), (double)33.0, (double)0.0);
        }
    }
}

