/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Arrays;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class FilterFunction_equalToTest {
    protected final GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);

    @Test
    public void testNoMatchActionStrings() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string1"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
        func = ff.function("equalTo", (Expression)ff.literal((Object)"string1"), (Expression)ff.literal((Object)"string2"));
        Assert.assertFalse((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testNoMatchActionNumbers() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(123), (Expression)ff.literal(123));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
        func = ff.function("equalTo", (Expression)ff.literal(123), (Expression)ff.literal(123.0));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
        func = ff.function("equalTo", (Expression)ff.literal(123), (Expression)ff.literal(124));
        Assert.assertFalse((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testAnyMatch() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8)), (Expression)ff.literal(Arrays.asList(1, 2, 3)), (Expression)ff.literal((Object)"ANY"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testAnyMatchArrays() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal((Object)new Integer[]{1, 2, 3, 4, 5, 6, 7, 8}), (Expression)ff.literal((Object)new Integer[]{1, 2, 3}), (Expression)ff.literal((Object)"ANY"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testAnyMatchArrayAndProperty() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.property("value"), (Expression)ff.literal((Object)new Integer[]{1, 2, 3}), (Expression)ff.literal((Object)"ANY"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate((Object)this.feature(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8}))));
    }

    @Test
    public void testAnyMatchPrimitiveArrays() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal((Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8}), (Expression)ff.literal((Object)new int[]{1, 2, 3}), (Expression)ff.literal((Object)"ANY"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testAnyDoesNotMatch() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(Arrays.asList(4, 5, 6, 7, 8)), (Expression)ff.literal(Arrays.asList(1, 2, 3)), (Expression)ff.literal((Object)"ANY"));
        Assert.assertFalse((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testAllMatch() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(Arrays.asList(1, 1, 1)), (Expression)ff.literal(Arrays.asList(1)), (Expression)ff.literal((Object)"ALL"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testAllDoesNotMatch() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(Arrays.asList(1, 1, 3)), (Expression)ff.literal(Arrays.asList(1)), (Expression)ff.literal((Object)"ALL"));
        Assert.assertFalse((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testOneMatch() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(Arrays.asList(1, 2, 3)), (Expression)ff.literal(Arrays.asList(1, 4, 5)), (Expression)ff.literal((Object)"ONE"));
        Assert.assertTrue((boolean)((Boolean)func.evaluate(new Object())));
    }

    @Test
    public void testOneDoesNotMatch() throws Exception {
        FilterFactoryImpl ff = new FilterFactoryImpl();
        Function func = ff.function("equalTo", (Expression)ff.literal(Arrays.asList(1, 2, 3)), (Expression)ff.literal(Arrays.asList(1, 2)), (Expression)ff.literal((Object)"ONE"));
        Assert.assertFalse((boolean)((Boolean)func.evaluate(new Object())));
    }

    protected SimpleFeature feature(Object value) throws Exception {
        String typeSpec = value.getClass().isArray() ? "geom:Point,value:[L" + value.getClass().getComponentType().getName() + ";" : "geom:Point,value:" + value.getClass().getSimpleName();
        SimpleFeatureType type = DataUtilities.createType((String)"Feature", (String)typeSpec);
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        Coordinate coord = new Coordinate(0.0, 0.0);
        builder.add((Object)this.gf.createPoint(coord));
        builder.add(value);
        return builder.buildFeature(null);
    }
}

